/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.static_;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.refinement.framework.ui.SelectionWizard;
import org.polarsys.capella.core.refinement.framework.ui.model.SelectionItemNode;
import org.polarsys.capella.core.refinement.framework.ui.model.TargetSelectionItem;
import org.polarsys.capella.core.refinement.processor.StructureSynchronizationProcessor;
import org.polarsys.capella.core.refinement.scenarios.core.StaticRefinement;

public class StructureSynchronization
extends StaticRefinement {
    public StructureSynchronization() {
    }

    public StructureSynchronization(NamedElement context) {
        this.setContext((ModelElement)context);
    }

    public void setContext(ModelElement context) {
        if (context instanceof AbstractCapabilityPkg || EcoreUtil2.isContainedBy((EObject)context, (EClass)CapellacommonPackage.Literals.ABSTRACT_CAPABILITY_PKG)) {
            ArrayList<AbstractCapability> abstractCapabilities = new ArrayList<AbstractCapability>();
            if (context instanceof AbstractCapability) {
                abstractCapabilities.add((AbstractCapability)context);
            } else if (context instanceof Scenario) {
                abstractCapabilities.add((AbstractCapability)context.eContainer());
            } else {
                Set scSet = EObjectExt.getAll((EObject)context, (EClass)InteractionPackage.Literals.ABSTRACT_CAPABILITY);
                for (EObject obj : scSet) {
                    abstractCapabilities.add((AbstractCapability)obj);
                }
            }
            super.setContext(context);
            this.fillInTargets(abstractCapabilities);
        }
    }

    public Object getName() {
        return null;
    }

    private void fillInTargets(List<AbstractCapability> srcEltSet) {
        Map<NamedElement, List<NamedElement>> targetMap = this.evaluateTarget(srcEltSet);
        for (Map.Entry<NamedElement, List<NamedElement>> entry : targetMap.entrySet()) {
            for (NamedElement target : entry.getValue()) {
                this.addPlug(new StructureSynchronizationProcessor(entry.getKey(), target));
            }
        }
    }

    private Map<NamedElement, List<NamedElement>> evaluateTarget(List<AbstractCapability> capabilities) {
        HashMap<NamedElement, List<NamedElement>> tmpTargets = new HashMap<NamedElement, List<NamedElement>>();
        for (NamedElement namedElement : capabilities) {
            EPBSArchitecture epbs;
            ArrayList<Object> targetSet = new ArrayList<Object>();
            AbstractCapabilityPkg aspectPkg = AbstractCapabilityExt.getOwnerAbstractCapabilityPkg((AbstractCapability)((AbstractCapability)namedElement));
            CapellaElement cpnt = (CapellaElement)aspectPkg.eContainer();
            if (cpnt instanceof SystemAnalysis) {
                for (LogicalArchitecture la : SystemEngineeringExt.getAllLogicalArchitecture((CapellaElement)namedElement)) {
                    targetSet.add(la);
                }
            } else if (cpnt instanceof LogicalArchitecture) {
                LogicalComponent rootLc = SystemEngineeringExt.getRootLogicalComponent((LogicalArchitecture)((LogicalArchitecture)cpnt));
                for (LogicalComponent lc : LogicalComponentExt.getDecompositionLogicalComponentInvolved((LogicalComponent)rootLc)) {
                    targetSet.add(lc);
                }
                PhysicalArchitecture pa = SystemEngineeringExt.getPhysicalArchitecture((CapellaElement)namedElement);
                if (pa != null) {
                    targetSet.add(pa);
                }
            } else if (cpnt instanceof LogicalComponent) {
                for (LogicalComponent lc : LogicalComponentExt.getDecompositionLogicalComponentInvolved((LogicalComponent)((LogicalComponent)cpnt))) {
                    if (!ComponentExt.isComposite((Component)lc)) continue;
                    targetSet.add(lc);
                }
            } else if (cpnt instanceof PhysicalArchitecture && (epbs = SystemEngineeringExt.getEPBSArchitecture((CapellaElement)namedElement)) != null) {
                targetSet.add(epbs);
            }
            tmpTargets.put(namedElement, targetSet);
        }
        return this.selectTarget(tmpTargets);
    }

    private Map<NamedElement, List<NamedElement>> selectTarget(Map<NamedElement, List<NamedElement>> allTargets) {
        HashMap<NamedElement, List<NamedElement>> finalTargets = new HashMap();
        if (!this.choiceIsNeeded(allTargets)) {
            finalTargets = allTargets;
        } else {
            TargetSelectionItem rootItem = new TargetSelectionItem(allTargets);
            String message = "Select the target(s) on which static refinement must be launched.";
            SelectionWizard wizard = new SelectionWizard((SelectionItemNode)rootItem, "Capella wizard", "Refinement target selection", message, true, true);
            if (wizard.open() == 0) {
                for (SelectionItemNode item : wizard.getSelectionList()) {
                    if (!finalTargets.containsKey(item.getSrc())) {
                        finalTargets.put((NamedElement)((AbstractCapability)item.getSrc()), new ArrayList());
                    }
                    if (item.getData() == null) continue;
                    ((List)finalTargets.get(item.getSrc())).add((NamedElement)item.getData());
                }
            }
        }
        return finalTargets;
    }

    private boolean choiceIsNeeded(Map<NamedElement, List<NamedElement>> allTargets) {
        for (Map.Entry<NamedElement, List<NamedElement>> entry : allTargets.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            return true;
        }
        return false;
    }
}

