/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.helpers;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.ExecutionEvent;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.tiger.helpers.NameGenerator;

public class ElementFactory {
    private ElementFactory() {
    }

    public static LogicalComponent createComponent(String componentNameString) {
        LogicalComponent logicalComponent = LaFactory.eINSTANCE.createLogicalComponent(componentNameString);
        return logicalComponent;
    }

    public static Part createInstance(LogicalComponent component, String instanceNameString) {
        Part logicalComponentInstance = CsFactory.eINSTANCE.createPart(instanceNameString);
        component.getOwnedLogicalComponents().add((Object)component);
        return logicalComponentInstance;
    }

    public static SequenceMessage createMessage(Scenario scenario, Part componentInstance1, Part componentInstance2, String messageNameString) {
        return ElementFactory.createMessage(scenario, componentInstance1, componentInstance2, messageNameString, new ArrayList<Event>());
    }

    public static SequenceMessage createMessage(Scenario scenario, Part componentInstance1, Part componentInstance2, String messageNameString, List<Event> listEvents) {
        SequenceMessage message = ElementFactory.createMessageCall(scenario, componentInstance1, componentInstance2, messageNameString, listEvents);
        ElementFactory.createReturnMessage(scenario, message, listEvents);
        return message;
    }

    public static SequenceMessage createMessageCall(Scenario scenario, Part componentInstance1, Part componentInstance2, String messageNameString, List<Event> listEvents) {
        return ElementFactory.createMessageCall(scenario, (AbstractInstance)componentInstance1, (AbstractInstance)componentInstance2, messageNameString, MessageKind.SYNCHRONOUS_CALL, listEvents);
    }

    public static SequenceMessage createAsynchronousMessageCall(Scenario scenario, Part componentInstance1, Part componentInstance2, String messageNameString, List<Event> listEvents, List<AbstractEnd> listExecutionEnds) {
        SequenceMessage message = ElementFactory.createMessageCall(scenario, (AbstractInstance)componentInstance1, (AbstractInstance)componentInstance2, messageNameString, MessageKind.ASYNCHRONOUS_CALL, listEvents);
        Execution execution = InteractionFactory.eINSTANCE.createExecution();
        execution.setStart((InteractionFragment)message.getReceivingEnd());
        ExecutionEnd executionEnd = InteractionFactory.eINSTANCE.createExecutionEnd();
        execution.setFinish((InteractionFragment)executionEnd);
        ExecutionEvent event = InteractionFactory.eINSTANCE.createExecutionEvent();
        executionEnd.setEvent((Event)event);
        listEvents.add((Event)event);
        executionEnd.getCoveredInstanceRoles().add((Object)message.getReceivingEnd().getCovered());
        scenario.getOwnedTimeLapses().add((Object)execution);
        listExecutionEnds.add((AbstractEnd)executionEnd);
        NameGenerator.computeExecutionEndName(executionEnd);
        return message;
    }

    public static SequenceMessage createMessageCall(Scenario scenario, AbstractInstance componentInstance1, AbstractInstance componentInstance2, String messageNameString, MessageKind messageKind, List<Event> listEvents) {
        InstanceRole instanceRole1 = null;
        for (InstanceRole instanceRole : scenario.getOwnedInstanceRoles()) {
            if (instanceRole.getRepresentedInstance() != componentInstance1) continue;
            instanceRole1 = instanceRole;
        }
        if (instanceRole1 == null) {
            instanceRole1 = InteractionFactory.eINSTANCE.createInstanceRole(componentInstance1.getName());
            scenario.getOwnedInstanceRoles().add((Object)instanceRole1);
            instanceRole1.setRepresentedInstance(componentInstance1);
            NameGenerator.computeInstanceRoleName(instanceRole1);
        }
        InstanceRole instanceRole2 = null;
        for (InstanceRole instanceRole : scenario.getOwnedInstanceRoles()) {
            if (instanceRole.getRepresentedInstance() != componentInstance2) continue;
            instanceRole2 = instanceRole;
        }
        if (instanceRole2 == null) {
            instanceRole2 = InteractionFactory.eINSTANCE.createInstanceRole(componentInstance2.getName());
            scenario.getOwnedInstanceRoles().add((Object)instanceRole2);
            instanceRole2.setRepresentedInstance(componentInstance2);
            NameGenerator.computeInstanceRoleName(instanceRole2);
        }
        MessageEnd messageEnd1 = InteractionFactory.eINSTANCE.createMessageEnd();
        MessageEnd messageEnd2 = InteractionFactory.eINSTANCE.createMessageEnd();
        messageEnd1.getCoveredInstanceRoles().add((Object)instanceRole1);
        messageEnd2.getCoveredInstanceRoles().add((Object)instanceRole2);
        SequenceMessage newMessage = InteractionFactory.eINSTANCE.createSequenceMessage(messageNameString);
        newMessage.setSendingEnd(messageEnd1);
        newMessage.setReceivingEnd(messageEnd2);
        newMessage.setKind(messageKind);
        EventSentOperation sentOperation = InteractionFactory.eINSTANCE.createEventSentOperation();
        messageEnd1.setEvent((Event)sentOperation);
        EventReceiptOperation receiveOperation = InteractionFactory.eINSTANCE.createEventReceiptOperation();
        messageEnd2.setEvent((Event)receiveOperation);
        listEvents.add((Event)sentOperation);
        listEvents.add((Event)receiveOperation);
        scenario.getOwnedMessages().add((Object)newMessage);
        scenario.getOwnedInteractionFragments().add((Object)messageEnd1);
        scenario.getOwnedInteractionFragments().add((Object)messageEnd2);
        NameGenerator.computeMessageEndName(messageEnd1);
        NameGenerator.computeMessageEndName(messageEnd2);
        return newMessage;
    }

    public static SequenceMessage createReturnMessage(Scenario scenario, SequenceMessage message) {
        return ElementFactory.createReturnMessage(scenario, message, new ArrayList<Event>());
    }

    public static SequenceMessage createReturnMessage(Scenario scenario, SequenceMessage message, List<Event> listEvents) {
        SequenceMessage newMessage = ElementFactory.createMessageCall(scenario, message.getReceivingEnd().getCovered().getRepresentedInstance(), message.getSendingEnd().getCovered().getRepresentedInstance(), message.getName(), MessageKind.REPLY, listEvents);
        Execution execution = InteractionFactory.eINSTANCE.createExecution();
        execution.setStart((InteractionFragment)message.getReceivingEnd());
        execution.setFinish((InteractionFragment)newMessage.getSendingEnd());
        EventSentOperation sentOperation = InteractionFactory.eINSTANCE.createEventSentOperation();
        newMessage.getSendingEnd().setEvent((Event)sentOperation);
        EventReceiptOperation receiveOperation = InteractionFactory.eINSTANCE.createEventReceiptOperation();
        newMessage.getReceivingEnd().setEvent((Event)receiveOperation);
        listEvents.add((Event)sentOperation);
        listEvents.add((Event)receiveOperation);
        scenario.getOwnedTimeLapses().add((Object)execution);
        NameGenerator.computeExecutionName(execution);
        return newMessage;
    }
}

