/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.compare;

import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureRootNode;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.FragmentModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.compare.ManifestStructureCreator;
import org.eclipse.swt.graphics.Image;

public class PluginStructureCreator
extends StructureCreator {
    public static final int ROOT = 0;
    public static final int LIBRARY = 1;
    public static final int IMPORT = 2;
    public static final int EXTENSION_POINT = 3;
    public static final int EXTENSION = 4;

    protected IStructureComparator createStructureComparator(Object input, IDocument document, ISharedDocumentAdapter adapter, IProgressMonitor monitor) throws CoreException {
        final boolean isEditable = input instanceof IEditableContent ? ((IEditableContent)input).isEditable() : false;
        final PDELabelProvider labelProvider = new PDELabelProvider();
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
        StructureRootNode rootNode = new StructureRootNode(document, input, this, adapter, (ResourceManager)resources){
            private final /* synthetic */ ResourceManager val$resources;
            {
                this.val$resources = resourceManager;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
            }

            public boolean isEditable() {
                return isEditable;
            }

            public void dispose() {
                labelProvider.dispose();
                this.val$resources.dispose();
                super.dispose();
            }
        };
        try {
            this.parsePlugin(input, (DocumentRangeNode)rootNode, document, labelProvider, (ResourceManager)resources, monitor);
        }
        catch (CoreException ex) {
            if (adapter != null) {
                adapter.disconnect(input);
            }
            throw ex;
        }
        return rootNode;
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)node;
            try {
                return ManifestStructureCreator.readString(sca);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String getName() {
        return PDEUIMessages.PluginStructureCreator_name;
    }

    private void parsePlugin(Object input, DocumentRangeNode rootNode, IDocument document, PDELabelProvider labelProvider, ResourceManager resources, IProgressMonitor monitor) throws CoreException {
        boolean isFragment = this.isFragment(input);
        PluginModelBase model = this.createModel(input, document, isFragment);
        if (!model.isLoaded() && model.getStatus().getSeverity() == 4) {
            throw new CoreException(model.getStatus());
        }
        try {
            String id = isFragment ? "fragment" : "plugin";
            ImageDescriptor icon = isFragment ? PDEPluginImages.DESC_FRAGMENT_MF_OBJ : PDEPluginImages.DESC_PLUGIN_MF_OBJ;
            PluginNode parent = new PluginNode(rootNode, 0, id, resources.createImage(icon), document, 0, document.getLength());
            this.createChildren(parent, model, labelProvider, resources);
        }
        finally {
            model.dispose();
        }
    }

    private boolean isFragment(Object input) {
        return input instanceof ITypedElement && ((ITypedElement)input).getName().equals("fragment.xml");
    }

    private PluginModelBase createModel(Object input, IDocument document, boolean isFragment) throws CoreException {
        Object model = null;
        model = isFragment ? new FragmentModel(document, false) : new PluginModel(document, false);
        model.setCharset(this.getCharset(input));
        model.load();
        return model;
    }

    private String getCharset(Object input) throws CoreException {
        if (input instanceof IEncodedStreamContentAccessor) {
            return ((IEncodedStreamContentAccessor)input).getCharset();
        }
        return ResourcesPlugin.getEncoding();
    }

    private void createChildren(DocumentRangeNode rootNode, PluginModelBase model, PDELabelProvider labelProvider, ResourceManager resources) {
        this.createLibraries(rootNode, model, labelProvider, resources);
        this.createImports(rootNode, model, labelProvider, labelProvider, resources);
        this.createExtensionPoints(rootNode, model, labelProvider, resources);
        this.createExtensions(rootNode, model, labelProvider, resources);
    }

    private void createLibraries(DocumentRangeNode parent, PluginModelBase model, PDELabelProvider labelProvider, ResourceManager resources) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int type = 1;
        IPluginLibrary[] iPluginLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary pluginLibrary = iPluginLibraryArray[n2];
            this.createNode(parent, type, pluginLibrary, labelProvider, resources);
            ++n2;
        }
    }

    private void createImports(DocumentRangeNode parent, PluginModelBase model, PDELabelProvider labelProvider, PDELabelProvider labelProvider2, ResourceManager resources) {
        IPluginImport[] imports = model.getPluginBase().getImports();
        int type = 2;
        IPluginImport[] iPluginImportArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport pluginImport = iPluginImportArray[n2];
            this.createNode(parent, type, pluginImport, labelProvider, resources);
            ++n2;
        }
    }

    private void createExtensionPoints(DocumentRangeNode parent, PluginModelBase model, PDELabelProvider labelProvider, ResourceManager resources) {
        IPluginExtensionPoint[] extensionPoints = model.getPluginBase().getExtensionPoints();
        int type = 3;
        IPluginExtensionPoint[] iPluginExtensionPointArray = extensionPoints;
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint extensionPoint = iPluginExtensionPointArray[n2];
            this.createNode(parent, type, extensionPoint, labelProvider, resources);
            ++n2;
        }
    }

    private void createExtensions(DocumentRangeNode parent, PluginModelBase model, PDELabelProvider labelProvider, ResourceManager resources) {
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int type = 4;
        IPluginExtension[] iPluginExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            this.createNode(parent, type, extension, labelProvider, resources);
            ++n2;
        }
    }

    private void createNode(DocumentRangeNode parent, int type, Object element, PDELabelProvider labelProvider, ResourceManager resources) {
        if (element instanceof IDocumentElementNode) {
            IDocumentElementNode node = (IDocumentElementNode)element;
            ImageDescriptor imageDescriptor = this.getImageDescriptor(element);
            Image image = null;
            if (imageDescriptor != null) {
                image = resources.createImage(imageDescriptor);
            }
            new PluginNode(parent, type, labelProvider.getText(element), image, parent.getDocument(), node.getOffset(), node.getLength());
        }
    }

    private ImageDescriptor getImageDescriptor(Object element) {
        if (element instanceof IPluginImport) {
            return PDEPluginImages.DESC_REQ_PLUGIN_OBJ;
        }
        if (element instanceof IPluginLibrary) {
            return PDEPluginImages.DESC_JAVA_LIB_OBJ;
        }
        if (element instanceof IPluginExtension) {
            return PDEPluginImages.DESC_EXTENSION_OBJ;
        }
        if (element instanceof IPluginExtensionPoint) {
            return PDEPluginImages.DESC_EXT_POINT_OBJ;
        }
        return null;
    }

    static class PluginNode
    extends DocumentRangeNode
    implements ITypedElement {
        private final Image image;

        public PluginNode(DocumentRangeNode parent, int type, String id, Image image, IDocument doc, int start, int length) {
            super(parent, type, id, doc, start, length);
            this.image = image;
            if (parent != null) {
                parent.addChild((DocumentRangeNode)this);
            }
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "PLUGIN2";
        }

        public Image getImage() {
            return this.image;
        }
    }
}

