/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BasePackageHeader;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleTextChangeListener;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.ui.refactoring.MoveFromChange;
import org.eclipse.pde.internal.ui.util.LocaleUtil;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class BundleManifestChange {
    public static Change createMoveToPackageChange(IFile file, MoveFromChange change, IProgressMonitor monitor) throws CoreException {
        try {
            Bundle bundle = BundleManifestChange.getBundle(file, monitor);
            if (bundle == null) {
                return null;
            }
            BundleModel model = (BundleModel)bundle.getModel();
            BundleTextChangeListener listener = new BundleTextChangeListener(model.getDocument());
            bundle.getModel().addModelChangedListener((IModelChangedListener)listener);
            BundleManifestChange.addPackage(bundle, change);
            Change change2 = BundleManifestChange.createChange(listener, file);
            return change2;
        }
        catch (CoreException coreException) {
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.NORMALIZE, monitor);
        }
        return null;
    }

    public static MoveFromChange createMovePackageChange(IFile file, Object[] elements, IProgressMonitor monitor) throws CoreException {
        try {
            Bundle bundle = BundleManifestChange.getBundle(file, monitor);
            if (bundle == null) {
                return null;
            }
            BundleModel model = (BundleModel)bundle.getModel();
            BundleTextChangeListener listener = new BundleTextChangeListener(model.getDocument());
            bundle.getModel().addModelChangedListener((IModelChangedListener)listener);
            ArrayList<PDEManifestElement> list = new ArrayList<PDEManifestElement>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IJavaElement) {
                    String packageName = ((IJavaElement)element).getElementName();
                    PDEManifestElement export = BundleManifestChange.removePackage(bundle.getManifestHeader("Export-Package"), packageName);
                    if (export != null) {
                        list.add(export);
                    }
                }
                ++n2;
            }
            TextEdit[] operations = listener.getTextOperations();
            if (operations.length > 0) {
                MoveFromChange change = new MoveFromChange("", file);
                MultiTextEdit edit = new MultiTextEdit();
                edit.addChildren(operations);
                change.setEdit((TextEdit)edit);
                PDEModelUtility.setChangeTextType(change, file);
                if (list.size() > 0) {
                    change.setMovedElements(list.toArray(new PDEManifestElement[list.size()]));
                }
                MoveFromChange moveFromChange = change;
                return moveFromChange;
            }
        }
        catch (CoreException coreException) {
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.NORMALIZE, monitor);
        }
        return null;
    }

    public static Change createRenameChange(IFile file, Object[] elements, String[] newTexts, IProgressMonitor monitor) throws CoreException {
        try {
            Bundle bundle = BundleManifestChange.getBundle(file, monitor);
            if (bundle == null) {
                return null;
            }
            BundleModel model = (BundleModel)bundle.getModel();
            BundleTextChangeListener listener = new BundleTextChangeListener(model.getDocument());
            bundle.getModel().addModelChangedListener((IModelChangedListener)listener);
            boolean localizationRenamed = false;
            int i = 0;
            while (i < elements.length) {
                String oldText;
                Object element = elements[i];
                String newText = newTexts[i];
                if (element instanceof IFile) {
                    String fileName = ((IFile)element).getProjectRelativePath().toString();
                    if (!localizationRenamed && fileName.endsWith(".properties")) {
                        String oldText2 = fileName.substring(0, fileName.lastIndexOf("."));
                        String oldLocalization = bundle.getLocalization();
                        if (LocaleUtil.trimLocalization(oldText2).equals(oldLocalization)) {
                            BundleManifestChange.renameLocalization(bundle, oldText2, newText);
                            localizationRenamed = true;
                        }
                    }
                } else if (element instanceof IType) {
                    oldText = ((IType)element).getFullyQualifiedName('$');
                    BundleManifestChange.resetHeaderValue(bundle.getManifestHeader("Bundle-Activator"), false, oldText, newText);
                    BundleManifestChange.resetHeaderValue(bundle.getManifestHeader("Plugin-Class"), false, oldText, newText);
                } else if (element instanceof IPackageFragment) {
                    oldText = ((IPackageFragment)element).getElementName();
                    BundleManifestChange.resetHeaderValue(bundle.getManifestHeader("Bundle-Activator"), true, oldText, newText);
                    BundleManifestChange.resetHeaderValue(bundle.getManifestHeader("Plugin-Class"), true, oldText, newText);
                    BundleManifestChange.renamePackage(bundle.getManifestHeader("Export-Package"), oldText, newText);
                    BundleManifestChange.renamePackage(bundle.getManifestHeader("Provide-Package"), oldText, newText);
                    BundleManifestChange.renamePackage(bundle.getManifestHeader("Import-Package"), oldText, newText);
                }
                ++i;
            }
            Change change = BundleManifestChange.createChange(listener, file);
            return change;
        }
        catch (CoreException coreException) {
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.NORMALIZE, monitor);
        }
        return null;
    }

    private static Change createChange(BundleTextChangeListener listener, IFile file) {
        TextEdit[] operations = listener.getTextOperations();
        if (operations.length > 0) {
            TextFileChange change = new TextFileChange("", file);
            MultiTextEdit edit = new MultiTextEdit();
            edit.addChildren(operations);
            change.setEdit((TextEdit)edit);
            PDEModelUtility.setChangeTextType(change, file);
            return change;
        }
        return null;
    }

    private static void renameLocalization(Bundle bundle, String oldText, String newText) {
        if (newText.endsWith(".properties")) {
            bundle.setHeader("Bundle-Localization", LocaleUtil.trimLocalization(newText));
        } else {
            bundle.setHeader("Bundle-Localization", null);
        }
    }

    private static void resetHeaderValue(IManifestHeader header, boolean isPackage, String oldText, String newText) {
        String value;
        if (header != null && (oldText.equals(value = header.getValue()) || BundleManifestChange.isGoodMatch(value, oldText, isPackage))) {
            StringBuffer buffer = new StringBuffer(newText);
            buffer.append(value.substring(oldText.length()));
            header.setValue(buffer.toString());
        }
    }

    private static boolean isGoodMatch(String value, String oldName, boolean isPackage) {
        boolean goodLengthMatch;
        if (value == null || value.length() <= oldName.length()) {
            return false;
        }
        boolean bl = isPackage ? value.lastIndexOf(46) <= oldName.length() : (goodLengthMatch = value.charAt(oldName.length()) == '$');
        return value.startsWith(oldName) && goodLengthMatch;
    }

    private static void renamePackage(IManifestHeader header, String oldName, String newName) {
        if (header instanceof BasePackageHeader) {
            BasePackageHeader bHeader = (BasePackageHeader)header;
            bHeader.renamePackage(oldName, newName);
        }
    }

    private static PDEManifestElement removePackage(IManifestHeader header, String name) {
        PackageObject result = null;
        if (header instanceof BasePackageHeader) {
            BasePackageHeader bHeader = (BasePackageHeader)header;
            result = (PackageObject)bHeader.removePackage(name);
        }
        return result;
    }

    private static void addPackage(Bundle bundle, MoveFromChange change) {
        String headerName = BundleManifestChange.getExportedPackageHeader((IBundle)bundle);
        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader(headerName);
        ManifestElement[] elements = change.getMovedElements();
        int i = 0;
        while (i < elements.length) {
            if (header != null) {
                if (!header.hasPackage(change.getPackageName(i))) {
                    header.addPackage((PackageObject)new ExportPackageObject((ManifestHeader)header, elements[i], BundleManifestChange.getVersionAttribute(header.getBundle())));
                }
            } else {
                bundle.setHeader(headerName, change.getMovedText(i));
                header = (ExportPackageHeader)bundle.getManifestHeader(headerName);
            }
            ++i;
        }
    }

    private static String getVersionAttribute(IBundle bundle) {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)bundle);
        return manifestVersion < 2 ? "specification-version" : "version";
    }

    private static String getExportedPackageHeader(IBundle bundle) {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)bundle);
        return manifestVersion < 2 ? "Provide-Package" : "Export-Package";
    }

    public static Bundle getBundle(IFile file, IProgressMonitor monitor) throws CoreException, MalformedTreeException, BadLocationException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(file.getFullPath(), LocationKind.NORMALIZE, monitor);
        IDocument document = manager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE).getDocument();
        BundleModel model = new BundleModel(document, false);
        model.load();
        return model.isLoaded() ? (Bundle)model.getBundle() : null;
    }
}

