/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.ctx;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;

public class GetAvailable_Actor_UsedInterfaces
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        if (systemEngineering == null) {
            return availableElements;
        }
        if (element instanceof Actor) {
            Actor currentActor = (Actor)element;
            availableElements.addAll(this.getInterfacesFromSystemEngineering(currentActor, systemEngineering));
            availableElements.addAll(this.getAllInterfacesFromShared(currentActor, systemEngineering));
        }
        return availableElements;
    }

    private List<CapellaElement> getInterfacesFromSystemEngineering(Actor currentActor, SystemEngineering systemEngineering) {
        OperationalAnalysis oa;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        SystemAnalysis sa = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
        if (sa != null) {
            availableElements.addAll(InterfacePkgExt.getAllInterfaces((InterfacePkg)sa.getOwnedInterfacePkg()));
        }
        if ((oa = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering)) != null) {
            availableElements.addAll(InterfacePkgExt.getAllInterfaces((InterfacePkg)oa.getOwnedInterfacePkg()));
        }
        List allActors = ActorPkgExt.getAllActors((ActorPkg)SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering).getOwnedActorPkg());
        for (Actor actor : allActors) {
            availableElements.addAll(InterfacePkgExt.getAllInterfaces((InterfacePkg)actor.getOwnedInterfacePkg()));
        }
        return availableElements;
    }

    private List<CapellaElement> getAllInterfacesFromShared(Actor currentActor, SystemEngineering systemEngineering) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        return availableElements;
    }
}

