/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.ReuseLink;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.sharedmodel.GenericPkg;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.GenericPkgExt;
import org.polarsys.capella.core.model.helpers.ServiceExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_Service_ThrownException
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        ArrayList<EObject> availableElements = new ArrayList(1);
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        boolean isServiceFromSharedPkg = false;
        if (systemEngineering == null) {
            SharedPkg sharedPkg = SystemEngineeringExt.getSharedPkg((CapellaElement)element);
            if (sharedPkg != null) {
                for (ReuseLink link : sharedPkg.getReuseLinks()) {
                    if (SystemEngineeringExt.getSystemEngineering((CapellaElement)link) == null) continue;
                    systemEngineering = SystemEngineeringExt.getSystemEngineering((CapellaElement)link);
                    isServiceFromSharedPkg = true;
                    break;
                }
            }
            if (systemEngineering == null) {
                return availableElements;
            }
        }
        if (element instanceof Service) {
            Service currentService = (Service)element;
            if (!isServiceFromSharedPkg) {
                availableElements.addAll(this.getRule_MQRY_Service_Throw_11(currentService));
                availableElements.addAll(this.getRule_MQRY_Service_Throw_12(currentService));
            }
            availableElements.addAll(this.getRule_MQRY_Service_Throw_13(currentService, systemEngineering));
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Service_Throw_11(Service currentService) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        availableElements.addAll(ServiceExt.getFilteredExceptions((Service)currentService, (List)ServiceExt.getExceptionsFromRootComponentArchitecture((Service)currentService)));
        availableElements.addAll(ServiceExt.getFilteredExceptions((Service)currentService, (List)ServiceExt.getExceptionsFromRootComponent((Service)currentService)));
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Service_Throw_12(Service currentService) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        availableElements.addAll(ServiceExt.getFilteredExceptions((Service)currentService, (List)ServiceExt.getExceptionsFromParentHierarchy((Service)currentService)));
        availableElements.addAll(this.getRule_MQRY_Service_Throw_12_1(currentService));
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Service_Throw_13(Service currentService, SystemEngineering systemEngineering) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        for (SharedPkg sharedPkg : SystemEngineeringExt.getSharedPkgs((SystemEngineering)systemEngineering)) {
            DataPkg dataPkg;
            GenericPkg pkg = sharedPkg.getOwnedGenericPkg();
            if (pkg != null) {
                availableElements.addAll(ServiceExt.getFilteredExceptions((Service)currentService, (List)GenericPkgExt.getAllExceptions((GenericPkg)pkg)));
            }
            if ((dataPkg = sharedPkg.getOwnedDataPkg()) == null) continue;
            availableElements.addAll(ServiceExt.getFilteredExceptions((Service)currentService, (List)DataPkgExt.getAllExceptions((DataPkg)dataPkg)));
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Service_Throw_12_1(Service currentService) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        ComponentArchitecture arch = ServiceExt.getRootComponentArchitecture((Service)currentService);
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)currentService);
        SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
        availableElements.addAll(ServiceExt.getExceptionsFromComponentArchitecture((ComponentArchitecture)ca));
        if (arch != null) {
            if (arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                availableElements.addAll(ServiceExt.getExceptionsFromComponentArchitecture((ComponentArchitecture)SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering)));
            }
            if (arch instanceof EPBSArchitecture) {
                availableElements.addAll(ServiceExt.getExceptionsFromComponentArchitecture((ComponentArchitecture)SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering)));
            }
        }
        return availableElements;
    }
}

