/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.interaction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.ScenarioRealization;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class GetAvailable_Scenario_RealizedScenario
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        BlockArchitecture currentBlockArchitecture = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        if (currentBlockArchitecture != null) {
            List previousBlockArchitectures = BlockArchitectureExt.getPreviousBlockArchitectures((BlockArchitecture)currentBlockArchitecture);
            if (!previousBlockArchitectures.isEmpty()) {
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)previousBlockArchitectures.get(previousBlockArchitectures.size() - 1), (Scenario)element));
            }
            availableElements.addAll(this.getElementsFromBlockArchitecture(currentBlockArchitecture, (Scenario)element));
        }
        availableElements.remove(element);
        for (CapellaElement elt : this.getCurrentElements(element, false)) {
            availableElements.remove(elt);
        }
        return availableElements;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, Scenario scenario) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        ScenarioKind kind = scenario.getKind();
        if (kind == ScenarioKind.UNSET) {
            return availableElements;
        }
        TreeIterator allContents = EcoreUtil.getAllContents((EObject)arch, (boolean)true);
        EObject eobject = null;
        while (allContents.hasNext()) {
            eobject = (EObject)allContents.next();
            if (!(eobject instanceof Scenario) || !ScenarioExt.canRealize((Scenario)scenario, (Scenario)((Scenario)eobject))) continue;
            availableElements.add((CapellaElement)eobject);
        }
        return availableElements;
    }

    public List<CapellaElement> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        if (element instanceof Scenario) {
            for (ScenarioRealization realization : ((Scenario)element).getOwnedScenarioRealization()) {
                currentElements.add((CapellaElement)realization.getTargetElement());
            }
        }
        return currentElements;
    }
}

