/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.util;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.providers.DiscriminatingLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public final class PatternsInstancesUIUtil {
    private PatternsInstancesUIUtil() {
    }

    public static String getInstanceAsText(IPatternInstance instance_p) {
        StringBuilder builder = new StringBuilder();
        IPattern pattern = instance_p.getPattern();
        boolean notLoaded = pattern == null;
        builder.append("Involving : ");
        for (EObject obj : instance_p.getElements()) {
            EList attrs = obj.eClass().getEAllAttributes();
            for (EAttribute attr : attrs) {
                if (!"name".equals(attr.getName())) continue;
                builder.append("# " + (String)obj.eGet((EStructuralFeature)attr));
            }
        }
        String result = builder.toString();
        if (notLoaded) {
            result = UIUtil.markAsNotLoaded(result);
        }
        return result;
    }

    public static String getPatternAsText(IPatternInstance instance_p) {
        boolean notLoaded;
        StringBuilder builder = new StringBuilder();
        IPattern pattern = instance_p.getPattern();
        boolean bl = notLoaded = pattern == null;
        String patternName = notLoaded ? (instance_p.getPatternVersion() != null ? instance_p.getPatternVersion().getPatternSymbol().getName() : null) : DiscriminatingLabelProvider.getInstance().getText(pattern);
        if (patternName != null) {
            builder.append(patternName);
            builder.append("  (v");
            builder.append(instance_p.getPatternVersion().getVersion());
            builder.append(')');
        }
        String result = null;
        if (patternName == null) {
            result = "Pattern Not Found";
        } else {
            result = builder.toString();
            if (notLoaded) {
                result = UIUtil.markAsNotLoaded(result);
            }
        }
        return result;
    }

    public static String getRolesAsText(IPatternInstance instance_p, EObject referenceElement_p, String unknownMessage_p, String noRoleMessage_p) {
        String result = unknownMessage_p;
        if (referenceElement_p != null && instance_p.getPattern() != null) {
            Collection roles = instance_p.getPatternData() instanceof TemplatePatternData ? ((TemplatePatternData)instance_p.getPatternData()).getRolesOf(referenceElement_p) : instance_p.getRolesOf(referenceElement_p);
            result = !roles.isEmpty() ? UIUtil.buildStringWith(roles, ", ", null, null) : noRoleMessage_p;
        }
        return result;
    }

    public static void informNoPatternSupport(Shell shell_p) {
        MessageDialog.openError((Shell)shell_p, (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.AbstractModelBasedAction_MissingPatternSupport);
    }
}

