/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.internal.navigate.NavigationAdvisor;

public class SemanticLocateInCapellaExplorerAction
extends LocateInCapellaExplorerAction {
    protected boolean isEnabled(ISelection selection) {
        Object element;
        boolean result = false;
        if (!selection.isEmpty() && (element = SemanticLocateInCapellaExplorerAction.getElement(this.getFirstSelectedElement(selection))) != null) {
            Set<EObject> navigableElements = NavigationAdvisor.getInstance().getNavigableElements((ModelElement)element);
            result = !navigableElements.isEmpty();
        }
        return result;
    }

    @Override
    public void run(IAction action) {
        HashSet<EObject> navigableElements = new HashSet<EObject>();
        if (this.getSelection() instanceof IStructuredSelection) {
            for (Object selectedElement : ((IStructuredSelection)this.getSelection()).toList()) {
                navigableElements.addAll(NavigationAdvisor.getInstance().getNavigableElements(selectedElement));
            }
        }
        if (!navigableElements.isEmpty()) {
            this.selectElementInCapellaExplorer((ISelection)new StructuredSelection(navigableElements.toArray()));
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action != null) {
            action.setEnabled(this.isEnabled(selection));
        }
    }
}

