/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.internal.navigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.datavalue.AbstractBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractEnumerationValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractStringValue;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.EnumerationReference;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.datavalue.StringReference;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioRealization;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.model.handler.AbstractModelElementRunnable;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;

public class NavigationAdvisor {
    private static Map<Class<?>, AbstractModelElementRunnable> __handledNavigations;
    private static NavigationAdvisor __singleton;

    private NavigationAdvisor() {
        this.initializeNavigations();
    }

    public Set<EObject> getNavigableElements(Object receiver) {
        HashSet<EObject> navigableElements = new HashSet<EObject>(0);
        if (receiver instanceof IMarker) {
            navigableElements.addAll(MarkerViewHelper.getModelElementsFromMarker((IMarker)((IMarker)receiver)));
        } else {
            List<AbstractModelElementRunnable> navigationHandlers;
            EObject element = CapellaAdapterHelper.resolveSemanticObject((Object)receiver, (boolean)true);
            if (element != null && !(navigationHandlers = this.getNavigationHandler(element)).isEmpty()) {
                for (AbstractModelElementRunnable modelElementRunnable : navigationHandlers) {
                    modelElementRunnable.setElement(element);
                    modelElementRunnable.run();
                    navigableElements.addAll(modelElementRunnable.getResult());
                }
            }
        }
        navigableElements.remove(null);
        return navigableElements;
    }

    private List<AbstractModelElementRunnable> getNavigationHandler(EObject element) {
        ArrayList<AbstractModelElementRunnable> result = new ArrayList<AbstractModelElementRunnable>(0);
        Class<?> elementClass = element.getClass();
        AbstractModelElementRunnable navigationHandler = __handledNavigations.get(elementClass);
        if (navigationHandler == null) {
            for (Map.Entry<Class<?>, AbstractModelElementRunnable> entry : __handledNavigations.entrySet()) {
                if (!entry.getKey().isInstance(element)) continue;
                result.add(entry.getValue());
            }
        } else {
            result.add(navigationHandler);
        }
        return result;
    }

    List<EObject> handleAbstractFunctionalBlockNavigation(AbstractFunctionalBlock block) {
        return new ArrayList<EObject>((Collection<EObject>)block.getAllocatedFunctions());
    }

    List<EObject> handleAbstractFunctionNavigation(AbstractFunction function) {
        ArrayList<EObject> allocationBlocks = new ArrayList<EObject>();
        if (FunctionExt.isLeaf((AbstractFunction)function)) {
            allocationBlocks.addAll((Collection<EObject>)function.getAllocationBlocks());
        } else {
            allocationBlocks.addAll(AbstractFunctionExt.getMotherFunctionAllocation((AbstractFunction)function));
        }
        return allocationBlocks;
    }

    List<EObject> handleAbstractTraceNavigation(AbstractTrace trace) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        TraceableElement targetElement = trace.getTargetElement();
        if (targetElement != null) {
            nagivations.add((EObject)targetElement);
        }
        return nagivations;
    }

    List<EObject> handleAbstractTypedElementNavigation(AbstractTypedElement typedElement) {
        ArrayList<EObject> navigateTowardsElement = new ArrayList<EObject>(0);
        AbstractType abstractType = typedElement.getAbstractType();
        if (abstractType != null) {
            navigateTowardsElement.add((EObject)abstractType);
        }
        return navigateTowardsElement;
    }

    List<EObject> handleActorNavigation(Actor actor) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        nagivations.addAll((Collection<EObject>)actor.getContributedCapabilities());
        nagivations.addAll((Collection<EObject>)actor.getContributedMissions());
        nagivations.addAll((Collection<EObject>)actor.getSub());
        nagivations.addAll((Collection<EObject>)actor.getSuper());
        return nagivations;
    }

    List<EObject> handleBooleanReferenceNavigation(BooleanReference reference) {
        Property referencedProperty;
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        AbstractBooleanValue referencedValue = reference.getReferencedValue();
        if (referencedValue != null) {
            nagivations.add((EObject)referencedValue);
        }
        if ((referencedProperty = reference.getReferencedProperty()) != null) {
            nagivations.add((EObject)referencedProperty);
        }
        return nagivations;
    }

    List<EObject> handleCapabilityNavigation(Capability capability) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        nagivations.addAll((Collection<EObject>)capability.getParticipatingActors());
        nagivations.addAll((Collection<EObject>)capability.getPurposeMissions());
        return nagivations;
    }

    List<EObject> handleCollectionNavigation(org.polarsys.capella.core.data.information.Collection collection) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        Type type = collection.getType();
        if (type != null) {
            nagivations.add((EObject)type);
        }
        return nagivations;
    }

    List<EObject> handleCommunicationLinkNavigation(CommunicationLink communicationLink) {
        ArrayList<EObject> navigateTowardsElement = new ArrayList<EObject>(0);
        ExchangeItem exchangeItem = communicationLink.getExchangeItem();
        if (exchangeItem != null) {
            navigateTowardsElement.add((EObject)exchangeItem);
        }
        return navigateTowardsElement;
    }

    List<EObject> handleComponentNavigation(Component component) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        nagivations.addAll((Collection<EObject>)component.getImplementedInterfaces());
        nagivations.addAll((Collection<EObject>)component.getProvidedInterfaces());
        nagivations.addAll((Collection<EObject>)component.getUsedInterfaces());
        nagivations.addAll((Collection<EObject>)component.getRequiredInterfaces());
        for (AbstractTrace trace : component.getOutgoingTraces()) {
            if (!(trace instanceof ComponentAllocation) || trace.getTargetElement() == null) continue;
            nagivations.add((EObject)trace.getTargetElement());
        }
        return nagivations;
    }

    List<EObject> handleEnumerationReferenceNavigation(EnumerationReference reference) {
        Property referencedProperty;
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        AbstractEnumerationValue referencedValue = reference.getReferencedValue();
        if (referencedValue != null) {
            nagivations.add((EObject)referencedValue);
        }
        if ((referencedProperty = reference.getReferencedProperty()) != null) {
            nagivations.add((EObject)referencedProperty);
        }
        return nagivations;
    }

    List<EObject> handleExchangeItemAllocationNavigation(ExchangeItemAllocation exchItemAllocation) {
        ArrayList<EObject> navigateTowardsElement = new ArrayList<EObject>(0);
        ExchangeItem allocatedItem = exchItemAllocation.getAllocatedItem();
        if (allocatedItem != null) {
            navigateTowardsElement.add((EObject)allocatedItem);
        }
        return navigateTowardsElement;
    }

    List<EObject> handleExchangeItemElementNavigation(ExchangeItemElement exchangeItemElement) {
        ArrayList<EObject> navigateTowardsElement = new ArrayList<EObject>(0);
        AbstractType type = exchangeItemElement.getAbstractType();
        if (type != null) {
            navigateTowardsElement.add((EObject)type);
        }
        return navigateTowardsElement;
    }

    List<EObject> handleFunctionalExchangeNavigation(FunctionalExchange exchange) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        EList exchangedItems = exchange.getExchangedItems();
        EList categories = exchange.getCategories();
        if (!exchangedItems.isEmpty()) {
            nagivations.addAll((Collection<EObject>)exchangedItems);
        }
        if (!categories.isEmpty()) {
            nagivations.addAll((Collection<EObject>)categories);
        }
        return nagivations;
    }

    List<EObject> handleGeneralizableElementNavigation(GeneralizableElement element) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        nagivations.addAll((Collection<EObject>)element.getSub());
        nagivations.addAll((Collection<EObject>)element.getSuper());
        return nagivations;
    }

    List<EObject> handleInstanceRoleNavigation(InstanceRole instanceRole) {
        ArrayList<EObject> navigateTowardsElement = new ArrayList<EObject>(0);
        AbstractInstance instance = instanceRole.getRepresentedInstance();
        if (instance != null) {
            if (instance instanceof AbstractFunction) {
                navigateTowardsElement.add((EObject)instance);
            }
            if (instance instanceof Role) {
                navigateTowardsElement.add((EObject)instance);
            } else {
                AbstractType type = instance.getAbstractType();
                if (type != null) {
                    navigateTowardsElement.add((EObject)type);
                    navigateTowardsElement.add((EObject)instance);
                }
            }
        }
        return navigateTowardsElement;
    }

    List<EObject> handleStateFragmentNavigation(StateFragment state) {
        ArrayList<EObject> navigations = new ArrayList<EObject>(1);
        if (state.getRelatedAbstractFunction() != null) {
            navigations.add((EObject)state.getRelatedAbstractFunction());
        }
        if (state.getRelatedAbstractState() != null) {
            navigations.add((EObject)state.getRelatedAbstractState());
        }
        return navigations;
    }

    List<EObject> handleInteractionUseNavigation(InteractionUse use) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        if (use.getReferencedScenario() != null) {
            nagivations.add((EObject)use.getReferencedScenario());
        }
        return nagivations;
    }

    List<EObject> handleInterfaceImplementationNavigation(InterfaceImplementation interfacep) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        Interface implementedInterface = interfacep.getImplementedInterface();
        if (implementedInterface != null) {
            nagivations.add((EObject)implementedInterface);
        }
        return nagivations;
    }

    List<EObject> handleInterfaceUseNavigation(InterfaceUse interfacep) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        Interface usedInterface = interfacep.getUsedInterface();
        if (usedInterface != null) {
            nagivations.add((EObject)usedInterface);
        }
        return nagivations;
    }

    List<EObject> handleMissionNavigation(Mission mission) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        nagivations.addAll((Collection<EObject>)mission.getParticipatingActors());
        nagivations.addAll((Collection<EObject>)mission.getExploitedCapabilities());
        return nagivations;
    }

    List<EObject> handleNumericReferenceNavigation(NumericReference reference) {
        Property referencedProperty;
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        NumericValue referencedValue = reference.getReferencedValue();
        if (referencedValue != null) {
            nagivations.add((EObject)referencedValue);
        }
        if ((referencedProperty = reference.getReferencedProperty()) != null) {
            nagivations.add((EObject)referencedProperty);
        }
        return nagivations;
    }

    List<EObject> handlePortNavigation(Port port) {
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        nagivations.addAll((Collection<EObject>)port.getProvidedInterfaces());
        nagivations.addAll((Collection<EObject>)port.getRequiredInterfaces());
        for (AbstractTrace trace : port.getOutgoingTraces()) {
            if (!(trace instanceof PortAllocation) && !(trace instanceof PortRealization) || trace.getTargetElement() == null) continue;
            nagivations.add((EObject)trace.getTargetElement());
        }
        return nagivations;
    }

    List<EObject> handlePropertyNavigation(Property property) {
        ArrayList<EObject> navigateTowardsElement = new ArrayList<EObject>(0);
        if (property.eContainer() instanceof Association) {
            navigateTowardsElement.add(property.eContainer());
        } else if (property.getAssociation() != null) {
            navigateTowardsElement.add((EObject)property.getAssociation());
        }
        navigateTowardsElement.addAll(this.handleAbstractTypedElementNavigation((AbstractTypedElement)property));
        return navigateTowardsElement;
    }

    List<EObject> handleScenarioNavigation(Scenario scenario) {
        ArrayList<EObject> navigations = new ArrayList<EObject>(1);
        for (AbstractTrace trace : scenario.getOutgoingTraces()) {
            if (!(trace instanceof ScenarioRealization) || trace.getTargetElement() == null) continue;
            navigations.add((EObject)trace.getTargetElement());
        }
        return navigations;
    }

    List<EObject> handleSequenceMessageNavigation(SequenceMessage sequenceMessage) {
        Event event;
        ArrayList<EObject> navigateTowardsElement = new ArrayList<EObject>(0);
        MessageEnd messageEnd = sequenceMessage.getReceivingEnd();
        if (messageEnd != null && (event = messageEnd.getEvent()) != null && event instanceof EventReceiptOperation) {
            AbstractEventOperation navigationElement = null;
            navigationElement = ((EventReceiptOperation)event).getOperation();
            if (navigationElement != null) {
                navigateTowardsElement.add((EObject)navigationElement);
            }
        }
        if (sequenceMessage.getExchangeContext() != null) {
            navigateTowardsElement.add((EObject)sequenceMessage.getExchangeContext());
        }
        return navigateTowardsElement;
    }

    List<EObject> handleStringReferenceNavigation(StringReference reference) {
        Property referencedProperty;
        ArrayList<EObject> nagivations = new ArrayList<EObject>(1);
        AbstractStringValue referencedValue = reference.getReferencedValue();
        if (referencedValue != null) {
            nagivations.add((EObject)referencedValue);
        }
        if ((referencedProperty = reference.getReferencedProperty()) != null) {
            nagivations.add((EObject)referencedProperty);
        }
        return nagivations;
    }

    List<EObject> handleAssociationNavigation(Association association) {
        ArrayList<EObject> navigations = new ArrayList<EObject>(2);
        navigations.addAll((Collection<EObject>)association.getNavigableMembers());
        navigations.addAll((Collection<EObject>)association.getOwnedMembers());
        return navigations;
    }

    List<EObject> handleFunctionalChainInvolvementNavigation(FunctionalChainInvolvement involvement) {
        ArrayList<EObject> navigations = new ArrayList<EObject>(1);
        InvolvedElement involved = involvement.getInvolved();
        if (involved != null) {
            navigations.add((EObject)involved);
        }
        return navigations;
    }

    List<EObject> handlePhysicalPathInvolvementNavigation(PhysicalPathInvolvement involvement) {
        ArrayList<EObject> navigations = new ArrayList<EObject>(1);
        AbstractPathInvolvedElement involved = involvement.getInvolvedElement();
        if (involved != null) {
            navigations.add((EObject)involved);
        }
        return navigations;
    }

    List<EObject> handleStateTransitionNavigation(StateTransition transition) {
        if (transition.getGuard() != null) {
            return Collections.singletonList(transition.getGuard());
        }
        return Collections.emptyList();
    }

    private void initializeNavigations() {
        if (__handledNavigations == null) {
            __handledNavigations = new HashMap();
            __handledNavigations.put(CommunicationLink.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleCommunicationLinkNavigation((CommunicationLink)this.getElement()));
                }
            });
            __handledNavigations.put(ExchangeItemAllocation.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleExchangeItemAllocationNavigation((ExchangeItemAllocation)this.getElement()));
                }
            });
            __handledNavigations.put(ExchangeItemElement.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleExchangeItemElementNavigation((ExchangeItemElement)this.getElement()));
                }
            });
            __handledNavigations.put(SequenceMessage.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleSequenceMessageNavigation((SequenceMessage)this.getElement()));
                }
            });
            __handledNavigations.put(InstanceRole.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleInstanceRoleNavigation((InstanceRole)this.getElement()));
                }
            });
            __handledNavigations.put(Property.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handlePropertyNavigation((Property)this.getElement()));
                }
            });
            __handledNavigations.put(Parameter.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleAbstractTypedElementNavigation((AbstractTypedElement)this.getElement()));
                }
            });
            __handledNavigations.put(DataValue.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleAbstractTypedElementNavigation((AbstractTypedElement)this.getElement()));
                }
            });
            __handledNavigations.put(org.polarsys.capella.core.data.information.Collection.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleCollectionNavigation((org.polarsys.capella.core.data.information.Collection)this.getElement()));
                }
            });
            __handledNavigations.put(AbstractFunction.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleAbstractFunctionNavigation((AbstractFunction)this.getElement()));
                }
            });
            __handledNavigations.put(AbstractFunctionalBlock.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleAbstractFunctionalBlockNavigation((AbstractFunctionalBlock)this.getElement()));
                }
            });
            __handledNavigations.put(InterfaceImplementation.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleInterfaceImplementationNavigation((InterfaceImplementation)this.getElement()));
                }
            });
            __handledNavigations.put(InterfaceUse.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleInterfaceUseNavigation((InterfaceUse)this.getElement()));
                }
            });
            __handledNavigations.put(GeneralizableElement.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleGeneralizableElementNavigation((GeneralizableElement)this.getElement()));
                }
            });
            __handledNavigations.put(Component.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleComponentNavigation((Component)this.getElement()));
                }
            });
            __handledNavigations.put(Port.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handlePortNavigation((Port)this.getElement()));
                }
            });
            __handledNavigations.put(Capability.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleCapabilityNavigation((Capability)this.getElement()));
                }
            });
            __handledNavigations.put(Actor.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleActorNavigation((Actor)this.getElement()));
                }
            });
            __handledNavigations.put(Mission.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleMissionNavigation((Mission)this.getElement()));
                }
            });
            __handledNavigations.put(StringReference.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleStringReferenceNavigation((StringReference)this.getElement()));
                }
            });
            __handledNavigations.put(BooleanReference.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleBooleanReferenceNavigation((BooleanReference)this.getElement()));
                }
            });
            __handledNavigations.put(NumericReference.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleNumericReferenceNavigation((NumericReference)this.getElement()));
                }
            });
            __handledNavigations.put(EnumerationReference.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleEnumerationReferenceNavigation((EnumerationReference)this.getElement()));
                }
            });
            __handledNavigations.put(FunctionalExchange.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleFunctionalExchangeNavigation((FunctionalExchange)this.getElement()));
                }
            });
            __handledNavigations.put(StateFragment.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleStateFragmentNavigation((StateFragment)this.getElement()));
                }
            });
            __handledNavigations.put(InteractionUse.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleInteractionUseNavigation((InteractionUse)this.getElement()));
                }
            });
            __handledNavigations.put(Scenario.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleScenarioNavigation((Scenario)this.getElement()));
                }
            });
            __handledNavigations.put(AbstractTrace.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleAbstractTraceNavigation((AbstractTrace)this.getElement()));
                }
            });
            __handledNavigations.put(Association.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleAssociationNavigation((Association)this.getElement()));
                }
            });
            __handledNavigations.put(FunctionalChainInvolvement.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleFunctionalChainInvolvementNavigation((FunctionalChainInvolvement)this.getElement()));
                }
            });
            __handledNavigations.put(PhysicalPathInvolvement.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handlePhysicalPathInvolvementNavigation((PhysicalPathInvolvement)this.getElement()));
                }
            });
            __handledNavigations.put(StateTransition.class, new AbstractModelElementRunnable(){

                public void run() {
                    this.setResult(NavigationAdvisor.this.handleStateTransitionNavigation((StateTransition)this.getElement()));
                }
            });
        }
    }

    public static NavigationAdvisor getInstance() {
        if (__singleton == null) {
            __singleton = new NavigationAdvisor();
        }
        return __singleton;
    }
}

