/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.ui.statushandlers.StatusManager;

public class StatusManagerExceptionHandler
implements ExceptionHandler {
    private final int style;

    public StatusManagerExceptionHandler() {
        this(2);
    }

    public StatusManagerExceptionHandler(int style) {
        this.style = style;
    }

    public void handleException(Exception e) {
        IStatus status = this.extractStatus(e);
        if (status == null) {
            status = this.createStatus(e);
        }
        StatusManager.getManager().handle(status, this.style);
    }

    protected IStatus createStatus(Exception e) {
        return new Status(4, "org.polarsys.capella.common.ui", e.getLocalizedMessage(), (Throwable)e);
    }

    protected IStatus extractStatus(Exception e) {
        if (e instanceof RollbackException) {
            IStatus status = ((RollbackException)e).getStatus();
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    if (!child.isOK()) {
                        return child;
                    }
                    ++n2;
                }
            }
        } else if (e instanceof CoreException) {
            CoreException ce = (CoreException)e;
            IStatus exceptionStatus = ce.getStatus();
            return new Status(exceptionStatus.getSeverity(), "org.polarsys.capella.common.ui", ce.getLocalizedMessage(), (Throwable)ce);
        }
        return null;
    }

    public void installAndExecute(TransactionalCommandStack stack, Command c) {
        ExceptionHandler oldHandler = null;
        try {
            oldHandler = stack.getExceptionHandler();
            stack.setExceptionHandler((ExceptionHandler)this);
            stack.execute(c);
        }
        finally {
            stack.setExceptionHandler(oldHandler);
        }
    }
}

