/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.widgets.filter;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.StringMatcherFactory;

public class PatternFilter
extends ViewerFilter {
    private StringMatcherFactory stringMatcherFactory = new StringMatcherFactory();
    private Map _cache = new HashMap();
    private Map _foundAnyCache = new HashMap();
    private boolean _useCache = false;
    private boolean _includeLeadingWildcard = false;
    private StringMatcher _matcher;
    private boolean _useEarlyReturnIfMatcherIsNull = true;
    private static Object[] EMPTY = new Object[0];

    public final Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this._matcher == null && this._useEarlyReturnIfMatcherIsNull) {
            return elements;
        }
        if (!this._useCache) {
            return super.filter(viewer, parent, elements);
        }
        Object[] filtered = (Object[])this._cache.get(parent);
        if (filtered == null) {
            Boolean foundAny = (Boolean)this._foundAnyCache.get(parent);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
            this._cache.put(parent, filtered);
        }
        return filtered;
    }

    protected boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        if (this._matcher == null) {
            return true;
        }
        if (!this._useCache) {
            return this.computeAnyVisible(viewer, parent, elements);
        }
        Object[] filtered = (Object[])this._cache.get(parent);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = (Boolean)this._foundAnyCache.get(parent);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer, parent, elements) ? Boolean.TRUE : Boolean.FALSE;
            this._foundAnyCache.put(parent, foundAny);
        }
        return foundAny;
    }

    private boolean computeAnyVisible(Viewer viewer, Object parentElement, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, parentElement, element);
            ++i;
        }
        return elementFound;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, parentElement, element);
    }

    public final void setIncludeLeadingWildcard(boolean includeLeadingWildcard) {
        this._includeLeadingWildcard = includeLeadingWildcard;
    }

    public void setPattern(String patternString) {
        if ("org.eclipse.ui.keys.optimization.true".equals(patternString)) {
            this._useEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(patternString)) {
            this._useEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (patternString == null || patternString.equals("")) {
            this._matcher = null;
        } else {
            String pattern = String.valueOf(patternString) + "*";
            if (this._includeLeadingWildcard) {
                pattern = "*" + pattern;
            }
            this._matcher = this.stringMatcherFactory.createStringMatcher(pattern);
        }
    }

    public void clearCaches() {
        this._cache.clear();
        this._foundAnyCache.clear();
    }

    private boolean match(String string) {
        if (this._matcher == null) {
            return true;
        }
        return this._matcher.match(string);
    }

    public boolean isElementSelectable(Object element) {
        return element != null;
    }

    public boolean isElementVisible(Viewer viewer, Object parentElement, Object element) {
        return this.isParentMatch(viewer, parentElement, element) || this.isLeafMatch(viewer, parentElement, element);
    }

    protected boolean isParentMatch(Viewer viewer, Object parentElement, Object element) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object parentElement, Object element) {
        String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    protected boolean isLeafAlreadyFilteredOutByOtherFilters(StructuredViewer viewer, Object parent, Object element) {
        ViewerFilter[] filters;
        ViewerFilter[] viewerFilterArray = filters = viewer.getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter != this && !filter.select((Viewer)viewer, parent, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] getWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text);
        int i = iter.first();
        while (i != -1 && i < text.length()) {
            int j = iter.following(i);
            if (j == -1) {
                j = text.length();
            }
            if (Character.isLetterOrDigit(text.charAt(i))) {
                String word = text.substring(i, j);
                words.add(word);
            }
            i = j;
        }
        return words.toArray(new String[words.size()]);
    }

    protected boolean wordMatches(String text) {
        if (text == null) {
            return false;
        }
        if (this.match(text)) {
            return true;
        }
        String[] words = this.getWords(text);
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (this.match(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setUseCache(boolean useCache) {
        this._useCache = useCache;
    }

    public void setStringMatcherFactory(StringMatcherFactory factory) {
        this.stringMatcherFactory = factory;
    }
}

