/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.internal.session;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.SavingPolicyImpl;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.model.handler.internal.session.Messages;

public class CapellaSavingPolicy
extends SavingPolicyImpl {
    CapellaSavingPolicy(TransactionalEditingDomain domain_p) {
        super(domain_p);
    }

    public Collection<Resource> save(Iterable<Resource> allResources, Map<?, ?> options, IProgressMonitor monitor) {
        Collection<IFile> files = this.retrieveUnsaveableFiles(allResources);
        if (!files.isEmpty()) {
            String msg = Messages.CapellaSavingPolicy_unwriteableFiles;
            for (IFile file : files) {
                msg = String.valueOf(msg) + file.toString() + '\n';
            }
            throw new RuntimeException(msg);
        }
        return super.save(allResources, options, monitor);
    }

    public Collection<IFile> retrieveUnsaveableFiles(Iterable<Resource> allResources) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (Resource resource : allResources) {
            IPath path;
            IPath parentFolderPath;
            File dir;
            IFile file;
            if (resource == null || (file = EcoreUtil2.getFile((Resource)resource)) == null || !(dir = (parentFolderPath = (path = file.getLocation()).removeLastSegments(1)).toFile()).exists() || dir.canWrite()) continue;
            files.add(file);
        }
        return files;
    }

    protected boolean hasChangesToSave(Resource resource_p) {
        ResourceSetSync.ResourceStatus resourceStatus;
        boolean result = false;
        if (!ResourceSetSync.isReadOnly((Resource)resource_p) && ResourceSetSync.ResourceStatus.SYNC != (resourceStatus = ResourceSetSync.getStatus((Resource)resource_p))) {
            result = true;
        }
        return result;
    }
}

