/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.diagram.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class ContextualDiagramHelper {
    public static ContextualDiagramHelper instance;

    protected ContextualDiagramHelper() {
    }

    public static ContextualDiagramHelper getService() {
        if (instance == null) {
            instance = new ContextualDiagramHelper();
        }
        return instance;
    }

    public boolean isContextualRepresentation(DRepresentationDescriptor representation) {
        RepresentationDescription description;
        if (representation instanceof DRepresentationDescriptor && (description = representation.getDescription()) != null && description.getName() != null) {
            return description.getName().endsWith("Interaction Blank") || description.getName().endsWith("Architecture Blank") || description.getName().endsWith("Entity Blank") || description.getName().endsWith("Data Flow Blank") || description.getName().endsWith("Class Diagram Blank");
        }
        return false;
    }

    public boolean hasContextualElements(DRepresentationDescriptor representation) {
        DAnnotation annotation = DAnnotationHelper.getAnnotation("http://www.polarsys.org/capella/dannotation/ContextualElements", (DModelElement)representation, false);
        if (annotation != null) {
            return annotation.getReferences() != null && !annotation.getReferences().isEmpty();
        }
        return false;
    }

    public List<EObject> getContextualElements(DRepresentationDescriptor representation) {
        DAnnotation annotation;
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (representation != null && (annotation = DAnnotationHelper.getAnnotation("http://www.polarsys.org/capella/dannotation/ContextualElements", (DModelElement)representation, false)) != null) {
            return new ArrayList<EObject>((Collection<EObject>)annotation.getReferences());
        }
        return result;
    }

    public void setContextualElements(DRepresentationDescriptor representation, Collection<EObject> elements) {
        if (representation != null) {
            if (elements == null || elements.size() == 0) {
                DAnnotationHelper.deleteAnnotation("http://www.polarsys.org/capella/dannotation/ContextualElements", (DModelElement)representation);
            } else {
                DAnnotation annotation = DAnnotationHelper.getAnnotation("http://www.polarsys.org/capella/dannotation/ContextualElements", (DModelElement)representation, true);
                annotation.getReferences().clear();
                annotation.getReferences().addAll(elements);
            }
        }
    }

    public Collection<EObject> getAvailableContextualElements(DRepresentationDescriptor representation) {
        if (representation != null) {
            EObject target = representation.getTarget();
            if (target == null || representation.getDescription() == null) {
                return Collections.emptyList();
            }
            String name = representation.getDescription().getName();
            if (name.endsWith("Architecture Blank") || name.endsWith("Entity Blank")) {
                return this.getABAvailableContextualElements(representation);
            }
            if (name.endsWith("Data Flow Blank") || name.endsWith("Interaction Blank")) {
                return this.getDFAvailableContextualElements(representation);
            }
            if (name.endsWith("Class Diagram Blank")) {
                return this.getCDBAvailableContextualElements(representation);
            }
        }
        return Collections.emptyList();
    }

    protected Collection<EObject> getABAvailableContextualElements(DRepresentationDescriptor diagram) {
        HashSet<EObject> result = new HashSet<EObject>();
        EObject target = diagram.getTarget();
        BlockArchitecture architecture = (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)target, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
        if (architecture != null) {
            AbstractCapabilityPkg cpkg;
            FunctionPkg fpkg = BlockArchitectureExt.getFunctionPkg((BlockArchitecture)architecture, (boolean)false);
            if (fpkg != null) {
                for (AbstractFunction function : FunctionPkgExt.getAllAbstractFunctions((FunctionPkg)fpkg)) {
                    result.addAll((Collection<EObject>)function.getOwnedFunctionalChains());
                    result.addAll((Collection<EObject>)function.getAvailableInStates());
                }
            }
            if ((cpkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)architecture)) != null) {
                for (AbstractCapability capability : AbstractCapabilityPkgExt.getAllAbstractCapabilities((AbstractCapabilityPkg)cpkg)) {
                    result.addAll((Collection<EObject>)capability.getOwnedFunctionalChains());
                }
                for (Scenario scenario : AbstractCapabilityPkgExt.getAllScenarios((AbstractCapabilityPkg)cpkg)) {
                    if (!this.isABContextualScenario(scenario, architecture)) continue;
                    result.add((EObject)scenario);
                }
                boolean multiPart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)architecture));
                boolean isOA = CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)architecture);
                for (Component component : BlockArchitectureExt.getAllComponents((BlockArchitecture)architecture)) {
                    boolean valid;
                    boolean bl = valid = !(component instanceof ComponentContext);
                    if (!valid) continue;
                    if (multiPart && !isOA) {
                        result.addAll(ComponentExt.getRepresentingParts((Component)component));
                        continue;
                    }
                    result.add((EObject)component);
                }
            }
        }
        return result;
    }

    public boolean isABContextualScenario(Scenario scenario, BlockArchitecture architecture) {
        boolean addElement = false;
        for (EObject eObject : this.getInsertScenariosRelatedElements(scenario, architecture)) {
            if (eObject instanceof AbstractFunction) {
                addElement = true;
            } else if (eObject instanceof FunctionalExchange) {
                addElement = true;
            } else if (eObject instanceof Part) {
                addElement = true;
            } else if (eObject instanceof Role) {
                addElement = true;
            } else if (eObject instanceof Entity) {
                addElement = true;
            } else if (eObject instanceof ComponentExchange) {
                addElement = true;
            }
            if (addElement) break;
        }
        if (addElement) {
            if (ScenarioExt.isFunctionalScenario((Scenario)scenario)) {
                return true;
            }
            if (ScenarioExt.isDataFlowFunctionalScenario((Scenario)scenario)) {
                return true;
            }
            if (ScenarioExt.isDataFlowBehaviouralScenario((Scenario)scenario)) {
                return true;
            }
            if (ScenarioExt.isInterfaceScenario((Scenario)scenario)) {
                return true;
            }
        }
        return false;
    }

    protected Collection<EObject> getDFAvailableContextualElements(DRepresentationDescriptor diagram) {
        HashSet<EObject> result = new HashSet<EObject>();
        EObject target = diagram.getTarget();
        BlockArchitecture architecture = (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)target, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
        if (architecture != null) {
            AbstractCapabilityPkg cpkg;
            FunctionPkg fpkg = BlockArchitectureExt.getFunctionPkg((BlockArchitecture)architecture, (boolean)false);
            if (fpkg != null) {
                for (AbstractFunction function : FunctionPkgExt.getAllAbstractFunctions((FunctionPkg)fpkg)) {
                    result.add((EObject)function);
                    result.addAll((Collection<EObject>)function.getOwnedFunctionalChains());
                    result.addAll((Collection<EObject>)function.getAvailableInStates());
                }
            }
            if ((cpkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)architecture)) != null) {
                for (AbstractCapability capability : AbstractCapabilityPkgExt.getAllAbstractCapabilities((AbstractCapabilityPkg)cpkg)) {
                    result.addAll((Collection<EObject>)capability.getOwnedFunctionalChains());
                }
                for (Scenario scenario : AbstractCapabilityPkgExt.getAllScenarios((AbstractCapabilityPkg)cpkg)) {
                    if (!this.isDFContextualScenario(scenario, architecture)) continue;
                    result.add((EObject)scenario);
                }
            }
        }
        return result;
    }

    public boolean isDFContextualScenario(Scenario scenario, BlockArchitecture architecture) {
        boolean addElement = false;
        for (EObject eObject : this.getInsertScenariosRelatedElements(scenario, architecture)) {
            if (eObject instanceof AbstractFunction) {
                addElement = true;
            } else if (eObject instanceof FunctionalExchange) {
                addElement = true;
            }
            if (addElement) break;
        }
        if (addElement) {
            if (ScenarioExt.isFunctionalScenario((Scenario)scenario)) {
                return true;
            }
            if (ScenarioExt.isDataFlowFunctionalScenario((Scenario)scenario)) {
                return true;
            }
        }
        return false;
    }

    public Collection<? extends EObject> getInsertScenariosRelatedElements(Scenario scenario, BlockArchitecture sourceArchitecture) {
        BlockArchitecture targetArchitecture;
        HashSet<Object> result = new HashSet<Object>();
        for (InstanceRole role : scenario.getOwnedInstanceRoles()) {
            AbstractInstance instance = role.getRepresentedInstance();
            if (instance == null || !sourceArchitecture.equals(targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)instance))) continue;
            if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)sourceArchitecture) && instance instanceof Part) {
                result.add(instance.getAbstractType());
                continue;
            }
            result.add(instance);
        }
        for (SequenceMessage message : scenario.getOwnedMessages()) {
            AbstractEventOperation operation = message.getInvokedOperation();
            if (operation == null || !sourceArchitecture.equals(targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)operation))) continue;
            result.add(operation);
        }
        for (TimeLapse timeLapse : scenario.getOwnedTimeLapses()) {
            StateFragment fragment;
            if (!(timeLapse instanceof StateFragment) || (fragment = (StateFragment)timeLapse).getRelatedAbstractFunction() == null || !sourceArchitecture.equals(targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)fragment.getRelatedAbstractFunction()))) continue;
            result.add(fragment.getRelatedAbstractFunction());
        }
        return result;
    }

    protected Collection<EObject> getCDBAvailableContextualElements(DRepresentationDescriptor diagram) {
        HashSet<EObject> result = new HashSet<EObject>();
        EObject target = diagram.getTarget();
        BlockArchitecture architecture = (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)target, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
        if (architecture != null) {
            TreeIterator objects = architecture.eAllContents();
            while (objects.hasNext()) {
                boolean valid = false;
                EObject object = (EObject)objects.next();
                if (object instanceof ExchangeItem) {
                    valid = true;
                } else if (object instanceof org.polarsys.capella.core.data.information.Collection) {
                    valid = true;
                } else if (object instanceof DataType) {
                    valid = true;
                } else if (object instanceof Class) {
                    valid = true;
                } else if (object instanceof Interface) {
                    valid = true;
                } else if (object instanceof FunctionPkg) {
                    objects.prune();
                }
                if (!valid) continue;
                result.add(object);
            }
        }
        return result;
    }
}

