/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.semantic.browser.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryImpl;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.model.ISemanticBrowserModel;

public class SemanticBrowserModel
implements ISemanticBrowserModel {
    private static final String PATTERN_CATEGORY_NAME = "All Related Pattern Instances";
    private static final String DIAGRAM_CATEGORY_NAME = "All Related Diagrams";
    protected boolean showPatterns = false;
    protected boolean showDiagrams = true;
    protected boolean limitateTreeExpansion = false;
    protected Hashtable<String, List<String>> browserID2ExpandedObjectHashcodes = new Hashtable();

    public boolean doesShowPatterns() {
        return this.showPatterns;
    }

    public void setShowPatterns(boolean showPatterns_p) {
        this.showPatterns = showPatterns_p;
    }

    public boolean doesShowDiagrams() {
        return this.showDiagrams;
    }

    public void setShowDiagrams(boolean showDiagrams_p) {
        this.showDiagrams = showDiagrams_p;
    }

    public boolean doesLimitateTreeExpansion() {
        return this.limitateTreeExpansion;
    }

    public void setLimitateTreeExpansion(boolean limitateTreeExpansion_p) {
        this.limitateTreeExpansion = limitateTreeExpansion_p;
    }

    public boolean doesShowCategory(ICategory category) {
        if (!this.showDiagrams && category.getName().equals(DIAGRAM_CATEGORY_NAME)) {
            return false;
        }
        return this.showPatterns || !category.getName().equals(PATTERN_CATEGORY_NAME);
    }

    public void saveExpandedState(CategoryImpl category, String browserID, boolean expanded) {
        String hashcode;
        List<String> expandedObjects = this.getOrCreateHistory(browserID);
        if (expandedObjects.contains(hashcode = this.getHashcode((ICategory)category)) && !expanded) {
            expandedObjects.remove(hashcode);
        } else if (!expandedObjects.contains(hashcode) && expanded) {
            expandedObjects.add(hashcode);
        }
    }

    public boolean getExpandedState(ICategory category, String browserID) {
        List<String> expandedObjects;
        return !this.doesLimitateTreeExpansion() || (expandedObjects = this.browserID2ExpandedObjectHashcodes.get(browserID)) == null || expandedObjects.contains(this.getHashcode(category));
    }

    public boolean containsExpandedHistory(String browserID) {
        return this.browserID2ExpandedObjectHashcodes.containsKey(browserID);
    }

    public List<String> getOrCreateHistory(String browserID) {
        List<String> nonExpandedObjects = this.browserID2ExpandedObjectHashcodes.get(browserID);
        if (nonExpandedObjects == null) {
            nonExpandedObjects = new ArrayList<String>();
            this.browserID2ExpandedObjectHashcodes.put(browserID, nonExpandedObjects);
        }
        return nonExpandedObjects;
    }

    private String getHashcode(ICategory category) {
        return category.getName();
    }
}

