/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.rules.cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.preferences.IProjectionPreferences;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.projection.common.rules.core.Rule_CapellaElement;
import org.polarsys.capella.core.projection.preferences.ProjectionPreferencesPlugin;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;

public class Rule_Component
extends Rule_CapellaElement {
    protected boolean _isItfProjectionHandle = IProjectionPreferences.DEFAULT_INTERFACE_PROJECTION;
    protected boolean _isStateMachineProjectionHandle = IProjectionPreferences.DEFAULT_STATE_MACHINE_PROJECTION;
    protected List<Interface> alreadyTransitioned;
    protected EReference attachmentSource;
    protected EReference attachmentTarget;

    public Rule_Component() {
        this(CsPackage.Literals.COMPONENT, CsPackage.Literals.COMPONENT, CsPackage.Literals.COMPONENT_ALLOCATION);
    }

    public Rule_Component(EClass source, EClass target, EClass realization) {
        super(source, target, realization);
        this.setNeedsContext(true);
        this.alreadyTransitioned = new ArrayList<Interface>();
        this._updatedAttributes.add(CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__ABSTRACT.getName());
    }

    public Rule_Component(EClass source, EClass target) {
        super(source, target);
        this.setNeedsContext(true);
        this.alreadyTransitioned = new ArrayList<Interface>();
        this._updatedAttributes.add(CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__ABSTRACT.getName());
    }

    public Rule_Component(EClass source, EClass target, EClass realization, EReference attachmentSource_p, EReference attachmentTarget_p) {
        this(source, target, realization);
        this.attachmentSource = attachmentSource_p;
        this.attachmentTarget = attachmentTarget_p;
    }

    @Override
    public IStatus transformRequired(EObject element_p, IContext context_p) {
        EObject transfoSource = (EObject)context_p.get("transfoSource");
        if (transfoSource instanceof Component && transfoSource != element_p && !ComponentExt.isComponentAncestor((Component)((Component)transfoSource), (Component)((Component)element_p))) {
            return new Status(2, ProjectionMessages.Activity_Transformation, NLS.bind((String)ProjectionMessages.OutOfScope, (Object)EObjectLabelProviderHelper.getText((EObject)element_p)));
        }
        if (transfoSource instanceof LogicalActorPkg) {
            return new Status(2, ProjectionMessages.Activity_Transformation, NLS.bind((String)ProjectionMessages.OutOfScope, (Object)EObjectLabelProviderHelper.getText((EObject)element_p)));
        }
        return Status.OK_STATUS;
    }

    private void interfacesProjectionProcessing(Component currentLC_p, ITransfo transfo_p) {
        Collection itfManipulated = ComponentExt.getRelatedInterfaces((Component)currentLC_p);
        if (currentLC_p.getOwnedInterfacePkg() != null) {
            this.runSubTransition((EObject)currentLC_p.getOwnedInterfacePkg(), transfo_p);
        }
        for (Interface itf : itfManipulated) {
            if (this.alreadyTransitioned.contains(itf)) continue;
            this.runSubTransition((EObject)itf, transfo_p);
        }
    }

    @Override
    protected EObject transformDirectElement(EObject element_p, IContext context_p) {
        EObject result = super.transformDirectElement(element_p, context_p);
        if (result instanceof PhysicalComponent) {
            ((PhysicalComponent)result).setNature(PhysicalComponentNature.BEHAVIOR);
        }
        return result;
    }

    @Override
    protected EStructuralFeature getTargetContainementFeature(EObject element_p, EObject result_p, EObject container_p, IContext context_p) {
        if (container_p instanceof PhysicalComponentPkg) {
            if (result_p instanceof PhysicalComponentPkg) {
                return PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENT_PKGS;
            }
            if (result_p instanceof PhysicalComponent) {
                return PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_COMPONENTS;
            }
        } else if (container_p instanceof PhysicalComponent) {
            if (result_p instanceof PhysicalComponentPkg) {
                return PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENT_PKGS;
            }
            if (result_p instanceof PhysicalComponent) {
                return PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENTS;
            }
        }
        return super.getTargetContainementFeature(element_p, result_p, container_p, context_p);
    }

    @Override
    protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject container = element_p.eContainer();
        if (container != null && container instanceof Component) {
            EObject parent = container;
            while (parent != null) {
                if (Query.isElementTransformed((EObject)parent, (ITransfo)context_p.getTransfo())) {
                    EObject targetContainer = Query.retrieveFirstTransformedElement((EObject)parent, (ITransfo)context_p.getTransfo(), (EClass)CsPackage.Literals.COMPONENT);
                    if (targetContainer == null) {
                        targetContainer = Query.retrieveFirstTransformedElement((EObject)parent, (ITransfo)context_p.getTransfo());
                    }
                    return targetContainer;
                }
                parent = parent.eContainer();
            }
        }
        return super.getBestContainer(element_p, result_p, context_p);
    }

    @Override
    protected EObject getDefaultContainer(EObject element_p, EObject result_p, IContext context_p) {
        BlockArchitecture architecture;
        EObject sourceContainer = element_p.eContainer();
        if (sourceContainer instanceof Component && (architecture = (BlockArchitecture)context_p.get("transfoTargetContainer")) != null) {
            Component rootComponent = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)architecture);
            return rootComponent;
        }
        return super.getDefaultContainer(element_p, result_p, context_p);
    }

    @Override
    protected void attachRelated(EObject element_p, EObject result_p, IContext context_p) {
        Object test;
        super.attachRelated(element_p, result_p, context_p);
        Component sourceElement = (Component)element_p;
        Object targetIp2 = Query.retrieveTransformedElement((EObject)sourceElement, (ITransfo)context_p.getTransfo(), (EClass)CsPackage.Literals.COMPONENT);
        if (targetIp2 != null && (test = Query.retrieveTransformedElement((EObject)sourceElement, (ITransfo)context_p.getTransfo(), (EClass)PaPackage.Literals.PHYSICAL_COMPONENT_PKG)) != null) {
            this.notifyMessage(NLS.bind((String)ProjectionMessages.ComponentWasTransitionedToPackage, (Object)EObjectLabelProviderHelper.getText((EObject)sourceElement)), new Object[]{sourceElement, test, targetIp2}, "WARN", context_p.getTransfo());
        }
    }

    @Override
    public List<EObject> retrieveRelatedElements_(EObject element_p, ITransfo transfo_p) {
        this._isItfProjectionHandle = ProjectionPreferencesPlugin.getDefault().transitionInterfaceWhileComponentTransition();
        this._isStateMachineProjectionHandle = ProjectionPreferencesPlugin.getDefault().transitionStateMachineWhileComponentTransition();
        return super.retrieveRelatedElements_(element_p, transfo_p);
    }

    @Override
    protected void runSubTransition(EObject element_p, ITransfo transfo_p) {
        if (element_p instanceof Component) {
            Component sourceElement = (Component)element_p;
            if (this._isItfProjectionHandle) {
                this.interfacesProjectionProcessing(sourceElement, transfo_p);
            }
            if (this._isStateMachineProjectionHandle && sourceElement.getOwnedStateMachines().size() > 0) {
                for (StateMachine machine : sourceElement.getOwnedStateMachines()) {
                    this.runSubTransition((EObject)machine, transfo_p);
                }
            }
        }
    }

    @Override
    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        super.retrieveGoDeep(source_p, result_p, context_p);
        this.retrieveComponentGoDeep(source_p, result_p, context_p);
    }

    protected void retrieveComponentGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        Component sourceElement = (Component)source_p;
        EObject transfoSource = (EObject)this.getTransfo().get((Object)"transfoSource");
        for (Partition partition : sourceElement.getRepresentingPartitions()) {
            if (!CapellaProjectHelper.TriStateBoolean.False.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)partition)) && (!(partition instanceof Part) || partition.getType() == null || partition.eContainer() == null || !(partition.eContainer() instanceof ComponentContext))) continue;
            result_p.add((EObject)partition);
        }
        if (EcoreUtil2.isOrIsContainedBy((EObject)sourceElement, (EObject)transfoSource)) {
            for (Partition partition : sourceElement.getOwnedPartitions()) {
                if (partition instanceof Part && partition.getType() != null) {
                    result_p.add((EObject)partition);
                    continue;
                }
                if (!(partition instanceof ComponentPort)) continue;
                result_p.add((EObject)partition);
            }
            for (InterfaceUse use : sourceElement.getUsedInterfaceLinks()) {
                result_p.add((EObject)use);
            }
            for (InterfaceImplementation impl : sourceElement.getImplementedInterfaceLinks()) {
                result_p.add((EObject)impl);
            }
            if (!(sourceElement instanceof System)) {
                for (ComponentFunctionalAllocation compFuncAlloc : sourceElement.getFunctionalAllocations()) {
                    result_p.add((EObject)compFuncAlloc);
                }
            }
            if (sourceElement instanceof LogicalComponent) {
                for (LogicalComponentPkg pkg : ((LogicalComponent)sourceElement).getOwnedLogicalComponentPkgs()) {
                    result_p.add((EObject)pkg);
                }
                for (LogicalComponent subLc : ((LogicalComponent)sourceElement).getOwnedLogicalComponents()) {
                    result_p.add((EObject)subLc);
                }
            }
            for (CommunicationLink link : sourceElement.getOwnedCommunicationLinks()) {
                result_p.add((EObject)link);
            }
            for (Generalization generalization : sourceElement.getOwnedGeneralizations()) {
                result_p.add((EObject)generalization);
            }
            for (ComponentExchange connection : sourceElement.getOwnedComponentExchanges()) {
                result_p.add((EObject)connection);
            }
            for (Feature feature : sourceElement.getOwnedFeatures()) {
                if (!(feature instanceof ComponentPort)) continue;
                ComponentPort fp = (ComponentPort)feature;
                result_p.add((EObject)fp);
                for (ComponentExchange connection : fp.getComponentExchanges()) {
                    if (!TransformationHandlerHelper.getInstance(context_p).isOrWillBeTransformed((EObject)connection, context_p).isOK()) continue;
                    result_p.add((EObject)connection);
                }
            }
        }
    }
}

