/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.rules.information;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.log.LogHelper;
import org.polarsys.capella.core.projection.common.rules.core.Rule_CapellaElement;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;

public class Rule_DataPkg
extends Rule_CapellaElement {
    public Rule_DataPkg() {
        super(InformationPackage.Literals.DATA_PKG, InformationPackage.Literals.DATA_PKG);
    }

    @Override
    protected void retrieveContainer(EObject element_p, List<EObject> result_p, IContext context_p) {
        if (!(element_p.eContainer() instanceof Component) && !(element_p.eContainer() instanceof BlockArchitecture)) {
            super.retrieveContainer(element_p, result_p, context_p);
        }
    }

    @Override
    protected EObject transformDirectElement(EObject element_p, IContext context_p) {
        DataPkg result;
        BlockArchitecture architecture;
        if (element_p.eContainer() instanceof BlockArchitecture && (architecture = (BlockArchitecture)context_p.get("transfoTargetContainer")) != null && (result = BlockArchitectureExt.getDataPkg((BlockArchitecture)architecture)) != null) {
            LogHelper.getInstance().info(NLS.bind((String)ProjectionMessages.ElementTransitionedToExistingElement, (Object)EObjectLabelProviderHelper.getText((EObject)element_p), (Object)EObjectLabelProviderHelper.getText((EObject)result)), new Object[]{element_p, result}, ProjectionMessages.Activity_Transformation);
            return result;
        }
        return super.transformDirectElement(element_p, context_p);
    }

    @Override
    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        super.retrieveGoDeep(source_p, result_p, context_p);
        DataPkg sourceElement = (DataPkg)source_p;
        if (this.isRelatedToSource((EObject)sourceElement, context_p)) {
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedDataTypes());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedClasses());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedDataValues());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedMessageReferences());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedPropertyValues());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedPropertyValueGroups());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedDataPkgs());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedConstraints());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedExchangeItems());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedCollections());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedMessages());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedExceptions());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedSignals());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedAssociations());
        }
    }

    @Override
    protected EStructuralFeature getTargetContainementFeature(EObject element_p, EObject result_p, EObject container_p, IContext context_p) {
        if (container_p instanceof Block) {
            return CsPackage.Literals.BLOCK__OWNED_DATA_PKG;
        }
        if (container_p instanceof DataPkg) {
            return InformationPackage.Literals.DATA_PKG__OWNED_DATA_PKGS;
        }
        if (container_p instanceof BlockArchitecture) {
            return CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_DATA_PKG;
        }
        return super.getTargetContainementFeature(element_p, result_p, container_p, context_p);
    }

    @Override
    protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject sourceContainer;
        EObject bestContainer = super.getBestContainer(element_p, result_p, context_p);
        if (bestContainer != null && (sourceContainer = element_p.eContainer()) instanceof Component) {
            DataPkg dataPkg;
            EObject targetComponent = Query.retrieveFirstTransformedElement((EObject)sourceContainer, (ITransfo)context_p.getTransfo(), (EClass)CsPackage.Literals.COMPONENT);
            if (targetComponent == null) {
                targetComponent = Query.retrieveFirstTransformedElement((EObject)sourceContainer, (ITransfo)context_p.getTransfo());
                targetComponent = EcoreUtil2.getFirstContainer((EObject)targetComponent, (EClass)CsPackage.Literals.COMPONENT);
            }
            if (targetComponent != null && (dataPkg = ((Component)targetComponent).getOwnedDataPkg()) != null && dataPkg != result_p) {
                return dataPkg;
            }
            return targetComponent;
        }
        return bestContainer;
    }

    @Override
    protected EObject getDefaultContainer(EObject element_p, EObject result_p, IContext context_p) {
        BlockArchitecture architecture = (BlockArchitecture)context_p.get("transfoTargetContainer");
        if (architecture != null) {
            if (element_p.eContainer() instanceof BlockArchitecture) {
                return architecture;
            }
            return BlockArchitectureExt.getDataPkg((BlockArchitecture)architecture);
        }
        return super.getDefaultContainer(element_p, result_p, context_p);
    }
}

