/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.rules.oa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.projection.common.rules.cs.Rule_ComponentFunctionalAllocation;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public class Rule_ActivityAllocation
extends Rule_ComponentFunctionalAllocation {
    public Rule_ActivityAllocation() {
        super(OaPackage.Literals.ACTIVITY_ALLOCATION, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
    }

    public Rule_ActivityAllocation(EClass source, EClass target) {
        super(source, target);
    }

    @Override
    protected Collection<EObject> transformElement(EObject element, IContext context) {
        return this.createComponentFunctionalAllocations(element, context);
    }

    private Collection<EObject> createComponentFunctionalAllocations(EObject element, IContext context) {
        ActivityAllocation allocation = (ActivityAllocation)element;
        ArrayList<EObject> result = new ArrayList<EObject>();
        int nbAllocations = 0;
        for (EObject tAllocation : Query.retrieveTransformedElements((EObject)allocation, (ITransfo)context.getTransfo(), (EClass)this.getTargetType())) {
            if (tAllocation.eContainer() != null) continue;
            ++nbAllocations;
        }
        Set<AbstractFunctionalBlock> entities = this.retrieveComponentsToAllocate(allocation, context);
        int nbEntities = entities.size();
        if (nbEntities - nbAllocations > 0) {
            int i = 0;
            while (i < nbEntities - nbAllocations) {
                ComponentFunctionalAllocation allocationTransformated = (ComponentFunctionalAllocation)super.transformDirectElement((EObject)allocation, context);
                result.add((EObject)allocationTransformated);
                ++i;
            }
        }
        return result;
    }

    @Override
    protected boolean shouldUpdate() {
        return false;
    }

    @Override
    public void update_(EObject element_p, ITransfo transfo_p) {
        super.update_(element_p, transfo_p);
        IContext context_p = IContext.getContext(transfo_p);
        this.createLinks(element_p, this.createComponentFunctionalAllocations(element_p, context_p));
    }

    @Override
    protected void attachRelated(EObject element_p, EObject result_p, IContext context_p) {
        super.attachRelated(element_p, result_p, context_p);
        ActivityAllocation allocation = (ActivityAllocation)element_p;
        TraceableElement t = (TraceableElement)Query.retrieveTransformedElement((EObject)allocation.getTargetElement(), (ITransfo)context_p.getTransfo());
        List elements = Query.retrieveTransformedElements((EObject)element_p, (ITransfo)context_p.getTransfo(), (EClass)this.getTargetType());
        if (elements.size() > 0 && elements.get(0).equals(result_p)) {
            ComponentFunctionalAllocation a;
            LinkedList<ComponentFunctionalAllocation> allocs = new LinkedList<ComponentFunctionalAllocation>();
            for (Object element : elements) {
                if (!(element instanceof ComponentFunctionalAllocation) || (a = (ComponentFunctionalAllocation)element).eContainer() != null) continue;
                allocs.add(a);
            }
            for (AbstractFunctionalBlock block : this.retrieveComponentsToAllocate(allocation, context_p)) {
                if (allocs.size() <= 0) continue;
                a = (ComponentFunctionalAllocation)allocs.remove();
                block.getOwnedFunctionalAllocation().add((Object)a);
                a.setTargetElement(t);
                a.setSourceElement((TraceableElement)block);
            }
        }
    }

    private Set<AbstractFunctionalBlock> retrieveComponentsToAllocate(ActivityAllocation allocation, IContext context_p) {
        TraceableElement t = (TraceableElement)Query.retrieveFirstTransformedElement((EObject)allocation.getTargetElement(), (ITransfo)context_p.getTransfo());
        HashSet<AbstractFunctionalBlock> entities = new HashSet<AbstractFunctionalBlock>();
        Role role = (Role)allocation.eContainer();
        if (role != null) {
            for (RoleAllocation roleAllocation : role.getRoleAllocations()) {
                Entity source = roleAllocation.getEntity();
                List transitioneds = new ArrayList();
                if (TransformationHandlerHelper.getInstance(context_p).isOrWillBeTransformed((EObject)source, context_p).isOK()) {
                    transitioneds = Query.retrieveTransformedElements((EObject)source, (ITransfo)context_p.getTransfo(), (EClass)CsPackage.Literals.COMPONENT);
                    for (EObject transitioned : transitioneds) {
                        if (!(transitioned instanceof AbstractFunctionalBlock)) continue;
                        entities.add((AbstractFunctionalBlock)transitioned);
                    }
                }
                if (transitioneds.size() <= 0) continue;
                for (EObject transitionedElement : Query.retrieveTransformedElements((EObject)allocation, (ITransfo)context_p.getTransfo(), (EClass)this.getTargetType())) {
                    if (!(transitionedElement instanceof ComponentFunctionalAllocation)) continue;
                    ComponentFunctionalAllocation transitionedAllocation = (ComponentFunctionalAllocation)transitionedElement;
                    AbstractFunctionalBlock block = transitionedAllocation.getBlock();
                    TraceableElement target = transitionedAllocation.getTargetElement();
                    if (!transitioneds.contains(block) || !target.equals(t)) continue;
                    entities.remove(block);
                }
            }
        }
        return entities;
    }

    private void createLinks(EObject source, Collection<EObject> elements) {
        for (EObject target : elements) {
            List transformed = (List)this._transfo.get((Object)"transformedElements");
            if (!transformed.contains(target)) {
                transformed.add(target);
            }
            if (Query.retrieveSourceElements((EObject)target, (ITransfo)this._transfo, (EClass)this.getSourceType()).size() != 0) continue;
            try {
                AbstractTrace newLink = TigerRelationshipHelper.createTransfoLink((EObject)source, (EObject)target, (ITransfo)this._transfo);
                if (newLink == null) continue;
                List links = (List)this._transfo.get((Object)"newLinks");
                links.add(newLink);
            }
            catch (TransfoException transfoException) {
                // empty catch block
            }
        }
    }
}

