/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.platform.sirius.ted;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.polarsys.capella.common.ef.domain.IEditingDomainListener;
import org.polarsys.capella.common.ef.internal.command.WorkspaceCommandStackImpl;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.platform.sirius.ted.DataNotifier;
import org.polarsys.capella.common.platform.sirius.ted.PlatformSiriusTedActivator;
import org.polarsys.capella.common.platform.sirius.ted.SemanticCrossReferencer;

public class SemanticEditingDomainFactory
extends WorkspaceEditingDomainFactory {
    private ISemanticEditingDomainProviders semanticEditingDomainProviders;

    public synchronized TransactionalEditingDomain createEditingDomain() {
        this.loadSemanticEditingDomainProviders();
        SemanticCommandStack stack = this.doCreateCommandStack();
        TransactionalEditingDomain result = this.doCreateEditingDomain((TransactionalCommandStack)stack);
        this.mapResourceSet(result);
        return result;
    }

    protected SemanticCommandStack doCreateCommandStack() {
        return new SemanticCommandStack(OperationHistoryFactory.getOperationHistory());
    }

    protected TransactionalEditingDomain doCreateEditingDomain(TransactionalCommandStack stack) {
        AdapterFactory adapterFactory = this.getSemanticEditingDomainProviders().getAdapterFactoryProvider().getAdapterFactory();
        SemanticEditingDomain semanticEditingDomain = new SemanticEditingDomain(adapterFactory, stack);
        return semanticEditingDomain;
    }

    protected ISemanticEditingDomainProviders getSemanticEditingDomainProviders() {
        return this.semanticEditingDomainProviders;
    }

    private void loadSemanticEditingDomainProviders() {
        IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.common.platform.sirius.ted", (String)"semanticEditingDomainProviders");
        if (configurationElements.length > 0) {
            this.semanticEditingDomainProviders = (ISemanticEditingDomainProviders)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElements[0], (String)"class");
        }
    }

    public static interface IAdapterFactoryProvider {
        public AdapterFactory getAdapterFactory();
    }

    public static interface ICrossReferencerProvider {
        public SemanticCrossReferencer getCrossReferencer(EditingDomain var1);
    }

    public static interface IReadOnlyDelegationHandler {
        public boolean isReadOnly(Resource var1);
    }

    public static interface ISemanticEditingDomainProviders {
        public ICrossReferencerProvider getCrossReferencerProvider();

        public IAdapterFactoryProvider getAdapterFactoryProvider();

        public IReadOnlyDelegationHandler getReadOnlyDelegationHandler();

        public ITransactionChangeRecorderProvider getTransactionChangeRecorderProvider();

        public Resource.Factory.Registry getResourceFactoryRegistry(Resource.Factory.Registry var1);
    }

    public static interface ITransactionChangeRecorderProvider {
        public TransactionChangeRecorder getTransactionChangeRecorder(InternalTransactionalEditingDomain var1, ResourceSet var2);
    }

    protected class SemanticCommandStack
    extends WorkspaceCommandStackImpl {
        public SemanticCommandStack(IOperationHistory history) {
            super(history);
        }

        protected IUndoContext getUndoContext() {
            return new UndoContext();
        }

        public void dispose() {
            this.flush();
            super.dispose();
        }

        protected void executeNonDirtyingCommand(Command command, Map options) throws InterruptedException, RollbackException {
            EMFCommandTransaction tx = this.createTransaction(command, options);
            try {
                try {
                    this.basicExecute(command);
                    tx.commit();
                }
                catch (OperationCanceledException operationCanceledException) {
                    if (tx != null && tx.isActive()) {
                        this.rollback((Transaction)tx);
                        this.handleRollback(command, null);
                    }
                }
            }
            finally {
                if (tx != null && tx.isActive()) {
                    this.rollback((Transaction)tx);
                    this.handleRollback(command, null);
                }
            }
        }

        protected void basicExecute(Command command) {
            if (command != null) {
                if (command.canExecute()) {
                    try {
                        command.execute();
                    }
                    catch (RuntimeException exception) {
                        this.handleError(exception);
                        command.dispose();
                    }
                    if (!(command instanceof AbstractCommand.NonDirtying)) {
                        this.notifyListeners();
                    }
                } else {
                    command.dispose();
                }
            }
        }

        protected void doExecute(Command command, Map options) throws InterruptedException, RollbackException {
            try {
                if (command instanceof AbstractCommand.NonDirtying) {
                    this.executeNonDirtyingCommand(command, options);
                } else {
                    super.doExecute(command, options);
                }
            }
            catch (IllegalArgumentException exception) {
                String message = "Error while executing a command:";
                PlatformSiriusTedActivator.getDefault().getLog().log((IStatus)new Status(2, PlatformSiriusTedActivator.getDefault().getPluginId(), message, (Throwable)exception));
                throw new RollbackException((IStatus)new Status(8, PlatformSiriusTedActivator.getDefault().getPluginId(), message, (Throwable)exception));
            }
        }
    }

    public class SemanticEditingDomain
    extends TransactionalEditingDomainImpl {
        List<IEditingDomainListener> editingDomainListeners;

        public SemanticEditingDomain(AdapterFactory adapterFactory, TransactionalCommandStack stack) {
            this(adapterFactory, stack, (ResourceSet)semanticEditingDomainFactory.new SemanticResourceSet());
        }

        public SemanticEditingDomain(AdapterFactory adapterFactory, TransactionalCommandStack stack, ResourceSet resourceSet) {
            super(adapterFactory, stack, resourceSet);
            this.editingDomainListeners = null;
            SemanticResourceSet semanticResourceSet = this.getResourceSet();
            semanticResourceSet.setEditingDomain((EditingDomain)this);
            semanticResourceSet.registerAdapters();
            for (IEditingDomainListener listener : this.getEditingDomainListeners()) {
                listener.createdEditingDomain((EditingDomain)this);
            }
        }

        public void dispose() {
            SemanticCommandStack workspaceCommandStack = (SemanticCommandStack)this.getCommandStack();
            workspaceCommandStack.flush();
            for (Resource resource : this.resourceSet.getResources()) {
                workspaceCommandStack.getOperationHistory().dispose((IUndoContext)new ResourceUndoContext((TransactionalEditingDomain)this, resource), true, true, true);
            }
            ResourceSetListener[] resourceSetListenerArray = this.getPrecommitListeners();
            int n = resourceSetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceSetListener resourceSetListener = resourceSetListenerArray[n2];
                this.removeResourceSetListener(resourceSetListener);
                ++n2;
            }
            resourceSetListenerArray = this.getPostcommitListeners();
            n = resourceSetListenerArray.length;
            n2 = 0;
            while (n2 < n) {
                ResourceSetListener resourceSetListener = resourceSetListenerArray[n2];
                this.removeResourceSetListener(resourceSetListener);
                ++n2;
            }
            resourceSetListenerArray = this.getAggregatePrecommitListeners();
            n = resourceSetListenerArray.length;
            n2 = 0;
            while (n2 < n) {
                ResourceSetListener resourceSetListener = resourceSetListenerArray[n2];
                this.removeResourceSetListener(resourceSetListener);
                ++n2;
            }
            workspaceCommandStack.dispose();
            for (IEditingDomainListener iEditingDomainListener : this.getEditingDomainListeners()) {
                iEditingDomainListener.disposedEditingDomain((EditingDomain)this);
            }
        }

        private List<IEditingDomainListener> getEditingDomainListeners() {
            if (this.editingDomainListeners == null) {
                IConfigurationElement[] configurationElements;
                this.editingDomainListeners = new ArrayList<IEditingDomainListener>();
                IConfigurationElement[] iConfigurationElementArray = configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.common.ef", (String)"editingDomainListener");
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    IEditingDomainListener instance = (IEditingDomainListener)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                    if (instance != null) {
                        this.editingDomainListeners.add(instance);
                    }
                    ++n2;
                }
            }
            return this.editingDomainListeners;
        }

        public SemanticCrossReferencer getCrossReferencer() {
            SemanticResourceSet semanticResourceSet = this.getResourceSet();
            if (semanticResourceSet != null) {
                return semanticResourceSet.getCrossReferencer();
            }
            return null;
        }

        public DataNotifier getDataNotifier() {
            return this.getResourceSet().getDataNotifier();
        }

        public SemanticResourceSet getResourceSet() {
            return (SemanticResourceSet)super.getResourceSet();
        }

        public boolean isControllable(Object object) {
            if (!(object instanceof EObject)) {
                return false;
            }
            EObject eObject = (EObject)object;
            EObject container = eObject.eContainer();
            return container != null && eObject.eContainmentFeature().isResolveProxies();
        }

        public boolean isReadOnly(Resource resource) {
            IReadOnlyDelegationHandler readOnlyDelegationHandler;
            boolean result = true;
            this.resourceToReadOnlyMap.clear();
            ISemanticEditingDomainProviders providers = SemanticEditingDomainFactory.this.getSemanticEditingDomainProviders();
            if (providers != null && (readOnlyDelegationHandler = providers.getReadOnlyDelegationHandler()) != null) {
                result = readOnlyDelegationHandler.isReadOnly(resource);
            }
            return result ? super.isReadOnly(resource) : false;
        }

        protected TransactionChangeRecorder createChangeRecorder(ResourceSet rset) {
            TransactionChangeRecorder result = null;
            ITransactionChangeRecorderProvider transactionChangeRecorderProvider = SemanticEditingDomainFactory.this.getSemanticEditingDomainProviders().getTransactionChangeRecorderProvider();
            result = transactionChangeRecorderProvider != null ? transactionChangeRecorderProvider.getTransactionChangeRecorder((InternalTransactionalEditingDomain)this, rset) : super.createChangeRecorder(rset);
            return result;
        }
    }

    public class SemanticResourceSet
    extends ResourceSetImpl
    implements IEditingDomainProvider {
        private EditingDomain editingDomain;
        private SemanticCrossReferencer crossReferencer;
        private DataNotifier dataNotifier;
        private volatile int resourcesLoading = 0;
        private volatile boolean forceResourcesLoading = false;

        public SemanticResourceSet() {
            this.setURIResourceMap(new HashMap());
        }

        public void registerAdapters() {
            this.loadCrossReferencers(this.getEditingDomain());
            if (this.crossReferencer != null) {
                this.eAdapters().add((Object)this.crossReferencer);
            }
            this.dataNotifier = new DataNotifier(this.getEditingDomain());
            this.eAdapters().add((Object)this.dataNotifier);
        }

        public Resource getResource(URI uri, boolean loadOnDemand) {
            if (loadOnDemand) {
                ++this.resourcesLoading;
            }
            try {
                Resource resource = super.getResource(uri, loadOnDemand);
                return resource;
            }
            finally {
                if (loadOnDemand) {
                    --this.resourcesLoading;
                }
            }
        }

        protected SemanticCrossReferencer getCrossReferencer() {
            return this.crossReferencer;
        }

        DataNotifier getDataNotifier() {
            return this.dataNotifier;
        }

        public EditingDomain getEditingDomain() {
            return this.editingDomain;
        }

        public boolean isResourceLoading() {
            return this.forceResourcesLoading || this.resourcesLoading > 0;
        }

        public boolean setForceResourceLoading(boolean forceResourceLoading) {
            this.forceResourcesLoading = forceResourceLoading;
            return this.forceResourcesLoading;
        }

        protected void loadCrossReferencers(EditingDomain editingDomain) {
            ICrossReferencerProvider provider;
            ISemanticEditingDomainProviders semanticEditingDomainProviders = SemanticEditingDomainFactory.this.getSemanticEditingDomainProviders();
            if (semanticEditingDomainProviders != null && (provider = semanticEditingDomainProviders.getCrossReferencerProvider()) != null) {
                this.crossReferencer = provider.getCrossReferencer(editingDomain);
            }
        }

        protected void setEditingDomain(EditingDomain editingDomain) {
            this.editingDomain = editingDomain;
        }

        public Resource.Factory.Registry getResourceFactoryRegistry() {
            ISemanticEditingDomainProviders semanticEditingDomainProviders = SemanticEditingDomainFactory.this.getSemanticEditingDomainProviders();
            if (semanticEditingDomainProviders != null) {
                return semanticEditingDomainProviders.getResourceFactoryRegistry(super.getResourceFactoryRegistry());
            }
            return super.getResourceFactoryRegistry();
        }
    }
}

