/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.common.ui.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionController;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionValidateWizardPage;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionWizardPage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;

public class LCDecompositionWizard
extends Wizard {
    private DecompositionModel decompositionModel;
    private LCDecompositionWizardPage lcDecompositionWizardPage;
    private LCDecompositionValidateWizardPage lcDecompositionValidateWizardPage;
    private LCDecompositionController controller;

    public LCDecompositionWizard() {
    }

    public LCDecompositionWizard(DecompositionModel decompModel) {
        this.setDecompositionModel(decompModel);
        this.lcDecompositionWizardPage = new LCDecompositionWizardPage(this.decompositionModel);
        this.lcDecompositionValidateWizardPage = new LCDecompositionValidateWizardPage(this.decompositionModel);
        this.addPage((IWizardPage)this.lcDecompositionWizardPage);
        this.addPage((IWizardPage)this.lcDecompositionValidateWizardPage);
        this.setNeedsProgressMonitor(true);
    }

    public void initComponents() {
        this.lcDecompositionWizardPage = new LCDecompositionWizardPage(this.getDecompositionModel());
        this.lcDecompositionWizardPage.setController(this.getController());
        this.lcDecompositionValidateWizardPage = new LCDecompositionValidateWizardPage(this.getDecompositionModel());
        this.lcDecompositionValidateWizardPage.setController(this.getController());
        this.addPage((IWizardPage)this.lcDecompositionWizardPage);
        this.addPage((IWizardPage)this.lcDecompositionValidateWizardPage);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        return this.decompositionModel.finishDecomposition();
    }

    public boolean canFinish() {
        boolean decompositionComplete = this.controller.isDecompositionComplete();
        boolean userHasDeletedSubComponent = this.controller.userHasDeletedSubComponent();
        return userHasDeletedSubComponent || decompositionComplete;
    }

    public LCDecompositionController getController() {
        return this.controller;
    }

    public void setController(LCDecompositionController controller) {
        this.controller = controller;
    }

    public DecompositionModel getDecompositionModel() {
        return this.decompositionModel;
    }

    public void setDecompositionModel(DecompositionModel decompositionModel) {
        this.decompositionModel = decompositionModel;
    }

    public void trigger() {
        boolean flag = this.controller.isDecompositionComplete();
        this.lcDecompositionWizardPage.setPageComplete(flag);
        this.lcDecompositionValidateWizardPage.setPageComplete(flag);
    }

    public Image getDefaultPageImage() {
        ImageDescriptor pngImageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(LaPackage.Literals.LOGICAL_COMPONENT);
        Image image = pngImageDescriptor != null ? pngImageDescriptor.createImage() : super.getDefaultPageImage();
        return image;
    }
}

