/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.properties.fields;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.ChangeEvent;
import org.polarsys.capella.core.data.capellacommon.StateEvent;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacommon.TimeEvent;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.common.properties.CommonPropertiesPlugin;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.controllers.AbstractMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.ContainmentTableField;
import org.polarsys.capella.core.ui.properties.fields.EditableSemanticFieldException;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.capella.core.ui.properties.helpers.NamingHelper;
import org.polarsys.capella.core.ui.properties.viewers.IDelegatedViewer;
import org.polarsys.capella.core.ui.properties.viewers.TableDelegatedViewer;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;
import org.polarsys.capella.core.ui.toolkit.viewers.CapellaElementLabelProvider;

public class StateTransitionTriggerField
extends ContainmentTableField {
    private Button _timeEventBtn;
    private Button _changeEventBtn;
    private Button _openBtn;
    private IMultipleSemanticFieldController _controller = new AbstractMultipleSemanticFieldController(){

        protected IBusinessQuery getReadOpenValuesQuery(EObject semanticElement) {
            return BusinessQueriesProvider.getInstance().getContribution(semanticElement.eClass(), (EStructuralFeature)CapellacommonPackage.eINSTANCE.getStateTransition_Triggers());
        }
    };

    public StateTransitionTriggerField(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, EReference referencerFeature, EReference referencedFeature, EClass referencedFeatureType, String label, String selectionElementDialogMessage) {
        super(parent, widgetFactory, referencerFeature, referencedFeature, referencedFeatureType, label, selectionElementDialogMessage, (IDelegatedViewer)new CustomDelegatedViewer(widgetFactory));
    }

    protected static String getCustomText(Object object, int columnIndex) {
        if (object instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)object;
            String res = "[" + changeEvent.getKind() + "]";
            res = changeEvent.getExpression() != null ? String.valueOf(res) + " " + StateTransitionTriggerField.getConstraintLabel(changeEvent.getExpression()) : String.valueOf(res) + " " + changeEvent.getName();
            return res;
        }
        if (object instanceof TimeEvent) {
            TimeEvent timeEvent = (TimeEvent)object;
            String res = "[" + timeEvent.getKind() + "]";
            res = timeEvent.getExpression() != null ? String.valueOf(res) + " " + StateTransitionTriggerField.getConstraintLabel(timeEvent.getExpression()) : String.valueOf(res) + " " + timeEvent.getName();
            return res;
        }
        return null;
    }

    protected void createCustomActions(Composite parent) {
        this._timeEventBtn = this.createTableButton(parent, CommonPropertiesPlugin.getDefault().getImage("full/obj16/TimeEvent.gif"), new Runnable(){

            @Override
            public void run() {
                StateTransitionTriggerField.this.handleStateEventButtonClick(CapellacommonPackage.Literals.TIME_EVENT);
            }
        });
        this._timeEventBtn.setToolTipText("Create a Time Event");
        this._changeEventBtn = this.createTableButton(parent, CommonPropertiesPlugin.getDefault().getImage("full/obj16/ChangeEvent.gif"), new Runnable(){

            @Override
            public void run() {
                StateTransitionTriggerField.this.handleStateEventButtonClick(CapellacommonPackage.Literals.CHANGE_EVENT);
            }
        });
        this._changeEventBtn.setToolTipText("Create a Change Event");
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image openImage = imgRegistry.get("toolitem.browse");
        this._openBtn = this.createTableButton(parent, openImage, new Runnable(){

            @Override
            public void run() {
                StateTransitionTriggerField.this.handleOpenButtonClick(StateTransitionTriggerField.this._openBtn);
            }
        });
        this._openBtn.setToolTipText("Browse available elements");
    }

    protected void handleStateEventButtonClick(final EClass eventClass) throws EditableSemanticFieldException {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                StateEvent stateEvent = (StateEvent)CapellacommonFactory.eINSTANCE.create(eventClass);
                BlockArchitectureExt.getDataPkg((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)StateTransitionTriggerField.this.semanticElement)).getOwnedStateEvents().add((Object)stateEvent);
                CapellaElementExt.creationService((EObject)stateEvent);
                if (CapellaUIPropertiesPlugin.getDefault().openWizard((EObject)stateEvent)) {
                    ((List)StateTransitionTriggerField.this.semanticElement.eGet(StateTransitionTriggerField.this.semanticFeature)).add(stateEvent);
                } else {
                    stateEvent.destroy();
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)this.semanticElement).execute((ICommand)command);
        this.refreshViewer();
    }

    protected void handleOpenButtonClick(final Button button) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                List currentElements = StateTransitionTriggerField.this._controller.readOpenValues(StateTransitionTriggerField.this.semanticElement, StateTransitionTriggerField.this.semanticFeature, false);
                List availableElements = StateTransitionTriggerField.this._controller.readOpenValues(StateTransitionTriggerField.this.semanticElement, StateTransitionTriggerField.this.semanticFeature, true);
                availableElements.removeAll(currentElements);
                String title = NamingHelper.getDefaultTitle((EObject)StateTransitionTriggerField.this.semanticElement);
                String message = NamingHelper.getDefaultMessage((EObject)StateTransitionTriggerField.this.semanticElement, (String)(StateTransitionTriggerField.this.semanticFeature != null ? StateTransitionTriggerField.this.semanticFeature.getName() : ""));
                List allResults = DialogHelper.openTransferDialog((Control)button, (List)currentElements, (List)availableElements, (String)title, (String)message);
                if (allResults != null) {
                    StateTransitionTriggerField.this._controller.writeOpenValues(StateTransitionTriggerField.this.semanticElement, StateTransitionTriggerField.this.semanticFeature, allResults);
                }
            }
        };
        this.executeCommand((ICommand)command);
        this.refreshViewer();
    }

    protected void handleDelete() {
        ColumnViewer columnViewer;
        if (this._delegatedViewer != null && (columnViewer = this._delegatedViewer.getColumnViewer()) != null) {
            final List selectedReferencedElements = ((IStructuredSelection)columnViewer.getSelection()).toList();
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    for (Object object : selectedReferencedElements) {
                        if (!(StateTransitionTriggerField.this.semanticElement instanceof StateTransition)) continue;
                        StateTransition transition = (StateTransition)StateTransitionTriggerField.this.semanticElement;
                        transition.getTriggers().remove(object);
                    }
                }
            };
            this.executeCommand((ICommand)command);
            this.refreshViewer();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._timeEventBtn != null && !this._timeEventBtn.isDisposed()) {
            this._timeEventBtn.setEnabled(enabled);
        }
        if (this._changeEventBtn != null && !this._changeEventBtn.isDisposed()) {
            this._changeEventBtn.setEnabled(enabled);
        }
    }

    private static String getConstraintLabel(Constraint constraint) {
        return CapellaEmbeddedLinkedTextEditorInput.getDefaultText((Constraint)constraint, (String)constraint.getName());
    }

    static class CustomDelegatedViewer
    extends TableDelegatedViewer {
        CustomDelegatedViewer(TabbedPropertySheetWidgetFactory widgetFactory) {
            super(widgetFactory);
        }

        public void createContainer(Composite subarent) {
            super.createContainer(subarent);
            this._columnViewer.setLabelProvider((IBaseLabelProvider)new CapellaElementLabelProvider(){

                public final String getColumnText(Object object, int columnIndex) {
                    final String customText = StateTransitionTriggerField.getCustomText(object, columnIndex);
                    if (customText == null) {
                        return super.getColumnText(object, columnIndex);
                    }
                    return (String)this.run(object, (RunnableWithResult)new RunnableWithResult.Impl<String>(){

                        public void run() {
                            this.setResult(customText);
                        }
                    });
                }
            });
        }
    }
}

