/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.helpers.query.MDEQueries;
import org.polarsys.capella.common.platform.sirius.ted.SemanticCrossReferencer;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;

public class EObjectExt
extends EcoreUtil2 {
    public static Set<EObject> getAll(EObject currentElement, EClass targetType) {
        ArrayList filters = new ArrayList();
        return MDEQueries.getInstance().getAllQueries().getAllFiltered(currentElement, targetType, filters);
    }

    public static List<EObject> getReferencers(EObject eObjectRef, EClass metaClass, EReference eRef) {
        ArrayList<EObject> returnedList = new ArrayList<EObject>();
        for (EObject anObject : EObjectExt.getReferencers(eObjectRef, eRef)) {
            if (!anObject.eClass().equals(metaClass) && !anObject.eClass().getEAllSuperTypes().contains((Object)metaClass)) continue;
            returnedList.add(anObject);
        }
        return returnedList;
    }

    public static List<EObject> getReferencers(EObject eObjectRef) {
        TransactionalEditingDomain domain = TransactionHelper.getEditingDomain(eObjectRef);
        if (domain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)domain;
            return EObjectExt.getReferencers(eObjectRef, null, editingDomain);
        }
        return Collections.emptyList();
    }

    public static <T extends EObject> List<T> getReferencers(EObject eObjectRef, EReference eRef) {
        TransactionalEditingDomain domain = TransactionHelper.getEditingDomain(eObjectRef);
        if (domain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)domain;
            return EObjectExt.getReferencers(eObjectRef, eRef, editingDomain);
        }
        return Collections.emptyList();
    }

    public static <T extends EObject> List<T> getReferencers(EObject eObjectRef, EReference eRef, SemanticEditingDomainFactory.SemanticEditingDomain editingDomain, boolean ignoreDerivedFeature) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        SemanticCrossReferencer crossReferencer = editingDomain.getCrossReferencer();
        if (eRef == null) {
            Collection inverseReferences = crossReferencer.getInverseReferences(eObjectRef, editingDomain.getCrossReferencer().isResolveProxyEnabled());
            for (EStructuralFeature.Setting setting : inverseReferences) {
                if (ignoreDerivedFeature && setting.getEStructuralFeature().isDerived() || result.contains(setting.getEObject())) continue;
                result.add(setting.getEObject());
            }
        } else {
            if (ignoreDerivedFeature && eRef.isDerived()) {
                return result;
            }
            Collection inverseReferences = crossReferencer.getInverseReferences(eObjectRef, (EStructuralFeature)eRef, editingDomain.getCrossReferencer().isResolveProxyEnabled());
            for (EStructuralFeature.Setting setting : inverseReferences) {
                if (result.contains(setting.getEObject())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public static <T extends EObject> List<T> getReferencers(EObject eObjectRef, EReference eRef, SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        return EObjectExt.getReferencers(eObjectRef, eRef, editingDomain, false);
    }

    public static List<EObject> getReferencers(EObject eObjectRef, List<EReference> eRefs) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EReference ref : eRefs) {
            result.addAll(EObjectExt.getReferencers(eObjectRef, ref));
        }
        return result;
    }

    public static boolean isInstanceOf(EObject elt, List<EClass> expectedContainerType) {
        if (elt == null || expectedContainerType.isEmpty()) {
            return false;
        }
        for (EClass eClass : expectedContainerType) {
            if (!eClass.isInstance((Object)elt)) continue;
            return true;
        }
        return false;
    }

    public static ResourceSet getCommonResourceSet(Collection<? extends EObject> eObjects) {
        ResourceSet resourceSet = null;
        for (EObject eObject : eObjects) {
            if (eObject == null) {
                return null;
            }
            Resource eResource = eObject.eResource();
            if (eResource == null) continue;
            if (resourceSet == null) {
                resourceSet = eResource.getResourceSet();
                continue;
            }
            if (resourceSet.equals(eResource.getResourceSet())) continue;
            return null;
        }
        return resourceSet;
    }

    public static ResourceSet getCommonResourceSet(List<Resource> resources) {
        ResourceSet rs = null;
        for (Resource res : resources) {
            if (rs == null) {
                rs = res.getResourceSet();
                continue;
            }
            if (rs.equals(res.getResourceSet())) continue;
            return null;
        }
        return rs;
    }

    public static String getText(EObject object) {
        IItemLabelProvider provider = EObjectExt.getItemLabelProvider(object);
        String label = "";
        if (provider != null) {
            label = provider.getText((Object)object);
        }
        return label;
    }

    protected static IItemLabelProvider getItemLabelProvider(EObject object) {
        if (object == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain(object);
        if (editingDomain == null) {
            editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        }
        if (editingDomain == null || !(editingDomain instanceof AdapterFactoryEditingDomain)) {
            return null;
        }
        return (IItemLabelProvider)((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
    }
}

