/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.util.UserProperty;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonResourceManager;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultDifferenceCategoryProvider;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategoryProvider;
import org.eclipse.emf.diffmerge.ui.viewers.SelectionBridge;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractComparisonViewer
extends Viewer
implements IFlushable,
IPropertyChangeNotifier,
ICompareInputChangeListener,
IAdaptable {
    public static final String PROPERTY_CURRENT_INPUT = "PROPERTY_CURRENT_INPUT";
    private IActionBars _actionBars;
    private final Set<IPropertyChangeListener> _changeListeners;
    private Shell _shell;
    private Composite _control;
    protected boolean _isExternallySynced;
    private EMFDiffNode _input;
    private IDifferenceCategoryProvider _categoryProvider;
    private Object _lastCommandBeforeSave;
    private UndoAction _undoAction;
    private RedoAction _redoAction;
    private INavigatable _navigatable;
    protected SelectionBridge _selectionBridgeToOutside;

    public AbstractComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        this._actionBars = actionBars_p;
        this._shell = parent_p.getShell();
        this._changeListeners = new HashSet<IPropertyChangeListener>(1);
        this._input = null;
        this._isExternallySynced = true;
        this._lastCommandBeforeSave = null;
        this._categoryProvider = new DefaultDifferenceCategoryProvider();
        this._selectionBridgeToOutside = null;
        this.setupUndoRedo();
        this._control = this.createControls(parent_p);
        this.setupSelectionProvider();
        this.hookControl((Control)this._control);
        this.registerNavigatable((Control)this._control, this.createNavigatable());
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
        this._changeListeners.add(listener_p);
    }

    public void compareInputChanged(final ICompareInput source_p) {
        final Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractComparisonViewer.this.handleCompareInputChanged(source_p);
                    }
                });
            }
        });
    }

    protected abstract Composite createControls(Composite var1);

    protected INavigatable createNavigatable() {
        return null;
    }

    protected void executeOnComparison(Runnable runnable_p) {
        EMFDiffNode input = this.getInput();
        boolean recordChanges = input != null && input.isUndoRedoSupported();
        EditingDomain domain = this.getEditingDomain();
        try {
            MiscUtil.executeWithBusyCursor(domain, null, runnable_p, recordChanges, this.getDisplay());
        }
        catch (Exception e) {
            throw new OperationCanceledException(e.getLocalizedMessage());
        }
    }

    protected void executeOnModel(Runnable runnable_p, boolean onLeft_p) {
        EMFDiffNode input = this.getInput();
        boolean recordChanges = input != null && input.isUndoRedoSupported();
        EditingDomain domain = this.getEditingDomain(onLeft_p);
        try {
            MiscUtil.executeWithBusyCursor(domain, null, runnable_p, recordChanges, this.getDisplay());
        }
        catch (Exception e) {
            throw new OperationCanceledException(e.getLocalizedMessage());
        }
    }

    protected void didSave() {
        Object[] currentUndoCommand = this.getUndoCommand();
        if (currentUndoCommand.length > 0) {
            this._lastCommandBeforeSave = currentUndoCommand[0];
        }
    }

    protected void executeOnModel(IRunnableWithProgress behavior_p, boolean onLeft_p) {
        EMFDiffNode input = this.getInput();
        boolean recordChanges = input != null && input.isUndoRedoSupported();
        EditingDomain domain = this.getEditingDomain(onLeft_p);
        try {
            MiscUtil.executeWithProgress(domain, null, behavior_p, recordChanges);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OperationCanceledException(e.getLocalizedMessage());
        }
    }

    protected void firePropertyChangeEvent(String propertyName_p, Object newValue_p) {
        this.firePropertyChangeEvent(propertyName_p, newValue_p, null);
    }

    protected void firePropertyChangeEvent(String propertyName_p, Object newValue_p, Object oldValue_p) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName_p, oldValue_p, newValue_p);
        for (IPropertyChangeListener listener : this._changeListeners) {
            listener.propertyChange(event);
        }
    }

    public void flush(IProgressMonitor monitor_p) {
        EComparison comparison = this.getComparison();
        if (comparison != null) {
            try {
                IFeaturedModelScope rightScope;
                IFeaturedModelScope leftScope;
                if (this.getInput().isModified(true) && (leftScope = comparison.getScope(this.getInput().getRoleForSide(true))) instanceof IPersistentModelScope.Editable) {
                    ((IPersistentModelScope.Editable)leftScope).save();
                }
                if (this.getInput().isModified(false) && (rightScope = comparison.getScope(this.getInput().getRoleForSide(false))) instanceof IPersistentModelScope.Editable) {
                    ((IPersistentModelScope.Editable)rightScope).save();
                }
                this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(false));
                this.didSave();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFDiffMergeUIPlugin.LABEL, (String)(String.valueOf(Messages.ComparisonViewer_SaveFailed) + e));
            }
        }
    }

    public Object getAdapter(Class adapter_p) {
        Object result = null;
        if (INavigatable.class.equals((Object)adapter_p)) {
            result = this.getNavigatable();
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter((Object)this, adapter_p);
        }
        return result;
    }

    public IDifferenceCategoryProvider getCategoryProvider() {
        return this._categoryProvider;
    }

    protected EComparison getComparison() {
        UIComparison uiComparison = this.getUIComparison();
        return uiComparison == null ? null : uiComparison.getActualComparison();
    }

    public Composite getControl() {
        return this._control;
    }

    protected Display getDisplay() {
        Display result = Display.getCurrent();
        if (result == null) {
            result = Display.getDefault();
        }
        return result;
    }

    protected Role getDrivingRole() {
        return this.getInput() == null ? null : this.getInput().getDrivingRole();
    }

    protected EditingDomain getEditingDomain() {
        return this.getInput() == null ? null : this.getInput().getEditingDomain();
    }

    protected EditingDomain getEditingDomain(boolean onLeft_p) {
        EComparison comparison;
        EMFDiffNode input;
        EditingDomain result = this.getEditingDomain();
        if (result == null && (input = this.getInput()) != null && (comparison = input.getActualComparison()) != null) {
            Resource resource;
            IFeaturedModelScope impactedScope = comparison.getScope(input.getRoleForSide(onLeft_p));
            if (impactedScope instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)impactedScope).getEditingDomain();
            }
            if (result == null && impactedScope instanceof IPersistentModelScope && (resource = ((IPersistentModelScope)impactedScope).getHoldingResource()) != null) {
                result = TransactionUtil.getEditingDomain((Resource)resource);
            }
        }
        return result;
    }

    protected Object getLastCommandBeforeSave() {
        return this._lastCommandBeforeSave;
    }

    protected String getModelName(boolean onLeft_p) {
        IEditableModelScope scope = this.getComparison().getScope(this.getInput().getRoleForSide(onLeft_p));
        return DiffMergeLabelProvider.getInstance().getText(scope);
    }

    protected abstract ISelectionProvider getMultiViewerSelectionProvider();

    public INavigatable getNavigatable() {
        return this._navigatable;
    }

    protected IWorkbenchPage getPage() {
        IWorkbenchPage result = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            result = window.getActivePage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected ComparisonResourceManager getResourceManager() {
        return this.getInput() == null ? null : this.getInput().getResourceManager();
    }

    public ISelectionProvider getSelectionProvider() {
        return this._selectionBridgeToOutside;
    }

    protected Shell getShell() {
        return this._shell;
    }

    protected IWorkbenchPartSite getSite() {
        IWorkbenchPartSite result = null;
        if (this.isInWorkbenchWindow()) {
            try {
                IWorkbenchPage page = this.getPage();
                IWorkbenchPartSite site = page.getActivePart().getSite();
                if (site instanceof IWorkbenchPartSite) {
                    result = site;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected Role getTargetRole() {
        return this.getInput() == null ? null : this.getInput().getTargetRole();
    }

    protected UIComparison getUIComparison() {
        return this.getInput() == null ? null : this.getInput().getUIComparison();
    }

    protected Image getImage(EMFDiffMergeUIPlugin.ImageID id_p) {
        return EMFDiffMergeUIPlugin.getDefault().getImage(id_p);
    }

    protected ImageDescriptor getImageDescriptor(EMFDiffMergeUIPlugin.ImageID id_p) {
        return EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(id_p);
    }

    public EMFDiffNode getInput() {
        return this._input;
    }

    protected Object[] getUndoCommand() {
        Object[] result = new Object[]{};
        EMFDiffNode input = this.getInput();
        if (input != null) {
            IUndoContext undoContext = input.getUndoContext();
            if (undoContext != null) {
                IOperationHistory opHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                result = new Object[]{opHistory.getUndoOperation(undoContext)};
            } else {
                EditingDomain domain = input.getEditingDomain();
                if (domain != null) {
                    result = new Object[]{this.getEditingDomain().getCommandStack().getUndoCommand()};
                }
            }
        }
        return result;
    }

    protected void handleDispose() {
        this.setSelection((ISelection)StructuredSelection.EMPTY, false);
        if (this._selectionBridgeToOutside != null) {
            this.getMultiViewerSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this._selectionBridgeToOutside);
            this._selectionBridgeToOutside.clearListeners();
            this._selectionBridgeToOutside = null;
        }
        if (this._actionBars != null) {
            this._actionBars.clearGlobalActionHandlers();
            this._actionBars = null;
        }
        this._changeListeners.clear();
        this._input = null;
        this._shell = null;
        this._control = null;
        this._lastCommandBeforeSave = null;
        this._undoAction = null;
        this._redoAction = null;
        this._navigatable = null;
    }

    protected void handleCompareInputChanged(ICompareInput source_p) {
        Object[] undoCommand;
        EditingDomain domain;
        if (source_p instanceof IEditingDomainProvider && (domain = ((IEditingDomainProvider)source_p).getEditingDomain()) != null && (undoCommand = this.getUndoCommand()).length > 0) {
            boolean newDirty = undoCommand[0] != this.getLastCommandBeforeSave();
            this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(newDirty));
        }
        this.refresh();
    }

    private void hookControl(Control control_p) {
        control_p.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AbstractComparisonViewer.this.handleDispose();
            }
        });
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        if (oldInput_p instanceof ICompareInput) {
            ((ICompareInput)oldInput_p).removeCompareInputChangeListener((ICompareInputChangeListener)this);
        }
        if (this._undoAction != null) {
            this._undoAction.setEditingDomain(this.getEditingDomain());
            this._undoAction.update();
        }
        if (this._redoAction != null) {
            this._redoAction.setEditingDomain(this.getEditingDomain());
            this._redoAction.update();
        }
        if (this._actionBars != null) {
            this._actionBars.updateActionBars();
        }
        if (input_p instanceof EMFDiffNode) {
            EMFDiffNode node = (EMFDiffNode)input_p;
            this.registerUserProperties(node);
            this.registerCategories(node);
            node.updateDifferenceNumbers();
            node.getCategoryManager().setDefaultConfiguration();
        }
        if (input_p instanceof ICompareInput) {
            final ICompareInput compareInput = (ICompareInput)input_p;
            compareInput.addCompareInputChangeListener((ICompareInputChangeListener)this);
            this.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e_p) {
                    compareInput.removeCompareInputChangeListener((ICompareInputChangeListener)AbstractComparisonViewer.this);
                }
            });
        }
        this.firePropertyChangeEvent(PROPERTY_CURRENT_INPUT, input_p, oldInput_p);
    }

    protected boolean isInternalSelectionProvider(ISelectionProvider provider_p) {
        return provider_p == this || provider_p == this.getMultiViewerSelectionProvider();
    }

    protected boolean isInWorkbenchWindow() {
        Shell ownShell = this.getShell();
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.isClosing()) {
            IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                if (ownShell == window.getShell()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean isUserPropertyFalse(UserProperty.Identifier<Boolean> id_p) {
        EMFDiffNode input = this.getInput();
        return input != null && input.isUserPropertyFalse(id_p);
    }

    protected boolean isUserPropertyTrue(UserProperty.Identifier<Boolean> id_p) {
        EMFDiffNode input = this.getInput();
        return input != null && input.isUserPropertyTrue(id_p);
    }

    public void refresh() {
        this.refreshTools();
    }

    protected void refreshTools() {
        if (this._undoAction != null) {
            this._undoAction.update();
        }
        if (this._redoAction != null) {
            this._redoAction.update();
        }
        if (this._actionBars != null) {
            try {
                this._actionBars.updateActionBars();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected void registerCategories(EMFDiffNode node_p) {
        IDifferenceCategoryProvider provider = this.getCategoryProvider();
        if (provider != null) {
            provider.provideCategories(node_p);
        }
    }

    protected void registerNavigatable(Control control_p, INavigatable navigatable_p) {
        this._navigatable = navigatable_p;
        if (this._navigatable != null) {
            control_p.setData("org.eclipse.compare.internal.Navigator", (Object)this._navigatable);
        }
    }

    protected void registerUserProperties(EMFDiffNode input_p) {
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener_p) {
        this._changeListeners.remove(listener_p);
    }

    public void setCategoryProvider(IDifferenceCategoryProvider provider_p) {
        this._categoryProvider = provider_p;
    }

    public void setInput(Object input_p) {
        if (input_p == null || input_p instanceof EMFDiffNode) {
            EMFDiffNode oldInput = this.getInput();
            this._input = (EMFDiffNode)input_p;
            this.inputChanged(this._input, oldInput);
        }
    }

    protected void setupSelectionProvider() {
        IWorkbenchPartSite site = this.getSite();
        if (site != null) {
            this._selectionBridgeToOutside = new SelectionBridge(){

                @Override
                public void selectionChanged(SelectionChangedEvent event_p) {
                    if (AbstractComparisonViewer.this._isExternallySynced && AbstractComparisonViewer.this.isInternalSelectionProvider(event_p.getSelectionProvider())) {
                        super.selectionChanged(event_p);
                    }
                }
            };
            this.getMultiViewerSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this._selectionBridgeToOutside);
            site.setSelectionProvider((ISelectionProvider)this._selectionBridgeToOutside);
            ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener((IWorkbenchSite)site){
                private final /* synthetic */ IWorkbenchSite val$site;
                {
                    this.val$site = iWorkbenchSite;
                }

                public void selectionChanged(SelectionChangedEvent event_p) {
                    ISelectionService service;
                    IWorkbenchWindow window = this.val$site.getWorkbenchWindow();
                    if (window != null && !window.getWorkbench().isClosing() && (service = window.getSelectionService()) instanceof ISelectionChangedListener) {
                        ((ISelectionChangedListener)service).selectionChanged(event_p);
                    }
                }
            };
            this._selectionBridgeToOutside.addSelectionChangedListener(selectionChangedListener);
        }
    }

    protected void setupUndoRedo() {
        this._undoAction = new UndoAction(null){

            public void run() {
                AbstractComparisonViewer.this.undoRedo(true);
            }

            public void update() {
                if (this.getEditingDomain() != null) {
                    super.update();
                }
            }
        };
        this._undoAction.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.UNDO));
        this._redoAction = new RedoAction(){

            public void run() {
                AbstractComparisonViewer.this.undoRedo(false);
            }

            public void update() {
                if (this.getEditingDomain() != null) {
                    super.update();
                }
            }
        };
        this._redoAction.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.REDO));
        if (this._actionBars != null) {
            this._actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this._undoAction);
            this._actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this._redoAction);
        }
    }

    protected void undoRedo(final boolean undo_p) {
        final EditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    CommandStack stack = editingDomain.getCommandStack();
                    ComparisonSelection lastActionSelection = AbstractComparisonViewer.this.getUIComparison().getLastActionSelection();
                    if (undo_p && stack.canUndo()) {
                        stack.undo();
                    } else if (!undo_p && stack.canRedo()) {
                        stack.redo();
                    }
                    EMFDiffNode input = AbstractComparisonViewer.this.getInput();
                    if (input != null && !input.isReactive()) {
                        input.updateDifferenceNumbers();
                    }
                    if (lastActionSelection != null) {
                        AbstractComparisonViewer.this.setSelection((ISelection)lastActionSelection, true);
                    }
                }
            });
        }
    }
}

