/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.commands.LauncherCommand;
import org.polarsys.capella.core.transition.common.launcher.DefaultLauncher;
import org.polarsys.capella.core.transition.system.topdown.launcher.HeadlessIntramodelLauncher;

public class IntramodelTransitionCommand
extends LauncherCommand {
    public IntramodelTransitionCommand(Collection<?> selection, IProgressMonitor progressMonitor) {
        super(selection, progressMonitor);
    }

    public String getName() {
        return "Capella Transition";
    }

    protected DefaultLauncher createLauncher() {
        return new HeadlessIntramodelLauncher(){

            @Override
            protected String getMapping() {
                return IntramodelTransitionCommand.this.getTransitionMapping();
            }

            @Override
            protected String getOptionScope() {
                return IntramodelTransitionCommand.this.getTransitionKind();
            }
        };
    }

    protected String getTransitionMapping() {
        String id = "org.polarsys.";
        String kind = this.getTransitionKind();
        if (!("capella.core.transition.system.topdown.functional".equals(kind) || "capella.core.transition.system.topdown.interface".equals(kind) || "capella.core.transition.system.topdown.data".equals(kind) || "capella.core.transition.system.topdown.statemachine".equals(kind) || "capella.core.transition.system.topdown.propertyvalue".equals(kind) || "capella.core.transition.system.topdown.exchangeitem".equals(kind) || "capella.core.transition.system.topdown.actor".equals(kind) || "capella.core.transition.system.topdown.system".equals(kind))) {
            if ("capella.core.transition.system.topdown.lc2pc".equals(kind)) {
                return String.valueOf(id) + kind;
            }
            if ("capella.core.transition.system.topdown.oe2actor".equals(kind)) {
                return String.valueOf(id) + kind;
            }
            if ("capella.core.transition.system.topdown.oe2system".equals(kind)) {
                return String.valueOf(id) + kind;
            }
            if (!"capella.core.transition.system.topdown.capability".equals(kind)) {
                if ("capella.core.transition.system.topdown.oc2mission".equals(kind)) {
                    return String.valueOf(id) + kind;
                }
                if ("capella.core.transition.system.topdown.oa2capability".equals(kind)) {
                    return String.valueOf(id) + kind;
                }
                if ("capella.core.transition.system.topdown.oa2mission".equals(kind)) {
                    return String.valueOf(id) + kind;
                }
            }
        }
        return "org.polarsys.capella.core.transition.system.topdown";
    }

    protected String getTransitionKind() {
        return "capella.core.transition.system.topdown";
    }

    protected Collection<Object> retrieveRelatedElements(Object element) {
        String kind;
        Object rootElement = element;
        if (rootElement instanceof Part) {
            rootElement = ((Part)rootElement).getAbstractType();
        }
        if ("capella.core.transition.system.topdown.functional".equals(kind = this.getTransitionKind())) {
            if (rootElement instanceof BlockArchitecture) {
                HashSet<Object> result = new HashSet<Object>();
                for (AbstractCapability capability : AbstractCapabilityPkgExt.getAllAbstractCapabilities((AbstractCapabilityPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false))) {
                    result.addAll((Collection<Object>)capability.getOwnedFunctionalChains());
                }
                rootElement = BlockArchitectureExt.getFunctionPkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false);
                result.add(rootElement);
                return result;
            }
        } else if ("capella.core.transition.system.topdown.interface".equals(kind)) {
            if (rootElement instanceof BlockArchitecture) {
                rootElement = BlockArchitectureExt.getInterfacePkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false);
            } else if (rootElement instanceof Component) {
                rootElement = ComponentExt.getInterfacePkg((Component)((Component)rootElement), (boolean)false);
            }
        } else if ("capella.core.transition.system.topdown.data".equals(kind)) {
            if (rootElement instanceof BlockArchitecture) {
                rootElement = BlockArchitectureExt.getDataPkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false);
            } else if (rootElement instanceof Component) {
                rootElement = ComponentExt.getDataPkg((Component)((Component)rootElement), (boolean)false);
            }
        } else if ("capella.core.transition.system.topdown.statemachine".equals(kind)) {
            if (rootElement instanceof BlockArchitecture) {
                rootElement = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)((BlockArchitecture)rootElement), (boolean)false);
            }
            if (rootElement instanceof Component) {
                HashSet<Object> result = new HashSet<Object>();
                result.addAll((Collection<Object>)((Component)rootElement).getOwnedStateMachines());
                return result;
            }
        } else if (!"capella.core.transition.system.topdown.propertyvalue".equals(kind) && !"capella.core.transition.system.topdown.exchangeitem".equals(kind)) {
            if ("capella.core.transition.system.topdown.actor".equals(kind)) {
                if (rootElement instanceof BlockArchitecture) {
                    rootElement = BlockArchitectureExt.getActorPkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false);
                }
            } else if ("capella.core.transition.system.topdown.system".equals(kind)) {
                if (rootElement instanceof BlockArchitecture) {
                    rootElement = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)((BlockArchitecture)rootElement), (boolean)false);
                }
            } else if ("capella.core.transition.system.topdown.lc2pc".equals(kind)) {
                if (rootElement instanceof BlockArchitecture) {
                    rootElement = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)((BlockArchitecture)rootElement), (boolean)false);
                }
            } else if ("capella.core.transition.system.topdown.oe2actor".equals(kind)) {
                if (rootElement instanceof OperationalAnalysis) {
                    rootElement = ((OperationalAnalysis)rootElement).getOwnedEntityPkg();
                }
            } else if ("capella.core.transition.system.topdown.oe2system".equals(kind)) {
                if (rootElement instanceof OperationalAnalysis) {
                    rootElement = ((OperationalAnalysis)rootElement).getOwnedEntityPkg();
                }
            } else if ("capella.core.transition.system.topdown.capability".equals(kind)) {
                if (rootElement instanceof BlockArchitecture) {
                    rootElement = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false);
                }
            } else if ("capella.core.transition.system.topdown.oc2mission".equals(kind)) {
                if (rootElement instanceof BlockArchitecture) {
                    rootElement = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false);
                }
            } else if ("capella.core.transition.system.topdown.oa2capability".equals(kind)) {
                if (rootElement instanceof BlockArchitecture) {
                    rootElement = BlockArchitectureExt.getFunctionPkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false);
                }
            } else if ("capella.core.transition.system.topdown.oa2mission".equals(kind) && rootElement instanceof BlockArchitecture) {
                rootElement = BlockArchitectureExt.getFunctionPkg((BlockArchitecture)((BlockArchitecture)rootElement), (boolean)false);
            }
        }
        return Collections.singleton(rootElement);
    }
}

