/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.handlers.level;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.selection.CompoundSelectionContextHandler;
import org.polarsys.capella.core.transition.common.handlers.selection.ISelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.topdown.handlers.level.ILevelHandler;
import org.polarsys.capella.core.transition.system.topdown.handlers.level.LevelHandlerHelper;
import org.polarsys.capella.core.transition.system.topdown.handlers.selection.LevelSelectionContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DefaultLevelHandler
implements ILevelHandler {
    EClass[] clazzes = new EClass[]{OaPackage.Literals.OPERATIONAL_ANALYSIS, CtxPackage.Literals.SYSTEM_ANALYSIS, LaPackage.Literals.LOGICAL_ARCHITECTURE, PaPackage.Literals.PHYSICAL_ARCHITECTURE};
    String[] levelContext = new String[]{"SELECTION_CONTEXT__SOURCE_N2_ARCHITECTURE", "SELECTION_CONTEXT__TARGET_N1_ARCHITECTURE", "SELECTION_CONTEXT__SOURCE_ARCHITECTURE", "SELECTION_CONTEXT__TARGET_ARCHITECTURE"};

    @Override
    public void addScope(ILevelHandler.Level index_p, EObject result_p, IContext context_p) {
        String idContext = "";
        if (ILevelHandler.Level.PREVIOUS_N2.equals((Object)index_p)) {
            idContext = "SOURCE_N2_ARCHITECTURE_ELEMENTS";
        } else if (ILevelHandler.Level.PREVIOUS_N1.equals((Object)index_p)) {
            idContext = "SOURCE_N1_ARCHITECTURE_ELEMENTS";
        } else if (ILevelHandler.Level.SOURCE.equals((Object)index_p)) {
            idContext = "SOURCE_ARCHITECTURE_ELEMENTS";
        } else if (ILevelHandler.Level.TARGET.equals((Object)index_p)) {
            idContext = "TARGET_ARCHITECTURE_ELEMENTS";
        }
        ContextScopeHandlerHelper.getInstance((IContext)context_p).add(idContext, result_p, context_p);
    }

    @Override
    public ISelectionContext getSelectionContext(ILevelHandler.Level index_p, IContext context_p) {
        String idContext = "";
        if (ILevelHandler.Level.PREVIOUS_N2.equals((Object)index_p)) {
            idContext = "SELECTION_CONTEXT__SOURCE_N2_ARCHITECTURE";
        } else if (ILevelHandler.Level.PREVIOUS_N1.equals((Object)index_p)) {
            idContext = "SELECTION_CONTEXT__TARGET_N1_ARCHITECTURE";
        } else if (ILevelHandler.Level.SOURCE.equals((Object)index_p)) {
            idContext = "SELECTION_CONTEXT__SOURCE_ARCHITECTURE";
        } else if (ILevelHandler.Level.TARGET.equals((Object)index_p)) {
            idContext = "SELECTION_CONTEXT__TARGET_ARCHITECTURE";
        }
        if (idContext == null || idContext.isEmpty()) {
            return null;
        }
        return SelectionContextHandlerHelper.getHandler((IContext)context_p).getSelectionContext(context_p, idContext);
    }

    @Override
    public void initializeSelectionContexts(IContext context_p, CompoundSelectionContextHandler handler_p) {
        handler_p.addSelectionContext(context_p, "SELECTION_CONTEXT__SOURCE_N2_ARCHITECTURE", (ISelectionContext)new LevelSelectionContext(ILevelHandler.Level.PREVIOUS_N2));
        handler_p.addSelectionContext(context_p, "SELECTION_CONTEXT__TARGET_N1_ARCHITECTURE", (ISelectionContext)new LevelSelectionContext(ILevelHandler.Level.PREVIOUS_N1));
        handler_p.addSelectionContext(context_p, "SELECTION_CONTEXT__SOURCE_ARCHITECTURE", (ISelectionContext)new LevelSelectionContext(ILevelHandler.Level.SOURCE));
        handler_p.addSelectionContext(context_p, "SELECTION_CONTEXT__TARGET_ARCHITECTURE", (ISelectionContext)new LevelSelectionContext(ILevelHandler.Level.TARGET){

            @Override
            public boolean match(EObject source_p, EObject target_p, IContext context_p) {
                EClass clazz = TransformationHandlerHelper.getInstance((IContext)context_p).getTargetType(source_p, context_p);
                if (clazz != null && !clazz.isInstance((Object)target_p) && !(target_p instanceof BlockArchitecture)) {
                    return false;
                }
                EClass clazzLevel = LevelHandlerHelper.getInstance(context_p).getLevel(context_p, this.index);
                BlockArchitecture target = BlockArchitectureExt.getRootBlockArchitecture((EObject)target_p);
                if (clazzLevel == null) {
                    return false;
                }
                if (target == null) {
                    return true;
                }
                return clazzLevel.isInstance((Object)target);
            }
        });
    }

    private int getIndexLevel(IContext context_p, EClass wanted_p) {
        int iWanted = 0;
        EClass[] eClassArray = this.clazzes;
        int n = this.clazzes.length;
        int n2 = 0;
        while (n2 < n) {
            EClass clazze = eClassArray[n2];
            if (wanted_p.equals(clazze)) break;
            ++iWanted;
            ++n2;
        }
        return iWanted;
    }

    private int getIndexLevel(IContext context_p, ILevelHandler.Level level_p) {
        int index = 0;
        if (ILevelHandler.Level.PREVIOUS_N2.equals((Object)level_p)) {
            index = -2;
        } else if (ILevelHandler.Level.PREVIOUS_N1.equals((Object)level_p)) {
            index = -1;
        } else if (ILevelHandler.Level.SOURCE.equals((Object)level_p)) {
            index = 0;
        } else if (ILevelHandler.Level.TARGET.equals((Object)level_p)) {
            index = 1;
        }
        return index;
    }

    public BlockArchitecture getSourceArchitecture(IContext context_p) {
        Collection selection = (Collection)context_p.get((Object)"TRANSITION_SOURCES");
        if (selection.size() > 0) {
            EObject source = (EObject)selection.toArray()[0];
            return BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
        }
        return null;
    }

    @Override
    public LinkedList<ILevelHandler.Level> getLevels(IContext context_p) {
        EClass source = this.getSourceLevel(context_p);
        int index = this.getIndexLevel(context_p, source);
        LinkedList<ILevelHandler.Level> levels = new LinkedList<ILevelHandler.Level>();
        if (index - 2 >= 0) {
            levels.add(ILevelHandler.Level.PREVIOUS_N2);
        }
        if (index - 1 >= 0) {
            levels.add(ILevelHandler.Level.PREVIOUS_N1);
        }
        if (index >= 0) {
            levels.add(ILevelHandler.Level.SOURCE);
        }
        if (index + 1 >= 0) {
            levels.add(ILevelHandler.Level.TARGET);
        }
        return levels;
    }

    @Override
    public Collection<ILevelHandler.Level> getLevels(IContext context_p, EObject element_p) {
        LinkedList<ILevelHandler.Level> levels = new LinkedList<ILevelHandler.Level>();
        return levels;
    }

    @Override
    public EClass getLevel(IContext context_p, ILevelHandler.Level level_p) {
        int index = this.getIndexLevel(context_p, level_p);
        EClass source = this.getSourceLevel(context_p);
        if ((index += this.getIndexLevel(context_p, source)) >= 0 && index < this.clazzes.length) {
            return this.clazzes[index];
        }
        return null;
    }

    public ILevelHandler.Level getLevel(IContext context_p, EClass class_p) {
        int index = this.getIndexLevel(context_p, class_p);
        EClass source = this.getSourceLevel(context_p);
        if ((index -= this.getIndexLevel(context_p, source)) == -2) {
            return ILevelHandler.Level.PREVIOUS_N2;
        }
        if (index == -1) {
            return ILevelHandler.Level.PREVIOUS_N1;
        }
        if (index == 0) {
            return ILevelHandler.Level.SOURCE;
        }
        if (index == 1) {
            return ILevelHandler.Level.TARGET;
        }
        return null;
    }

    @Override
    public EClass getSourceLevel(IContext context_p) {
        BlockArchitecture sourceArchitecture = this.getSourceArchitecture(context_p);
        if (sourceArchitecture != null) {
            return sourceArchitecture.eClass();
        }
        return null;
    }

    public EClass getTargetLevel(EObject source_p, IContext context_p) {
        BlockArchitecture architecture = this.getSourceArchitecture(context_p);
        return TransformationHandlerHelper.getInstance((IContext)context_p).getTargetType((EObject)architecture, context_p);
    }

    @Override
    public ISelectionContext getSelectionContext(EObject element_p, IContext context_p) {
        EObject sourceElement = (EObject)TraceabilityHandlerHelper.getInstance((IContext)context_p).retrieveSourceElements(element_p, context_p).iterator().next();
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)sourceElement);
        if (architecture != null) {
            ILevelHandler.Level level = this.getLevel(context_p, architecture.eClass());
            return this.getSelectionContext(level, context_p);
        }
        return this.getSelectionContext((ILevelHandler.Level)null, context_p);
    }

    public IStatus init(IContext context_p) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context_p) {
        return Status.OK_STATUS;
    }
}

