/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.handlers.merge;

import java.util.Collection;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.transition.common.handlers.merge.CategoryFilter;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.system.topdown.handlers.merge.Messages;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class EmptyPackageCategoryFilter
extends CategoryFilter {
    public EmptyPackageCategoryFilter(IContext context) {
        super(context, Messages.EmptyPackageCategoryFilter, Messages.EmptyPackageCategoryFilter_Description);
        this.setCategorySet("category.business");
        this.setInFocusMode(false);
        this.setVisible(true);
        this.setActive(true);
    }

    public boolean covers(IDifference difference) {
        if (difference instanceof IElementPresence) {
            IElementPresence presence = (IElementPresence)difference;
            EObject element = presence.getElement();
            EObject target = presence.getElementMatch().get(Role.REFERENCE);
            if (target != null && this.isEmptyPackage(element, this.context) && !this.isSourceTransition(element, this.context)) {
                return true;
            }
        }
        return false;
    }

    private boolean isSourceTransition(EObject element, IContext context) {
        Collection sources = (Collection)context.get((Object)"TRANSITION_SOURCES");
        ITraceabilityHandler handler = (ITraceabilityHandler)context.get((Object)"TSMH");
        Collection elements = handler.retrieveSourceElements(element, context);
        elements.retainAll(sources);
        return !elements.isEmpty();
    }

    private boolean isEmptyPackage(EObject element, IContext context) {
        if (element == null) {
            return false;
        }
        if (element instanceof InterfacePkg) {
            InterfacePkg pkg = (InterfacePkg)element;
            if (!pkg.getOwnedConstraints().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedExchangeItems().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedInterfacePkgs().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedInterfaces().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedPropertyValueGroups().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedPropertyValues().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedPropertyValuePkgs().isEmpty()) {
                return false;
            }
            return pkg.getOwnedEnumerationPropertyTypes().isEmpty();
        }
        if (element instanceof DataPkg) {
            DataPkg pkg = (DataPkg)element;
            if (!pkg.getOwnedConstraints().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedExchangeItems().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedAssociations().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedClasses().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedCollections().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedDataPkgs().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedDataTypes().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedDataValues().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedExceptions().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedExchangeItems().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedKeyParts().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedMessageReferences().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedMessages().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedPropertyValueGroups().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedPropertyValuePkgs().isEmpty()) {
                return false;
            }
            if (!pkg.getOwnedPropertyValues().isEmpty()) {
                return false;
            }
            return pkg.getOwnedEnumerationPropertyTypes().isEmpty();
        }
        return false;
    }
}

