/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.platform.sirius.ui.commands.AbstractFixCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;

public class ExchangeItemAllocationOnPortsCommand
extends AbstractFixCommand {
    private final Mode mode;

    public String getName() {
        return Messages.PropagateEIOnPorts;
    }

    public ExchangeItemAllocationOnPortsCommand(Collection<ModelElement> selection) {
        this(selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public ExchangeItemAllocationOnPortsCommand(Collection<ModelElement> selection, IProgressMonitor progressMonitor) {
        this(selection, progressMonitor, Mode.SYNCHRONIZE);
    }

    public ExchangeItemAllocationOnPortsCommand(Collection<ModelElement> selection, IProgressMonitor progressMonitor, Mode mode) {
        super(selection, progressMonitor);
        this.mode = mode;
    }

    @Override
    protected Collection<ModelElement> retrieveModelElements(ModelElement modelElement) {
        if (modelElement instanceof BlockArchitecture) {
            EList result = FunctionalExt.getAllFunctionalExchanges((BlockArchitecture)((BlockArchitecture)modelElement));
            return result;
        }
        if (modelElement instanceof FunctionalExchange) {
            return Collections.singleton(modelElement);
        }
        if (modelElement instanceof FunctionPort) {
            return Collections.singleton(modelElement);
        }
        if (modelElement instanceof AbstractFunction) {
            Collection result = FunctionExt.getAllOwnedFunctionalExchanges((AbstractFunction)((AbstractFunction)modelElement));
            return result;
        }
        return Collections.singleton(modelElement);
    }

    @Override
    protected void process(ModelElement element) {
        if (element instanceof FunctionInputPort) {
            FunctionInputPort fp = (FunctionInputPort)element;
            this.processPort(fp, this.getLinkedItems((ActivityNode)fp));
        } else if (element instanceof FunctionOutputPort) {
            FunctionOutputPort fp = (FunctionOutputPort)element;
            this.processPort(fp, this.getLinkedItems((ActivityNode)fp));
        } else if (element instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)element;
            EList flows = ((FunctionalExchange)element).getExchangedItems();
            if (fe.getSource() != null && fe.getSource() instanceof FunctionOutputPort) {
                this.processPort((FunctionOutputPort)fe.getSource(), (Collection<ExchangeItem>)flows);
            }
            if (fe.getTarget() != null && fe.getTarget() instanceof FunctionInputPort) {
                this.processPort((FunctionInputPort)fe.getTarget(), (Collection<ExchangeItem>)flows);
            }
        }
    }

    private Collection<ExchangeItem> getLinkedItems(ActivityNode fp) {
        ArrayList<ExchangeItem> items = new ArrayList<ExchangeItem>();
        for (ActivityEdge edge : fp.getIncoming()) {
            if (!(edge instanceof FunctionalExchange)) continue;
            items.addAll((Collection<ExchangeItem>)((FunctionalExchange)edge).getExchangedItems());
        }
        for (ActivityEdge edge : fp.getOutgoing()) {
            if (!(edge instanceof FunctionalExchange)) continue;
            items.addAll((Collection<ExchangeItem>)((FunctionalExchange)edge).getExchangedItems());
        }
        return items;
    }

    private void processPort(FunctionOutputPort source, Collection<ExchangeItem> flows) {
        for (ExchangeItem ei : flows) {
            if (source.getOutgoingExchangeItems().contains((Object)ei)) continue;
            source.getOutgoingExchangeItems().add((Object)ei);
        }
        if (this.mode == Mode.SYNCHRONIZE) {
            ArrayList lst = new ArrayList(source.getOutgoingExchangeItems());
            for (ExchangeItem ei : lst) {
                if (flows.contains(ei)) continue;
                source.getOutgoingExchangeItems().remove((Object)ei);
            }
        }
    }

    private void processPort(FunctionInputPort source, Collection<ExchangeItem> flows) {
        for (ExchangeItem ei : flows) {
            if (source.getIncomingExchangeItems().contains((Object)ei)) continue;
            source.getIncomingExchangeItems().add((Object)ei);
        }
        if (this.mode == Mode.SYNCHRONIZE) {
            ArrayList lst = new ArrayList(source.getIncomingExchangeItems());
            for (ExchangeItem ei : lst) {
                if (flows.contains(ei)) continue;
                source.getIncomingExchangeItems().remove((Object)ei);
            }
        }
    }

    public static enum Mode {
        PROPAGATE,
        SYNCHRONIZE;

    }
}

