/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.interaction.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamespaceHelper;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioRealization;
import org.polarsys.capella.core.data.interaction.TimeLapse;

public class ScenarioHelper {
    private static ScenarioHelper instance;

    private ScenarioHelper() {
    }

    public static ScenarioHelper getInstance() {
        if (instance == null) {
            instance = new ScenarioHelper();
        }
        return instance;
    }

    public Object doSwitch(Scenario element, EStructuralFeature feature) {
        List<Scenario> ret = null;
        if (feature.equals(InteractionPackage.Literals.SCENARIO__CONTAINED_FUNCTIONS)) {
            ret = this.getContainedFunctions(element);
        } else if (feature.equals(InteractionPackage.Literals.SCENARIO__CONTAINED_PARTS)) {
            ret = this.getContainedParts(element);
        } else if (feature.equals(InteractionPackage.Literals.SCENARIO__REFERENCED_SCENARIOS)) {
            ret = this.getReferencedScenarios(element);
        } else if (feature.equals(InteractionPackage.Literals.SCENARIO__REALIZED_SCENARIOS)) {
            ret = this.getRealizedScenarios(element);
        } else if (feature.equals(InteractionPackage.Literals.SCENARIO__REALIZING_SCENARIOS)) {
            ret = this.getRealizingScenarios(element);
        }
        if (ret == null) {
            ret = NamespaceHelper.getInstance().doSwitch((Namespace)element, feature);
        }
        return ret;
    }

    protected List<AbstractFunction> getContainedFunctions(Scenario element) {
        ArrayList<AbstractFunction> res = new ArrayList<AbstractFunction>();
        for (InstanceRole instanceRole : element.getOwnedInstanceRoles()) {
            AbstractInstance inst = instanceRole.getRepresentedInstance();
            if (!(inst instanceof AbstractFunction)) continue;
            res.add((AbstractFunction)inst);
        }
        return res;
    }

    protected List<Part> getContainedParts(Scenario element) {
        ArrayList<Part> res = new ArrayList<Part>();
        for (InstanceRole instanceRole : element.getOwnedInstanceRoles()) {
            AbstractInstance inst = instanceRole.getRepresentedInstance();
            if (!(inst instanceof Part)) continue;
            res.add((Part)inst);
        }
        return res;
    }

    protected List<Scenario> getReferencedScenarios(Scenario element) {
        ArrayList<Scenario> res = new ArrayList<Scenario>();
        for (TimeLapse timeLapse : element.getOwnedTimeLapses()) {
            Scenario sc;
            if (!(timeLapse instanceof InteractionUse) || (sc = ((InteractionUse)timeLapse).getReferencedScenario()) == null) continue;
            res.add(sc);
        }
        return res;
    }

    protected List<Scenario> getRealizedScenarios(Scenario element) {
        ArrayList<Scenario> res = new ArrayList<Scenario>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            Scenario sc;
            if (!(trace instanceof ScenarioRealization) || (sc = ((ScenarioRealization)trace).getRealizedScenario()) == null) continue;
            res.add(sc);
        }
        return res;
    }

    protected List<Scenario> getRealizingScenarios(Scenario element) {
        ArrayList<Scenario> res = new ArrayList<Scenario>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            Scenario sc;
            if (!(trace instanceof ScenarioRealization) || (sc = ((ScenarioRealization)trace).getRealizingScenario()) == null) continue;
            res.add(sc);
        }
        return res;
    }
}

