/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.oa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.helpers.interaction.delegates.AbstractCapabilityHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityOperationalCapabilityInvolvement;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalCapability;

public class OperationalCapabilityHelper {
    private static OperationalCapabilityHelper instance;

    private OperationalCapabilityHelper() {
    }

    public static OperationalCapabilityHelper getInstance() {
        if (instance == null) {
            instance = new OperationalCapabilityHelper();
        }
        return instance;
    }

    public Object doSwitch(OperationalCapability element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(OaPackage.Literals.OPERATIONAL_CAPABILITY__REALIZING_CAPABILITIES)) {
            ret = this.getRealizingCapabilities(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_CAPABILITY__INVOLVED_ENTITIES)) {
            ret = this.getInvolvedEntities(element);
        }
        if (ret == null) {
            ret = AbstractCapabilityHelper.getInstance().doSwitch((AbstractCapability)element, feature);
        }
        return ret;
    }

    protected List<Capability> getRealizingCapabilities(OperationalCapability element) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizingCapability()) instanceof Capability)) continue;
            ret.add((Capability)capability);
        }
        return ret;
    }

    protected List<Entity> getInvolvedEntities(OperationalCapability element) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Involvement trace : element.getInvolvedInvolvements()) {
            Entity entity;
            if (!(trace instanceof EntityOperationalCapabilityInvolvement) || (entity = ((EntityOperationalCapabilityInvolvement)trace).getEntity()) == null) continue;
            ret.add(entity);
        }
        return ret;
    }
}

