/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.links.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.refmap.CapellaRefMap;
import org.polarsys.capella.core.model.helpers.refmap.KPair;
import org.polarsys.capella.core.model.helpers.refmap.VPair;

public class CapellaLinksMap {
    private static CapellaLinksMap __instance;
    private Map<KPair, VPair> mapping = null;

    private CapellaLinksMap() {
    }

    public static CapellaLinksMap getInstance() {
        if (__instance == null) {
            __instance = new CapellaLinksMap();
        }
        return __instance;
    }

    public Map<KPair, VPair> getMappings() {
        if (this.mapping == null) {
            this.mapping = new HashMap<KPair, VPair>();
            this.mapping.putAll(CapellaRefMap.getInstance().getMappings());
            this.addMapping(EpbsPackage.Literals.CONFIGURATION_ITEM, PaPackage.Literals.PHYSICAL_COMPONENT, EpbsPackage.Literals.PHYSICAL_ARTIFACT_REALIZATION, EpbsPackage.Literals.CONFIGURATION_ITEM__OWNED_PHYSICAL_ARTIFACT_REALIZATIONS);
            this.addMapping(EpbsPackage.Literals.CONFIGURATION_ITEM, CsPackage.Literals.PHYSICAL_LINK, EpbsPackage.Literals.PHYSICAL_ARTIFACT_REALIZATION, EpbsPackage.Literals.CONFIGURATION_ITEM__OWNED_PHYSICAL_ARTIFACT_REALIZATIONS);
            this.addMapping(EpbsPackage.Literals.CONFIGURATION_ITEM, CsPackage.Literals.PHYSICAL_PORT, EpbsPackage.Literals.PHYSICAL_ARTIFACT_REALIZATION, EpbsPackage.Literals.CONFIGURATION_ITEM__OWNED_PHYSICAL_ARTIFACT_REALIZATIONS);
            this.addMapping(OaPackage.Literals.ENTITY, OaPackage.Literals.OPERATIONAL_ACTIVITY, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
            this.addMapping(CtxPackage.Literals.ACTOR, CtxPackage.Literals.SYSTEM_FUNCTION, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
            this.addMapping(CtxPackage.Literals.SYSTEM, CtxPackage.Literals.SYSTEM_FUNCTION, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
            this.addMapping(LaPackage.Literals.LOGICAL_ACTOR, LaPackage.Literals.LOGICAL_FUNCTION, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
            this.addMapping(LaPackage.Literals.LOGICAL_COMPONENT, LaPackage.Literals.LOGICAL_FUNCTION, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
            this.addMapping(PaPackage.Literals.PHYSICAL_ACTOR, PaPackage.Literals.PHYSICAL_FUNCTION, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
            this.addMapping(PaPackage.Literals.PHYSICAL_COMPONENT, PaPackage.Literals.PHYSICAL_FUNCTION, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
            this.addMapping(PaPackage.Literals.PHYSICAL_NODE, PaPackage.Literals.PHYSICAL_FUNCTION, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
            this.addMapping(CsPackage.Literals.INTERFACE, InformationPackage.Literals.EXCHANGE_ITEM, CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION, CsPackage.Literals.INTERFACE__OWNED_EXCHANGE_ITEM_ALLOCATIONS);
            this.addMapping(FaPackage.Literals.COMPONENT_EXCHANGE_CATEGORY, FaPackage.Literals.COMPONENT_EXCHANGE, null, FaPackage.Literals.COMPONENT_EXCHANGE_CATEGORY__EXCHANGES);
            this.addMapping(CsPackage.Literals.INTERFACE, CsPackage.Literals.INTERFACE, CapellacorePackage.Literals.GENERALIZATION, CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__OWNED_GENERALIZATIONS);
            this.addMapping(InformationPackage.Literals.CLASS, InformationPackage.Literals.CLASS, CapellacorePackage.Literals.GENERALIZATION, CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__OWNED_GENERALIZATIONS);
            this.addMapping(InformationPackage.Literals.CLASS, InformationPackage.Literals.CLASS, InformationPackage.Literals.ASSOCIATION, null);
            this.addMapping(InformationPackage.Literals.CLASS, InformationPackage.Literals.UNION, InformationPackage.Literals.ASSOCIATION, null);
            this.addMapping(InformationPackage.Literals.UNION, InformationPackage.Literals.CLASS, InformationPackage.Literals.ASSOCIATION, null);
            this.addMapping(InformationPackage.Literals.UNION, InformationPackage.Literals.UNION, InformationPackage.Literals.ASSOCIATION, null);
            this.addMapping(InformationPackage.Literals.CLASS, InformationPackage.Literals.COLLECTION, InformationPackage.Literals.ASSOCIATION, null);
            this.addMapping(InformationPackage.Literals.UNION, InformationPackage.Literals.COLLECTION, InformationPackage.Literals.ASSOCIATION, null);
            this.addMapping(CsPackage.Literals.PHYSICAL_LINK, FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_ALLOCATION, FaPackage.Literals.COMPONENT_EXCHANGE_ALLOCATOR__OWNED_COMPONENT_EXCHANGE_ALLOCATIONS);
            this.addMapping(FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATION, FaPackage.Literals.COMPONENT_EXCHANGE__OWNED_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATIONS);
            this.addMapping(FaPackage.Literals.FUNCTION_INPUT_PORT, InformationPackage.Literals.EXCHANGE_ITEM, null, FaPackage.Literals.FUNCTION_INPUT_PORT__INCOMING_EXCHANGE_ITEMS);
            this.addMapping(FaPackage.Literals.FUNCTION_OUTPUT_PORT, InformationPackage.Literals.EXCHANGE_ITEM, null, FaPackage.Literals.FUNCTION_OUTPUT_PORT__OUTGOING_EXCHANGE_ITEMS);
            this.addMapping(FaPackage.Literals.FUNCTIONAL_EXCHANGE, InformationPackage.Literals.EXCHANGE_ITEM, null, FaPackage.Literals.FUNCTIONAL_EXCHANGE__EXCHANGED_ITEMS);
            this.addMapping(FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_ALLOCATION, FaPackage.Literals.COMPONENT_EXCHANGE__OWNED_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATIONS);
            this.addMapping(FaPackage.Literals.COMPONENT_EXCHANGE, InformationPackage.Literals.EXCHANGE_ITEM, null, ModellingcorePackage.Literals.ABSTRACT_INFORMATION_FLOW__CONVOYED_INFORMATIONS);
            this.addMapping(CsPackage.Literals.PHYSICAL_LINK, FaPackage.Literals.COMPONENT_EXCHANGE, null, CsPackage.Literals.PHYSICAL_LINK__OWNED_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATIONS);
            this.addMapping(FaPackage.Literals.EXCHANGE_CATEGORY, FaPackage.Literals.FUNCTIONAL_EXCHANGE, null, FaPackage.Literals.EXCHANGE_CATEGORY__EXCHANGES);
            this.addMapping(CsPackage.Literals.PHYSICAL_LINK_CATEGORY, CsPackage.Literals.PHYSICAL_LINK, null, CsPackage.Literals.PHYSICAL_LINK_CATEGORY__LINKS);
            this.addMapping(FaPackage.Literals.COMPONENT_EXCHANGE_CATEGORY, FaPackage.Literals.COMPONENT_EXCHANGE, null, FaPackage.Literals.COMPONENT_EXCHANGE_CATEGORY__EXCHANGES);
            this.addMapping(OaPackage.Literals.OPERATIONAL_ACTIVITY, CapellacommonPackage.Literals.MODE, null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
            this.addMapping(LaPackage.Literals.LOGICAL_FUNCTION, CapellacommonPackage.Literals.MODE, null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
            this.addMapping(PaPackage.Literals.PHYSICAL_FUNCTION, CapellacommonPackage.Literals.MODE, null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
            this.addMapping(CtxPackage.Literals.SYSTEM_FUNCTION, CapellacommonPackage.Literals.MODE, null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
            this.addMapping(OaPackage.Literals.OPERATIONAL_ACTIVITY, CapellacommonPackage.Literals.STATE, null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
            this.addMapping(LaPackage.Literals.LOGICAL_FUNCTION, CapellacommonPackage.Literals.STATE, null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
            this.addMapping(PaPackage.Literals.PHYSICAL_FUNCTION, CapellacommonPackage.Literals.STATE, null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
            this.addMapping(CtxPackage.Literals.SYSTEM_FUNCTION, CapellacommonPackage.Literals.STATE, null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
            this.addMapping(CtxPackage.Literals.CAPABILITY, CapellacommonPackage.Literals.MODE, null, InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES);
            this.addMapping(LaPackage.Literals.CAPABILITY_REALIZATION, CapellacommonPackage.Literals.MODE, null, InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES);
            this.addMapping(OaPackage.Literals.OPERATIONAL_CAPABILITY, CapellacommonPackage.Literals.MODE, null, InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES);
            this.addMapping(CtxPackage.Literals.CAPABILITY, CapellacommonPackage.Literals.STATE, null, InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES);
            this.addMapping(LaPackage.Literals.CAPABILITY_REALIZATION, CapellacommonPackage.Literals.STATE, null, InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES);
            this.addMapping(OaPackage.Literals.OPERATIONAL_CAPABILITY, CapellacommonPackage.Literals.STATE, null, InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES);
        }
        return this.mapping;
    }

    public List<VPair> findMappingsForSourceType(EClass sourceType) {
        ArrayList<VPair> availableMappings = new ArrayList<VPair>();
        for (Map.Entry<KPair, VPair> entry : this.getMappings().entrySet()) {
            if (entry.getKey().getFirstValue() != sourceType) continue;
            availableMappings.add(entry.getValue());
        }
        return availableMappings;
    }

    public List<VPair> findMappingsForTargetType(EClass targetType) {
        ArrayList<VPair> availableMappings = new ArrayList<VPair>();
        for (Map.Entry<KPair, VPair> entry : this.getMappings().entrySet()) {
            if (entry.getKey().getSecondValue() != targetType) continue;
            availableMappings.add(entry.getValue());
        }
        return availableMappings;
    }

    public VPair getMappingFor(EClass sourceType, EClass targetType) {
        KPair key = new KPair(sourceType, targetType);
        return this.getMappings().get(key);
    }

    public void addMapping(EClass linkSrcType, EClass linkTgtType, EClass linkType, EReference linkRefInSource) {
        KPair key = new KPair(linkSrcType, linkTgtType);
        VPair value = this.getMappings().get(key);
        if (value == null) {
            this.getMappings().put(key, new VPair(new EClass[]{linkType}, new EReference[]{linkRefInSource}));
        } else {
            EClass[] newLinkTypesArray = CapellaLinksMap.createNewArray((EClass[])value.getFirstValue(), linkType);
            EReference[] newLinkRefInSourceArray = CapellaLinksMap.createNewArray((EReference[])value.getSecondValue(), linkRefInSource);
            this.getMappings().put(key, new VPair(newLinkTypesArray, newLinkRefInSourceArray));
        }
    }

    public static <E> E[] createNewArray(E[] baseArray, E elementToAdd) {
        E[] newArray = Arrays.copyOf(baseArray, baseArray.length + 1);
        newArray[baseArray.length] = elementToAdd;
        return newArray;
    }
}

