/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.ActorCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.cs.SystemComponentCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;

public class CapabilityRealizationExt {
    public static void addInvolvedComponent(CapabilityRealization capability, Component component) {
        if (component instanceof AbstractActor) {
            CapabilityRealizationExt.addInvolvedActor(capability, (AbstractActor)component);
        } else if (component instanceof SystemComponent) {
            CapabilityRealizationExt.addInvolvedSystemComponent(capability, (SystemComponent)component);
        }
    }

    public static void addInvolvedActor(CapabilityRealization capabilityRealization, AbstractActor actor) {
        if (capabilityRealization != null && actor != null && !CapabilityRealizationExt.getInvolvedActors(capabilityRealization).contains(actor)) {
            ActorCapabilityRealizationInvolvement involvementLnk = CsFactory.eINSTANCE.createActorCapabilityRealizationInvolvement();
            capabilityRealization.getOwnedActorCapabilityRealizations().add((Object)involvementLnk);
            involvementLnk.setInvolved((InvolvedElement)actor);
        }
    }

    public static void addInvolvedSystemComponent(CapabilityRealization capabilityRealization, SystemComponent systemComponent) {
        if (capabilityRealization != null && systemComponent != null && !CapabilityRealizationExt.getInvolvedSystemComponents(capabilityRealization).contains(systemComponent)) {
            SystemComponentCapabilityRealizationInvolvement involvementLnk = CsFactory.eINSTANCE.createSystemComponentCapabilityRealizationInvolvement();
            capabilityRealization.getOwnedSystemComponentCapabilityRealizations().add((Object)involvementLnk);
            involvementLnk.setInvolved((InvolvedElement)systemComponent);
        }
    }

    public static void removeInvolvedComponent(CapabilityRealization capability, Component component) {
        if (component instanceof AbstractActor) {
            CapabilityRealizationExt.removeInvolvedActor(capability, (AbstractActor)component);
        } else if (component instanceof SystemComponent) {
            CapabilityRealizationExt.removeInvolvedSystemComponent(capability, (SystemComponent)component);
        }
    }

    public static void removeInvolvedActor(CapabilityRealization capability, AbstractActor actor) {
        ActorCapabilityRealizationInvolvement actorCapabilityInvolvement = null;
        for (ActorCapabilityRealizationInvolvement involvement : capability.getInvolvedActors()) {
            if (!involvement.getInvolved().equals(actor)) continue;
            actorCapabilityInvolvement = involvement;
        }
        if (actorCapabilityInvolvement != null) {
            actorCapabilityInvolvement.destroy();
        }
    }

    public static void removeInvolvedSystemComponent(CapabilityRealization capability, SystemComponent systemComponent) {
        SystemComponentCapabilityRealizationInvolvement systemComponentCapabilityInvolvement = null;
        for (SystemComponentCapabilityRealizationInvolvement involvement : capability.getInvolvedSystemComponents()) {
            if (!involvement.getInvolved().equals(systemComponent)) continue;
            systemComponentCapabilityInvolvement = involvement;
        }
        if (systemComponentCapabilityInvolvement != null) {
            systemComponentCapabilityInvolvement.destroy();
        }
    }

    public static List<LogicalComponent> getInvolvedLogicalComponents(CapabilityRealization capability) {
        ArrayList<LogicalComponent> contributingComponents = new ArrayList<LogicalComponent>();
        List<SystemComponent> cpntSet = CapabilityRealizationExt.getInvolvedSystemComponents(capability);
        for (SystemComponent cpnt : cpntSet) {
            if (!(cpnt instanceof LogicalComponent)) continue;
            contributingComponents.add((LogicalComponent)cpnt);
        }
        return contributingComponents;
    }

    public static List<PhysicalComponent> getInvolvedPhysicalComponents(CapabilityRealization capability) {
        ArrayList<PhysicalComponent> contributingComponents = new ArrayList<PhysicalComponent>();
        List<SystemComponent> cpntSet = CapabilityRealizationExt.getInvolvedSystemComponents(capability);
        for (SystemComponent cpnt : cpntSet) {
            if (!(cpnt instanceof PhysicalComponent)) continue;
            contributingComponents.add((PhysicalComponent)cpnt);
        }
        return contributingComponents;
    }

    public static List<ConfigurationItem> getInvolvedConfigurationItems(CapabilityRealization capability) {
        ArrayList<ConfigurationItem> contributingComponents = new ArrayList<ConfigurationItem>();
        List<SystemComponent> cpntSet = CapabilityRealizationExt.getInvolvedSystemComponents(capability);
        for (SystemComponent cpnt : cpntSet) {
            if (!(cpnt instanceof ConfigurationItem)) continue;
            contributingComponents.add((ConfigurationItem)cpnt);
        }
        return contributingComponents;
    }

    public static List<SystemComponent> getInvolvedSystemComponents(CapabilityRealization capability) {
        ArrayList<SystemComponent> contributingComponents = new ArrayList<SystemComponent>();
        EList contributionSet = capability.getInvolvedSystemComponents();
        for (SystemComponentCapabilityRealizationInvolvement contrib : contributionSet) {
            contributingComponents.add((SystemComponent)contrib.getInvolved());
        }
        return contributingComponents;
    }

    public static List<AbstractActor> getInvolvedActors(CapabilityRealization capability) {
        ArrayList<AbstractActor> contributingComponents = new ArrayList<AbstractActor>();
        EList contributionSet = capability.getInvolvedActors();
        for (ActorCapabilityRealizationInvolvement contrib : contributionSet) {
            InvolvedElement elt = contrib.getInvolved();
            if (!(elt instanceof AbstractActor)) continue;
            contributingComponents.add((AbstractActor)contrib.getInvolved());
        }
        return contributingComponents;
    }

    public static List<Component> getInvolvedComponents(CapabilityRealization capability) {
        ArrayList<Component> involvedComponents = new ArrayList<Component>();
        involvedComponents.addAll(CapabilityRealizationExt.getInvolvedActors(capability));
        involvedComponents.addAll(CapabilityRealizationExt.getInvolvedSystemComponents(capability));
        return involvedComponents;
    }

    public static List<CapabilityRealization> getParentsCapabilityRealizationLinked(CapabilityRealization srcCapa) {
        ArrayList<CapabilityRealization> upperCapaList = new ArrayList<CapabilityRealization>();
        for (CapellaElement upperCapa : RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)srcCapa, InteractionPackage.Literals.ABSTRACT_CAPABILITY)) {
            if (!(upperCapa instanceof CapabilityRealization)) continue;
            upperCapaList.add((CapabilityRealization)upperCapa);
            upperCapaList.addAll(CapabilityRealizationExt.getParentsCapabilityRealizationLinked((CapabilityRealization)upperCapa));
        }
        return upperCapaList;
    }

    public static List<LogicalComponent> retrieveLcInvolvedByUpperCapabilityRealization(AbstractCapability currentCapa) {
        ArrayList<LogicalComponent> involvedLcByUpperCapa = new ArrayList<LogicalComponent>();
        if (currentCapa != null) {
            for (CapabilityRealization upperCapa : CapabilityRealizationExt.getParentsCapabilityRealizationLinked((CapabilityRealization)currentCapa)) {
                for (LogicalComponent currentLc : CapabilityRealizationExt.getInvolvedLogicalComponents(upperCapa)) {
                    if (involvedLcByUpperCapa.contains(currentLc)) continue;
                    involvedLcByUpperCapa.add(currentLc);
                }
            }
        }
        return involvedLcByUpperCapa;
    }

    public static List<PhysicalComponent> retrievePcInvolvedByUpperCapabilityRealization(AbstractCapability currentCapa) {
        ArrayList<PhysicalComponent> involvedPcByUpperCapa = new ArrayList<PhysicalComponent>();
        if (currentCapa != null) {
            for (CapabilityRealization upperCapa : CapabilityRealizationExt.getParentsCapabilityRealizationLinked((CapabilityRealization)currentCapa)) {
                for (PhysicalComponent currentPc : CapabilityRealizationExt.getInvolvedPhysicalComponents(upperCapa)) {
                    if (involvedPcByUpperCapa.contains(currentPc)) continue;
                    involvedPcByUpperCapa.add(currentPc);
                }
            }
        }
        return involvedPcByUpperCapa;
    }

    public static boolean isComponentTargetAvailableForCapInvolvement(EObject context, EObject preSource, EObject preTarget) {
        if (preSource == null || preTarget == null) {
            return false;
        }
        if (preSource instanceof Capability) {
            Capability cap = (Capability)preSource;
            EList ownedActInvol = cap.getOwnedActorCapabilityInvolvements();
            if (!ownedActInvol.isEmpty() && ownedActInvol.contains((Object)preTarget)) {
                return false;
            }
        } else if (preSource instanceof Mission) {
            Mission mis = (Mission)preSource;
            EList ownedActInvol = mis.getOwnedActorMissionInvolvements();
            if (!ownedActInvol.isEmpty() && ownedActInvol.contains((Object)preTarget)) {
                return false;
            }
        } else if (preSource instanceof CapabilityRealization) {
            CapabilityRealization capReal = (CapabilityRealization)preSource;
            EList capRealization = capReal.getOwnedSystemComponentCapabilityRealizations();
            for (SystemComponentCapabilityRealizationInvolvement element : capRealization) {
                InvolvedElement involved = element.getInvolved();
                if (involved == null || !involved.equals(preTarget)) continue;
                return false;
            }
        }
        return true;
    }

    public static List<CapabilityRealization> getAllCapabilityRealizationOfOneLayer(CapellaElement currentElement) {
        ArrayList<CapabilityRealization> capabilityRealizationsList = new ArrayList<CapabilityRealization>();
        if (currentElement == null) {
            return capabilityRealizationsList;
        }
        BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)currentElement);
        if (arch != null) {
            Set capabilityRealizationsSet = EObjectExt.getAll((EObject)arch, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
            for (EObject obj : capabilityRealizationsSet) {
                capabilityRealizationsList.add((CapabilityRealization)obj);
            }
        }
        return capabilityRealizationsList;
    }
}

