/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.SimpleOrientedGraph;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.common.utils.graph.CycleDetectionUtils;
import org.polarsys.capella.common.utils.graph.IDirectedGraph;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalChainContainer;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.FunctionalChainAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.Messages;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class FunctionalChainExt {
    static String PLUGIN_ID = "org.polarsys.capella.core.model.helpers";

    public static boolean isFirstFunctionalChainInvolvement(FunctionalChainInvolvement involment) {
        return involment.getInvolved() != null && involment.getPreviousFunctionalChainInvolvements().isEmpty();
    }

    public static boolean isLastFunctionalChainInvolvement(FunctionalChainInvolvement involment) {
        return involment.getInvolved() != null && involment.getNextFunctionalChainInvolvements().isEmpty();
    }

    public static Collection<AbstractExchangeItem> getInvalidExchangeItems(FunctionalChainInvolvement involvement) {
        EList exchangedItemsFromInvolvement = involvement.getExchangedItems();
        if (involvement.getInvolved() != null && involvement.getInvolved() instanceof FunctionalExchange) {
            EList exchangeItemsFromInvokedOperation = ((FunctionalExchange)involvement.getInvolved()).getExchangedItems();
            ArrayList<AbstractExchangeItem> invalidExchangeItems = new ArrayList<AbstractExchangeItem>((Collection<AbstractExchangeItem>)exchangedItemsFromInvolvement);
            invalidExchangeItems.removeAll((Collection<?>)exchangeItemsFromInvokedOperation);
            return invalidExchangeItems;
        }
        return Collections.emptyList();
    }

    public static Set<AbstractFunction> getFunctionalChainFirstFunctions(FunctionalChain functionalChain) {
        HashSet<AbstractFunction> result = new HashSet<AbstractFunction>();
        for (FunctionalChainInvolvement inv : functionalChain.getOwnedFunctionalChainInvolvements()) {
            if (!FunctionalChainExt.isFirstFunctionalChainInvolvement(inv) || !(inv.getInvolved() instanceof AbstractFunction)) continue;
            result.add((AbstractFunction)inv.getInvolved());
        }
        return result;
    }

    public static Collection<FunctionalChainInvolvement> getFlatFirstFunctionalChainInvolvments(FunctionalChain functionalChain) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        LinkedList<FunctionalChain> toVisit = new LinkedList<FunctionalChain>();
        HashSet<FunctionalChain> visited = new HashSet<FunctionalChain>();
        toVisit.add(functionalChain);
        while (!toVisit.isEmpty()) {
            FunctionalChain chain = (FunctionalChain)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (FunctionalChainInvolvement involvement : chain.getInvolvedFunctionalChainInvolvements()) {
                if (!FunctionalChainExt.isFirstFunctionalChainInvolvement(involvement)) continue;
                if (involvement.getInvolved() instanceof FunctionalChain) {
                    toVisit.add((FunctionalChain)involvement.getInvolved());
                    continue;
                }
                result.add(involvement);
            }
        }
        return result;
    }

    public static Set<AbstractFunction> getFlatFunctionalChainFirstFunctions(FunctionalChain chain) {
        HashSet<AbstractFunction> result = new HashSet<AbstractFunction>();
        for (FunctionalChainInvolvement inv : FunctionalChainExt.getFlatFirstFunctionalChainInvolvments(chain)) {
            if (!(inv.getInvolved() instanceof AbstractFunction)) continue;
            result.add((AbstractFunction)inv.getInvolved());
        }
        return result;
    }

    public static Set<AbstractFunction> getFunctionalChainLastFunctions(FunctionalChain functionalChain) {
        HashSet<AbstractFunction> result = new HashSet<AbstractFunction>();
        for (FunctionalChainInvolvement inv : functionalChain.getOwnedFunctionalChainInvolvements()) {
            if (!FunctionalChainExt.isLastFunctionalChainInvolvement(inv) || !(inv.getInvolved() instanceof AbstractFunction)) continue;
            result.add((AbstractFunction)inv.getInvolved());
        }
        return result;
    }

    public static Collection<FunctionalChainInvolvement> getFlatLastFunctionalChainInvolvments(FunctionalChain functionalChain1) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        LinkedList<FunctionalChain> toVisit = new LinkedList<FunctionalChain>();
        HashSet<FunctionalChain> visited = new HashSet<FunctionalChain>();
        toVisit.add(functionalChain1);
        while (!toVisit.isEmpty()) {
            FunctionalChain chain = (FunctionalChain)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (FunctionalChainInvolvement involvement : chain.getInvolvedFunctionalChainInvolvements()) {
                if (!FunctionalChainExt.isLastFunctionalChainInvolvement(involvement)) continue;
                if (involvement.getInvolved() instanceof FunctionalChain) {
                    toVisit.add((FunctionalChain)involvement.getInvolved());
                    continue;
                }
                result.add(involvement);
            }
        }
        return result;
    }

    public static Set<AbstractFunction> getFlatFunctionalChainLastFunctions(FunctionalChain chain) {
        HashSet<AbstractFunction> result = new HashSet<AbstractFunction>();
        for (FunctionalChainInvolvement inv : FunctionalChainExt.getFlatLastFunctionalChainInvolvments(chain)) {
            if (!(inv.getInvolved() instanceof AbstractFunction)) continue;
            result.add((AbstractFunction)inv.getInvolved());
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getPreviousExchangeInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        LinkedList<FunctionalChainInvolvement> toVisit = new LinkedList<FunctionalChainInvolvement>();
        HashSet<FunctionalChainInvolvement> visited = new HashSet<FunctionalChainInvolvement>();
        toVisit.add(involvement);
        while (!toVisit.isEmpty()) {
            FunctionalChainInvolvement involvment = (FunctionalChainInvolvement)toVisit.removeFirst();
            if (visited.contains(involvment)) continue;
            visited.add(involvment);
            for (FunctionalChainInvolvement aPreviousInv : involvment.getPreviousFunctionalChainInvolvements()) {
                if (aPreviousInv.getInvolved() == null) continue;
                if (aPreviousInv.getInvolved() instanceof FunctionalExchange) {
                    result.add(aPreviousInv);
                    continue;
                }
                toVisit.add(aPreviousInv);
            }
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getFlatPreviousExchangeInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement aPreviousInv : FunctionalChainExt.getFlatPreviousFunctionalChainInvolvements(involvement)) {
            if (aPreviousInv.getInvolved() == null) continue;
            if (aPreviousInv.getInvolved() instanceof FunctionalExchange) {
                result.add(aPreviousInv);
                continue;
            }
            for (FunctionalChainInvolvement aaanv : FunctionalChainExt.getFlatPreviousFunctionalChainInvolvements(aPreviousInv)) {
                if (!(aaanv.getInvolved() instanceof FunctionalExchange)) continue;
                result.add(aaanv);
            }
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getNextExchangeInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        LinkedList<FunctionalChainInvolvement> toVisit = new LinkedList<FunctionalChainInvolvement>();
        HashSet<FunctionalChainInvolvement> visited = new HashSet<FunctionalChainInvolvement>();
        toVisit.add(involvement);
        while (!toVisit.isEmpty()) {
            FunctionalChainInvolvement involvment = (FunctionalChainInvolvement)toVisit.removeFirst();
            if (visited.contains(involvment)) continue;
            visited.add(involvment);
            for (FunctionalChainInvolvement aPreviousInv : involvment.getNextFunctionalChainInvolvements()) {
                if (aPreviousInv.getInvolved() == null) continue;
                if (aPreviousInv.getInvolved() instanceof FunctionalExchange) {
                    result.add(aPreviousInv);
                    continue;
                }
                toVisit.add(aPreviousInv);
            }
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getFlatNextExchangeInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement aPreviousInv : FunctionalChainExt.getFlatNextFunctionalChainInvolvements(involvement)) {
            if (aPreviousInv.getInvolved() == null) continue;
            if (aPreviousInv.getInvolved() instanceof FunctionalExchange) {
                result.add(aPreviousInv);
                continue;
            }
            for (FunctionalChainInvolvement aaanv : FunctionalChainExt.getFlatNextFunctionalChainInvolvements(aPreviousInv)) {
                if (!(aaanv.getInvolved() instanceof FunctionalExchange)) continue;
                result.add(aaanv);
            }
        }
        return result;
    }

    public static List<FunctionalChainInvolvement> getFirstFunctionalChainInvolvements(FunctionalChain element) {
        ArrayList<FunctionalChainInvolvement> ret = new ArrayList<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement inv : element.getOwnedFunctionalChainInvolvements()) {
            if (!FunctionalChainExt.isFirstFunctionalChainInvolvement(inv)) continue;
            ret.add(inv);
        }
        return ret;
    }

    public static List<FunctionalChainInvolvement> getLastFunctionalChainInvolvements(FunctionalChain element) {
        ArrayList<FunctionalChainInvolvement> ret = new ArrayList<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement inv : element.getOwnedFunctionalChainInvolvements()) {
            if (!FunctionalChainExt.isLastFunctionalChainInvolvement(inv)) continue;
            ret.add(inv);
        }
        return ret;
    }

    public static Set<FunctionalChainInvolvement> getFlatPreviousFunctionalChainInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement in : involvement.getPreviousFunctionalChainInvolvements()) {
            if (in.getInvolved() instanceof FunctionalChain) {
                result.addAll(FunctionalChainExt.getFlatLastFunctionalChainInvolvments((FunctionalChain)in.getInvolved()));
                continue;
            }
            result.add(in);
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getFlatNextFunctionalChainInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement in : involvement.getNextFunctionalChainInvolvements()) {
            if (in.getInvolved() instanceof FunctionalChain) {
                result.addAll(FunctionalChainExt.getFlatFirstFunctionalChainInvolvments((FunctionalChain)in.getInvolved()));
                continue;
            }
            result.add(in);
        }
        return result;
    }

    public static boolean isFunctionalChainValid(FunctionalChain fc) {
        if (!FunctionalChainExt.isFunctionalChainWellFormed(fc)) {
            return false;
        }
        EList sources = fc.getFirstFunctionalChainInvolvements();
        if (sources.isEmpty()) {
            return false;
        }
        boolean cycleFound = FunctionalChainExt.containsACycle(fc);
        return !cycleFound;
    }

    public static boolean isFunctionalChainWellFormed(FunctionalChain fc) {
        SimpleOrientedGraph graph = new SimpleOrientedGraph();
        if (fc.getOwnedFunctionalChainInvolvements().isEmpty()) {
            return false;
        }
        for (FunctionalChainInvolvement inv : FunctionalChainExt.getFlatInvolvements(fc)) {
            if (!FunctionalChainExt.isFunctionalChainInvolvementValid(inv)) {
                return false;
            }
            if (!(inv.getInvolved() instanceof FunctionalExchange)) continue;
            FunctionalExchange currentExchange = (FunctionalExchange)inv.getInvolved();
            graph.addNode((Object)FunctionExt.getIncomingAbstractFunction((FunctionalExchange)currentExchange), (Object)FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)currentExchange));
        }
        if (graph.isEmpty()) {
            return false;
        }
        return graph.isAConnectedGraph();
    }

    public static Collection<FunctionalExchange> getFlatIncomingExchanges(FunctionalChainInvolvement element) {
        HashSet<AbstractFunction> targetFunctions = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> targetExchanges = new HashSet<FunctionalExchange>();
        InvolvedElement involvedElement = element.getInvolved();
        if (involvedElement instanceof FunctionalExchange) {
            targetExchanges.add((FunctionalExchange)involvedElement);
        } else if (involvedElement instanceof AbstractFunction) {
            targetFunctions.add((AbstractFunction)involvedElement);
        } else if (involvedElement instanceof FunctionalChain) {
            targetFunctions.addAll(FunctionalChainExt.getFlatFunctionalChainFirstFunctions((FunctionalChain)involvedElement));
        }
        for (AbstractFunction function : targetFunctions) {
            targetExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)function));
        }
        return targetExchanges;
    }

    public static Collection<FunctionalExchange> getFlatOutgoingExchanges(FunctionalChainInvolvement element) {
        HashSet<AbstractFunction> sourceFunctions = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> sourceExchanges = new HashSet<FunctionalExchange>();
        InvolvedElement involvedElement = element.getInvolved();
        if (involvedElement instanceof FunctionalExchange) {
            sourceExchanges.add((FunctionalExchange)involvedElement);
        } else if (involvedElement instanceof AbstractFunction) {
            sourceFunctions.add((AbstractFunction)involvedElement);
        } else if (involvedElement instanceof FunctionalChain) {
            sourceFunctions.addAll(FunctionalChainExt.getFlatFunctionalChainLastFunctions((FunctionalChain)involvedElement));
        }
        for (AbstractFunction function : sourceFunctions) {
            sourceExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)function));
        }
        return sourceExchanges;
    }

    public static Collection<FunctionalExchange> getFlatCommonFunctionalExchanges(FunctionalChainInvolvement source, FunctionalChainInvolvement target) {
        Collection<FunctionalExchange> sourceExchanges = FunctionalChainExt.getFlatOutgoingExchanges(source);
        Collection<FunctionalExchange> targetExchanges = FunctionalChainExt.getFlatIncomingExchanges(target);
        sourceExchanges.retainAll(targetExchanges);
        return sourceExchanges;
    }

    public static Collection<FunctionalExchange> getFlatIncomingExchanges(FunctionalChain element) {
        HashSet<AbstractFunction> targetFunctions = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> targetExchanges = new HashSet<FunctionalExchange>();
        targetFunctions.addAll(FunctionalChainExt.getFlatFunctionalChainFirstFunctions(element));
        for (AbstractFunction function : targetFunctions) {
            targetExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)function));
        }
        return targetExchanges;
    }

    public static IStatus isFunctionalChainInvolvementValidWithStatus(FunctionalChainInvolvement inv) {
        IStatus status = Status.OK_STATUS;
        boolean isOperational = CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)inv);
        String functionalChain = isOperational ? Messages.FunctionalChainExt_OperationalProcess : Messages.FunctionalChainExt_FunctionalChain;
        String function = isOperational ? Messages.FunctionalChainExt_OperationalActivity : Messages.FunctionalChainExt_Function;
        String exchange = isOperational ? Messages.FunctionalChainExt_Interaction : Messages.FunctionalChainExt_FunctionalExchange;
        String aFunction = String.valueOf(isOperational ? Messages.FunctionalChainExt_an : Messages.FunctionalChainExt_a) + function;
        String aExchange = String.valueOf(isOperational ? Messages.FunctionalChainExt_an : Messages.FunctionalChainExt_a) + exchange;
        String aFunctionalChain = String.valueOf(isOperational ? Messages.FunctionalChainExt_an : Messages.FunctionalChainExt_a) + functionalChain;
        if (inv.getInvolved() == null) {
            return new Status(4, PLUGIN_ID, Messages.Involvement_InvolvedNull);
        }
        if (inv.getInvolver() == null) {
            return new Status(4, PLUGIN_ID, Messages.FunctionalChainExt_InvolverNull);
        }
        if (!inv.eContainer().equals(inv.getInvolver())) {
            return new Status(4, PLUGIN_ID, Messages.FunctionalChainExt_InvolverNotContainer);
        }
        if (inv instanceof FunctionalChainReference) {
            if (!(inv.getInvolved() instanceof FunctionalChain)) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementNot, (Object)aFunctionalChain));
            }
        } else if (!(inv.getInvolved() instanceof AbstractFunction) && !(inv.getInvolved() instanceof FunctionalExchange)) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementNotAndNot, (Object)aFunction, (Object)aExchange));
        }
        if (inv.getInvolved() instanceof FunctionalExchange) {
            if (inv.getNextFunctionalChainInvolvements().size() > 1) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementWithMultipleNext, (Object)aExchange));
            }
            if (inv.getPreviousFunctionalChainInvolvements().size() > 1) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementWithMultiplePrevious, (Object)aExchange));
            }
        }
        if (inv.getInvolved() instanceof AbstractFunction && inv.getNextFunctionalChainInvolvements().isEmpty() && inv.getPreviousFunctionalChainInvolvements().isEmpty()) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvementAlone, (Object)aFunction));
        }
        for (FunctionalChainInvolvement aNext : inv.getNextFunctionalChainInvolvements()) {
            if (inv.getInvolved() instanceof AbstractFunction) {
                if (aNext.getInvolved() == null || !(aNext.getInvolved() instanceof FunctionalExchange)) {
                    return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsButNextIsNotA, (Object)aFunction, (Object)aExchange));
                }
                AbstractFunction currentFunction = (AbstractFunction)inv.getInvolved();
                if (currentFunction.equals(FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)aNext.getInvolved())))) continue;
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToSourceNext, (Object)aFunction, (Object)exchange));
            }
            if (inv.getInvolved() instanceof FunctionalExchange) {
                if (aNext.getInvolved() == null || !(aNext.getInvolved() instanceof AbstractFunction) && !(aNext.getInvolved() instanceof FunctionalChain)) {
                    return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_NextIsNotOrNot, (Object[])new Object[]{aExchange, aFunction, aFunctionalChain}));
                }
                if (!FunctionalChainExt.getFlatCommonFunctionalExchanges(inv, aNext).isEmpty()) continue;
                if (aNext.getInvolved() instanceof FunctionalChain) {
                    return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToTargetNextFunctionalChain, (Object[])new Object[]{aExchange, function, functionalChain}));
                }
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToTargetNext, (Object[])new Object[]{aExchange, function, function}));
            }
            if (!(inv.getInvolved() instanceof FunctionalChain) || !FunctionalChainExt.getFlatCommonFunctionalExchanges(inv, aNext).isEmpty()) continue;
            if (aNext.getInvolved() instanceof FunctionalChain) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToTargetNextFunctionalChain, (Object[])new Object[]{aFunctionalChain, function, functionalChain}));
            }
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToOutgoingNext, (Object[])new Object[]{aFunctionalChain, exchange, exchange}));
        }
        return status;
    }

    public static boolean isFunctionalChainInvolvementValid(FunctionalChainInvolvement inv) {
        return FunctionalChainExt.isFunctionalChainInvolvementValidWithStatus(inv).isOK();
    }

    public static boolean containsACycle(FunctionalChainInvolvement involvement) {
        if (involvement.getInvolved() instanceof FunctionalChain) {
            FunctionalChain fc = (FunctionalChain)involvement.getInvolved();
            return FunctionalChainExt.containsACycle(fc);
        }
        return false;
    }

    public static boolean containsACycle(FunctionalChain functionalChain) {
        boolean cycleFound;
        FunctionalChainDirectedGraph graph = FunctionalChainExt.getFunctionalChainDirectedGraph(functionalChain);
        return graph != null && (cycleFound = CycleDetectionUtils.containsCycles((IDirectedGraph)graph));
    }

    public static FunctionalChain createFunctionalChain(AbstractFunctionalChainContainer container, Collection<EObject> involvedElements) {
        TransactionalEditingDomain editingDomain;
        StrictCompoundCommand command;
        Object newFC = BlockArchitectureExt.getRootBlockArchitecture((EObject)container) instanceof OperationalAnalysis ? OaFactory.eINSTANCE.createOperationalProcess() : FaFactory.eINSTANCE.createFunctionalChain();
        container.getOwnedFunctionalChains().add(newFC);
        if (container instanceof AbstractCapability) {
            FunctionalChainExt.createFunctionalChainAbstractCapabilityInvolvement((AbstractCapability)container, (FunctionalChain)newFC);
        }
        if ((command = CreationHelper.getAdditionnalCommand((EditingDomain)(editingDomain = TransactionHelper.getEditingDomain((EObject)newFC)), (ModelElement)newFC)).canExecute()) {
            command.execute();
        }
        HashMap<FunctionalExchange, FunctionalChainInvolvement> involvedExchanges = new HashMap<FunctionalExchange, FunctionalChainInvolvement>();
        HashMap<AbstractFunction, FunctionalChainInvolvement> involvedFunctions = new HashMap<AbstractFunction, FunctionalChainInvolvement>();
        for (EObject eObject : involvedElements) {
            if ((!(eObject instanceof AbstractFunction) || involvedFunctions.containsKey(eObject)) && (!(eObject instanceof FunctionalExchange) || involvedExchanges.containsKey(eObject))) continue;
            FunctionalChainInvolvement newInv = FunctionalChainExt.createInvolvement((FunctionalChain)newFC, (InvolvedElement)eObject);
            if (eObject instanceof FunctionalExchange) {
                AbstractFunction sourceFunction;
                involvedExchanges.put((FunctionalExchange)eObject, newInv);
                AbstractFunction targetFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)((FunctionalExchange)eObject));
                if (!involvedFunctions.containsKey(targetFunction)) {
                    FunctionalChainInvolvement newInvFunction = FunctionalChainExt.createInvolvement((FunctionalChain)newFC, (InvolvedElement)targetFunction);
                    involvedFunctions.put(targetFunction, newInvFunction);
                }
                if (!involvedFunctions.containsKey(sourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)eObject)))) {
                    FunctionalChainInvolvement newInvFunction = FunctionalChainExt.createInvolvement((FunctionalChain)newFC, (InvolvedElement)sourceFunction);
                    involvedFunctions.put(sourceFunction, newInvFunction);
                }
            }
            if (!(eObject instanceof AbstractFunction)) continue;
            involvedFunctions.put((AbstractFunction)eObject, newInv);
        }
        for (Map.Entry entry : involvedExchanges.entrySet()) {
            AbstractFunction sourceFunction;
            AbstractFunction targetFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)((FunctionalExchange)entry.getKey()));
            if (involvedFunctions.containsKey(targetFunction)) {
                ((FunctionalChainInvolvement)entry.getValue()).getNextFunctionalChainInvolvements().add((Object)((FunctionalChainInvolvement)involvedFunctions.get(targetFunction)));
            }
            if (!involvedFunctions.containsKey(sourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)entry.getKey())))) continue;
            ((FunctionalChainInvolvement)involvedFunctions.get(sourceFunction)).getNextFunctionalChainInvolvements().add((Object)((FunctionalChainInvolvement)entry.getValue()));
        }
        return newFC;
    }

    public static FunctionalChainAbstractCapabilityInvolvement createFunctionalChainAbstractCapabilityInvolvement(AbstractCapability capability, FunctionalChain target) {
        for (FunctionalChainAbstractCapabilityInvolvement inv : capability.getOwnedFunctionalChainAbstractCapabilityInvolvements()) {
            if (!inv.getInvolved().equals(target)) continue;
            return inv;
        }
        FunctionalChainAbstractCapabilityInvolvement newInv = InteractionFactory.eINSTANCE.createFunctionalChainAbstractCapabilityInvolvement();
        newInv.setInvolved((InvolvedElement)target);
        capability.getOwnedFunctionalChainAbstractCapabilityInvolvements().add((Object)newInv);
        return newInv;
    }

    public static FunctionalChainInvolvement createInvolvement(FunctionalChain fc, InvolvedElement involved) {
        FunctionalChainInvolvement newInv = FaFactory.eINSTANCE.createFunctionalChainInvolvement();
        fc.getOwnedFunctionalChainInvolvements().add((Object)newInv);
        newInv.setInvolved(involved);
        return newInv;
    }

    public static List<FunctionalChain> getAllFunctionalChains(BlockArchitecture architecture) {
        BasicEList functionalChains = new BasicEList();
        AbstractCapabilityPkg pkg = architecture.getOwnedAbstractCapabilityPkg();
        if (pkg != null) {
            for (AbstractCapability aCapability : AbstractCapabilityPkgExt.getAllAbstractCapabilities(pkg)) {
                functionalChains.addAll((Collection)aCapability.getOwnedFunctionalChains());
            }
        }
        for (AbstractFunction abstractFunction : FunctionExt.getAllAbstractFunctions((BlockArchitecture)architecture)) {
            functionalChains.addAll((Collection)abstractFunction.getOwnedFunctionalChains());
        }
        return functionalChains;
    }

    public static Set<FunctionalChainInvolvement> getInvolvementsOf(FunctionalChain fc, InvolvedElement involved) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement anInvolvement : fc.getOwnedFunctionalChainInvolvements()) {
            if (!involved.equals(anInvolvement.getInvolved())) continue;
            result.add(anInvolvement);
        }
        return result;
    }

    public static Collection<FunctionalChainInvolvement> getFlatInvolvements(FunctionalChain functionalChain1) {
        ArrayList<FunctionalChainInvolvement> involvments = new ArrayList<FunctionalChainInvolvement>();
        LinkedList<FunctionalChain> toVisit = new LinkedList<FunctionalChain>();
        HashSet<FunctionalChain> visited = new HashSet<FunctionalChain>();
        toVisit.add(functionalChain1);
        while (!toVisit.isEmpty()) {
            FunctionalChain chain = (FunctionalChain)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (FunctionalChainInvolvement involvement : chain.getInvolvedFunctionalChainInvolvements()) {
                if (involvement.getInvolved() != null && involvement.getInvolved() instanceof FunctionalChain) {
                    toVisit.add((FunctionalChain)involvement.getInvolved());
                }
                involvments.add(involvement);
            }
        }
        return involvments;
    }

    public static Set<FunctionalChainInvolvement> getInvolvementsOf(FunctionalChain fc, EClass involvedClass) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement anInvolvement : fc.getOwnedFunctionalChainInvolvements()) {
            if (anInvolvement.getInvolved() == null || !involvedClass.isInstance((Object)anInvolvement.getInvolved())) continue;
            result.add(anInvolvement);
        }
        return result;
    }

    public static Set<FunctionalExchange> getFunctionalExchanges(FunctionalChain fc) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getInvolvementsOf(fc, FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
            if (involvement.getInvolved() == null) continue;
            result.add((FunctionalExchange)involvement.getInvolved());
        }
        return result;
    }

    public static Set<FunctionalExchange> getFlatFunctionalExchanges(FunctionalChain fc) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvementsOf(fc, FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
            if (involvement.getInvolved() == null) continue;
            result.add((FunctionalExchange)involvement.getInvolved());
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getFlatInvolvementsOf(FunctionalChain fc, EClass involvedClass) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvements(fc)) {
            if (involvement.getInvolved() == null || !involvedClass.isInstance((Object)involvement.getInvolved())) continue;
            result.add(involvement);
        }
        return result;
    }

    public static Set<EObject> getFlatInvolvedElements(FunctionalChain fc, EClass involvedClass) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvements(fc)) {
            if (involvement.getInvolved() == null || !involvedClass.isInstance((Object)involvement.getInvolved())) continue;
            result.add((EObject)involvement.getInvolved());
        }
        return result;
    }

    public static FunctionalChainDirectedGraph getFunctionalChainDirectedGraph(FunctionalChain functionalChain) {
        FunctionalChainExt functionalChainExt = new FunctionalChainExt();
        functionalChainExt.getClass();
        return functionalChainExt.new FunctionalChainDirectedGraph(functionalChain);
    }

    public class FunctionalChainDirectedGraph
    implements IDirectedGraph<Object> {
        FunctionalChain chain;

        public FunctionalChainDirectedGraph(FunctionalChain functionalChain) {
            this.chain = functionalChain;
        }

        public Iterator<Object> getSucessors(Object source) {
            FunctionalChainInvolvement involvement;
            EList sucessors;
            if (source instanceof FunctionalChainInvolvement && (sucessors = (involvement = (FunctionalChainInvolvement)source).getNextFunctionalChainInvolvements()) != null) {
                return sucessors.iterator();
            }
            return new ArrayList().iterator();
        }

        public Iterator<Object> getNodes() {
            EList functionalChainInvolvements = this.chain.getInvolvedFunctionalChainInvolvements();
            if (functionalChainInvolvements != null) {
                return functionalChainInvolvements.iterator();
            }
            return new ArrayList().iterator();
        }
    }
}

