/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentPkgExt;

public class LogicalArchitectureExt {
    public static List<LogicalArchitecture> getAllLogicalArchitectures(LogicalArchitecture logArch) {
        ArrayList<LogicalArchitecture> list = new ArrayList<LogicalArchitecture>();
        if (logArch != null) {
            list.addAll(LogicalComponentExt.getAllLogicalArchitectures(logArch.getOwnedLogicalComponent()));
        }
        return list;
    }

    public static List<LogicalComponent> getAllLCsFromLogicalArchitectureLayer(LogicalArchitecture logArch) {
        ArrayList<LogicalComponent> list = new ArrayList<LogicalComponent>();
        if (logArch != null) {
            LogicalComponent ownedLogicalComponent = logArch.getOwnedLogicalComponent();
            if (ownedLogicalComponent != null) {
                list.add(ownedLogicalComponent);
            }
            list.addAll(LogicalArchitectureExt.getAllLCsFromLC(ownedLogicalComponent));
            list.addAll(LogicalComponentPkgExt.getAllLCsFromLCPkg(logArch.getOwnedLogicalComponentPkg()));
        }
        return list;
    }

    public static List<LogicalComponent> getAllLCsFromLC(LogicalComponent lc) {
        ArrayList<LogicalComponent> list = new ArrayList<LogicalComponent>();
        list.addAll(LogicalArchitectureExt.getAllLCsFromLC(lc, list));
        return list;
    }

    public static List<LogicalComponent> getAllLCsFromLC(LogicalComponent subLC, List<LogicalComponent> lcs) {
        ArrayList<LogicalComponent> list = new ArrayList<LogicalComponent>();
        if (subLC != null) {
            if (subLC.getSubLogicalComponents().size() == 0 && subLC.getOwnedLogicalArchitectures().size() == 0) {
                list.add(subLC);
            }
            for (LogicalComponentPkg lcPkg : subLC.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllLCsFromLCPkg(lcPkg));
            }
            for (LogicalArchitecture logArch : subLC.getOwnedLogicalArchitectures()) {
                list.addAll(LogicalArchitectureExt.getAllLCsFromLogicalArchitectureLayer(logArch));
            }
            for (LogicalComponent sub : subLC.getSubLogicalComponents()) {
                if (lcs.contains(sub) && lcs.contains(subLC)) continue;
                list.add(sub);
                list.add(subLC);
                list.addAll(LogicalArchitectureExt.getAllLCsFromLC(sub, list));
            }
        }
        return list;
    }

    public static List<LogicalComponent> getAllLCFromLC(LogicalComponent lc) {
        ArrayList<LogicalComponent> list = new ArrayList<LogicalComponent>();
        if (lc != null) {
            if (lc.getSubLogicalComponents().size() == 0 && lc.getOwnedLogicalArchitectures().size() == 0) {
                list.add(lc);
            }
            for (LogicalComponentPkg lcPkg : lc.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllLCsFromLCPkg(lcPkg));
            }
            for (LogicalArchitecture logArch : lc.getOwnedLogicalArchitectures()) {
                list.addAll(LogicalArchitectureExt.getAllLCsFromLogicalArchitectureLayer(logArch));
            }
            for (LogicalComponent subLC : lc.getSubLogicalComponents()) {
                list.add(subLC);
                list.addAll(LogicalArchitectureExt.getAllLCsFromLC(subLC));
            }
        }
        return list;
    }

    public static List<CapellaElement> getAllInterfacesInLogicalArchitecture(LogicalArchitecture logArch) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (logArch != null) {
            list.addAll(InterfacePkgExt.getAllInterfaces(logArch.getOwnedInterfacePkg()));
            list.addAll(LogicalComponentExt.getAllInterfacesInLogicalComponent(logArch.getOwnedLogicalComponent()));
            list.addAll(LogicalComponentPkgExt.getAllInterfacesInLogicalComponentPkg(logArch.getOwnedLogicalComponentPkg()));
        }
        return list;
    }

    public static List<CapellaElement> getAllInterfacesInLogicalArchitecture(LogicalArchitecture logicalArchitecture, LogicalComponent currentLC, boolean usedFlag) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (logicalArchitecture != null) {
            list.addAll(InterfacePkgExt.getAllInterfacesFiltered(logicalArchitecture.getOwnedInterfacePkg(), (Component)currentLC, usedFlag));
            list.addAll(LogicalComponentExt.getInterfacesFromSameLevelLogicalComponent(logicalArchitecture.getOwnedLogicalComponent(), currentLC, usedFlag));
            list.addAll(LogicalComponentPkgExt.getAllInterfacesInLogicalComponentPkg(logicalArchitecture.getOwnedLogicalComponentPkg(), currentLC, usedFlag));
        }
        return list;
    }

    public static List<LogicalComponent> getAllLogicalComponents(LogicalArchitecture currentElement) {
        Set pcSet = EObjectExt.getAll((EObject)currentElement, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        ArrayList<LogicalComponent> lcList = new ArrayList<LogicalComponent>();
        for (EObject obj : pcSet) {
            lcList.add((LogicalComponent)obj);
        }
        return lcList;
    }

    public static List<LogicalComponent> getSameLevelComponents(LogicalArchitecture currentElement) {
        ArrayList<LogicalComponent> list = new ArrayList<LogicalComponent>(1);
        if (currentElement != null) {
            list.add(currentElement.getOwnedLogicalComponent());
            for (LogicalComponent alc : LogicalComponentPkgExt.getAllLCsFromLCPkg(currentElement.getOwnedLogicalComponentPkg())) {
                list.add(alc);
            }
        }
        return list;
    }

    public static List<LogicalComponent> getAllLogicalComponents(LogicalComponentPkg currentElement) {
        Set pcSet = EObjectExt.getAll((EObject)currentElement, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        ArrayList<LogicalComponent> lcList = new ArrayList<LogicalComponent>();
        for (EObject obj : pcSet) {
            lcList.add((LogicalComponent)obj);
        }
        return lcList;
    }

    public static List<AbstractFunction> getAllFunctions(BlockArchitecture arch) {
        FunctionPkg functionPkg;
        List<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (arch != null && (functionPkg = arch.getOwnedFunctionPkg()) != null && functionPkg instanceof LogicalFunctionPkg) {
            list = LogicalArchitectureExt.getAllFunctionsFromFunctionPkg((LogicalFunctionPkg)functionPkg);
        }
        return list;
    }

    public static List<AbstractFunction> getAllAbstractFunctions(BlockArchitecture arch) {
        FunctionPkg functionPkg;
        List<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (arch != null && (functionPkg = arch.getOwnedFunctionPkg()) != null && functionPkg instanceof LogicalFunctionPkg) {
            list = LogicalArchitectureExt.getAllAbstractFunctionsFromFunctionPkg((LogicalFunctionPkg)functionPkg);
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromFunctionPkg(LogicalFunctionPkg sysFunPkg) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (sysFunPkg != null) {
            EList ownedFunctions = sysFunPkg.getOwnedLogicalFunctions();
            list.addAll((Collection<AbstractFunction>)ownedFunctions);
            for (AbstractFunction function : ownedFunctions) {
                list.addAll(LogicalArchitectureExt.getAllFunctionsFromFunction(function));
            }
            for (LogicalFunctionPkg ownedFunctionPkg : sysFunPkg.getOwnedLogicalFunctionPkgs()) {
                list.addAll(LogicalArchitectureExt.getAllFunctionsFromFunctionPkg(ownedFunctionPkg));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllAbstractFunctionsFromFunctionPkg(LogicalFunctionPkg sysFunPkg) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (sysFunPkg != null) {
            EList ownedFunctions = sysFunPkg.getOwnedLogicalFunctions();
            list.addAll((Collection<AbstractFunction>)ownedFunctions);
            for (AbstractFunction function : ownedFunctions) {
                list.addAll(LogicalArchitectureExt.getAllAbstractFunctionsFromFunction(function));
            }
            for (LogicalFunctionPkg ownedFunctionPkg : sysFunPkg.getOwnedLogicalFunctionPkgs()) {
                list.addAll(LogicalArchitectureExt.getAllAbstractFunctionsFromFunctionPkg(ownedFunctionPkg));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromFunction(AbstractFunction fun) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (fun != null) {
            EList ownedSystemFunctions = fun.getOwnedFunctions();
            for (AbstractFunction abstractFunction : ownedSystemFunctions) {
                list.add(abstractFunction);
            }
            for (AbstractFunction function : ownedSystemFunctions) {
                list.addAll(LogicalArchitectureExt.getAllFunctionsFromFunction(function));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllAbstractFunctionsFromFunction(AbstractFunction fun) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (fun != null) {
            EList ownedSystemFunctions = fun.getOwnedFunctions();
            for (AbstractFunction abstractFunction : ownedSystemFunctions) {
                list.add(abstractFunction);
            }
            for (AbstractFunction function : ownedSystemFunctions) {
                list.addAll(LogicalArchitectureExt.getAllAbstractFunctionsFromFunction(function));
            }
        }
        return list;
    }
}

