/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalActorPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;

public class PhysicalActorPkgExt {
    public static PhysicalActorPkg getRootPhysicalActorPkg(PhysicalActorPkg lcPkg) {
        PhysicalActorPkg rootPkg = null;
        if (lcPkg != null) {
            EObject container = lcPkg.eContainer();
            if (container instanceof PhysicalArchitecture) {
                return lcPkg;
            }
            if (container instanceof PhysicalActorPkg) {
                rootPkg = PhysicalActorPkgExt.getRootPhysicalActorPkg((PhysicalActorPkg)container);
            }
        }
        return rootPkg;
    }

    public static List<PhysicalActor> getAllPAsFromPAPkg(PhysicalActorPkg lcPkg) {
        ArrayList<PhysicalActor> list = new ArrayList<PhysicalActor>();
        if (lcPkg != null) {
            list.addAll((Collection<PhysicalActor>)lcPkg.getOwnedPhysicalActors());
            for (PhysicalActorPkg subLCPkg : lcPkg.getOwnedPhysicalActorPkgs()) {
                list.addAll(PhysicalActorPkgExt.getAllPAsFromPAPkg(subLCPkg));
            }
        }
        return list;
    }

    public static List<CapellaElement> getAllInterfacesFromPhysicalActorPkg(PhysicalActorPkg lcPkg) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        List<PhysicalActor> actors = PhysicalActorPkgExt.getAllPAsFromPAPkg(lcPkg);
        for (PhysicalActor actor : actors) {
            list.addAll(InterfacePkgExt.getAllInterfaces(actor.getOwnedInterfacePkg()));
        }
        return list;
    }
}

