/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.DependencyChecker;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.InterModelCycle;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.InterModelInconsistency;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.LinkHelper;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.TarjanAlgorithm;

public class InterModelInconsistencyDetector {
    protected HashMap<Integer, EObject> ident2Object = new HashMap();
    protected HashMap<EObject, Integer> object2Ident = new HashMap();
    protected List<InterModelInconsistency> errors = new ArrayList<InterModelInconsistency>();
    protected int identifierCounter = 0;
    protected DependencyChecker linkChecker;

    public List<InterModelInconsistency> getInterModelInconsistencies(SystemEngineering systemEngineering) {
        this.linkChecker = new DependencyChecker((SemanticEditingDomainFactory.SemanticEditingDomain)TransactionHelper.getEditingDomain((EObject)systemEngineering));
        TreeIterator treeIterator = systemEngineering.eAllContents();
        HashSet<EObject> allObjects = new HashSet<EObject>();
        while (treeIterator.hasNext()) {
            allObjects.add((EObject)treeIterator.next());
        }
        HashMap<Integer, HashSet<Integer>> g = new HashMap<Integer, HashSet<Integer>>();
        HashSet<EObject> objectsToTreat = allObjects;
        while ((objectsToTreat = this.treatObjects(objectsToTreat, allObjects, g)).size() > 0) {
            allObjects.addAll(objectsToTreat);
        }
        HashSet[] graph = new HashSet[this.identifierCounter];
        int i = 0;
        while (i < this.identifierCounter) {
            HashSet<Integer> x = g.get(i);
            if (x == null) {
                x = new HashSet();
            }
            graph[i] = x;
            ++i;
        }
        TarjanAlgorithm t = new TarjanAlgorithm();
        List<List<Integer>> scComponents = t.getSCComponents(graph);
        ArrayList cfcs = new ArrayList();
        for (List<Integer> list : scComponents) {
            if (list.size() <= 1) continue;
            ArrayList<EObject> cfc = new ArrayList<EObject>();
            for (Integer n : list) {
                cfc.add(this.ident2Object.get(n));
            }
            cfcs.add(cfc);
        }
        for (List<Integer> list : cfcs) {
            HashSet<Resource> res = new HashSet<Resource>();
            for (EObject eObject : list) {
                Resource objRes = CapellaResourceHelper.getMainModelResource((EObject)eObject);
                if (objRes == null) continue;
                res.add(objRes);
            }
            if (res.size() <= 1) continue;
            this.errors.add(new InterModelCycle(list));
        }
        this.errors.addAll(this.linkChecker.getDependencyViolations());
        return this.errors;
    }

    protected Integer getObjectIdentifier(EObject object) {
        Integer res = this.object2Ident.get(object);
        if (res == null) {
            res = this.identifierCounter;
            ++this.identifierCounter;
            this.object2Ident.put(object, res);
            this.ident2Object.put(res, object);
        }
        return res;
    }

    protected HashSet<EObject> treatObjects(HashSet<EObject> objects, HashSet<EObject> allObjects, HashMap<Integer, HashSet<Integer>> g) {
        HashSet<EObject> newObjects = new HashSet<EObject>();
        for (EObject currentNode : objects) {
            HashSet<Integer> targetedNodeIdent = new HashSet<Integer>();
            g.put(this.getObjectIdentifier(currentNode), targetedNodeIdent);
            HashSet<EObject> targetedObjects = LinkHelper.getTargetedObjects(currentNode);
            for (EObject targetedObject : targetedObjects) {
                if (!allObjects.contains(targetedObject)) {
                    newObjects.add(targetedObject);
                }
                targetedNodeIdent.add(this.getObjectIdentifier(targetedObject));
                this.linkChecker.checkLink(currentNode, targetedObject, null);
            }
        }
        return newObjects;
    }
}

