/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnionKind implements Enumerator
{
    UNION(0, "UNION", "UNION"),
    VARIANT(1, "VARIANT", "VARIANT");

    public static final int UNION_VALUE = 0;
    public static final int VARIANT_VALUE = 1;
    private static final UnionKind[] VALUES_ARRAY;
    public static final List<UnionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnionKind[]{UNION, VARIANT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnionKind get(int value) {
        switch (value) {
            case 0: {
                return UNION;
            }
            case 1: {
                return VARIANT;
            }
        }
        return null;
    }

    private UnionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

