/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.ui.commands;

import java.util.Collection;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.transition.system.topdown.commands.TransitionCommandHelper;
import org.polarsys.capella.core.transition.system.topdown.ui.commands.IntramodelTransitionCommand;

public class TransitionUICommandHelper
extends TransitionCommandHelper {
    public static TransitionUICommandHelper getInstance() {
        return new TransitionUICommandHelper();
    }

    public void executeCommand(String id, Collection<Object> list) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(id);
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        EvaluationContext context = new EvaluationContext(null, list);
        try {
            handlerService.executeCommandInContext(parameterizedCommand, null, (IEvaluationContext)context);
        }
        catch (ExecutionException executionException) {
        }
        catch (NotDefinedException notDefinedException) {
        }
        catch (NotEnabledException notEnabledException) {
        }
        catch (NotHandledException notHandledException) {
            // empty catch block
        }
    }

    public ICommand getActorTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.actor";
            }
        };
    }

    public ICommand getDataTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.data";
            }
        };
    }

    public ICommand getExchangeItemTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.exchangeitem";
            }
        };
    }

    public ICommand getFunctionalTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.functional";
            }
        };
    }

    public ICommand getOCtoSMTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oc2mission";
            }
        };
    }

    public ICommand getOAtoSCTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oa2capability";
            }
        };
    }

    public ICommand getOAtoSMTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oa2mission";
            }
        };
    }

    public ICommand getInterfaceTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.interface";
            }
        };
    }

    public ICommand getLC2PCTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.lc2pc";
            }
        };
    }

    public ICommand getStateMachineTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.statemachine";
            }
        };
    }

    public ICommand getCapabilityTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.capability";
            }
        };
    }

    public ICommand getOE2SystemTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oe2system";
            }
        };
    }

    public ICommand getOE2ActorTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oe2actor";
            }
        };
    }

    public ICommand getPropertyValueTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.propertyvalue";
            }
        };
    }

    public ICommand getSystemTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.system";
            }
        };
    }
}

