/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.handlers.location;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.handlers.location.ILocationHandler;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.common.re.handlers.traceability.LocationTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.options.IPropertyHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.common.rules.IRuleAttachment;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.possibilities.MappingPossibilityResolutionException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingPossibility;

public class DefaultLocationHandler
implements ILocationHandler {
    HashMap<EObject, EObject> currentLocation = new HashMap();
    HashMap<CatalogElementLink, EObject> locations = new HashMap();
    HashMap<CatalogElementLink, EObject> defaultLocations = new HashMap();

    @Override
    public EObject getCurrentLocation(CatalogElementLink link, IContext context) {
        if (this.currentLocation.containsKey(link)) {
            return this.currentLocation.get(link);
        }
        return null;
    }

    private boolean isInvalidResourceLocation(CatalogElementLink link, EObject location, IContext context) {
        CatalogElement targetElement;
        Resource targetResource;
        Resource locationResource;
        CatalogElement sourceElement;
        Resource sourceResource;
        if (location == null) {
            return true;
        }
        CatalogElement elementSource = link.getSource();
        if (elementSource == null) {
            return true;
        }
        boolean isLinkFromSource = ReplicableElementHandlerHelper.getInstance(context).isFromSource(context, link);
        return isLinkFromSource ? (sourceResource = EcoreUtil.getRootContainer((EObject)(sourceElement = ReplicableElementHandlerHelper.getInstance(context).getInitialSource(context))).eResource()) != (locationResource = EcoreUtil.getRootContainer((EObject)location).eResource()) : (targetResource = EcoreUtil.getRootContainer((EObject)(targetElement = ReplicableElementHandlerHelper.getInstance(context).getInitialTarget(context))).eResource()) != (locationResource = EcoreUtil.getRootContainer((EObject)location).eResource());
    }

    @Override
    public void setCurrentLocation(CatalogElementLink link, EObject container, IContext context) {
        this.currentLocation.put((EObject)link, container);
    }

    protected CatalogElementLink getLink(CatalogElement element, EObject target, IContext context) {
        for (CatalogElementLink link : element.getOwnedLinks()) {
            if (target == null || !target.equals(link.getTarget())) continue;
            return link;
        }
        return null;
    }

    protected CatalogElementLink getAllLink(CatalogElement element, EObject target, IContext context) {
        Collection<CatalogElementLink> links = ReplicableElementHandlerHelper.getInstance(context).getAllElementsLinks(element);
        for (CatalogElementLink link : links) {
            if (target == null || !target.equals(link.getTarget())) continue;
            return link;
        }
        return null;
    }

    protected CatalogElementLink getLinkContainer(CatalogElementLink link, IContext context) {
        EObject target = link.getTarget();
        return this.getAllLink(link.getSource(), target.eContainer(), context);
    }

    protected CatalogElementLink getLinkRelatedElement(CatalogElementLink link, IContext context) {
        return null;
    }

    @Override
    public void cleanLocations(IContext context) {
        this.currentLocation.clear();
        this.locations.clear();
        this.defaultLocations.clear();
    }

    @Override
    public EObject getLocation(CatalogElementLink link, CatalogElementLink oppositeLink, IContext context) {
        EObject target = link.getTarget();
        if (target == null) {
            return null;
        }
        if (this.locations.containsKey(link)) {
            return this.locations.get(link);
        }
        CatalogElementLink container = this.getLinkContainer(link, context);
        if (container != null) {
            this.locations.put(link, (EObject)container);
            return container;
        }
        CatalogElementLink relatedElement = this.getLinkRelatedElement(link, context);
        if (relatedElement != null) {
            this.locations.put(link, (EObject)relatedElement);
            return relatedElement;
        }
        if (!(!(target instanceof CatalogElement) && ContextScopeHandlerHelper.getInstance((IContext)context).contains("CREATED_LINKS", (EObject)link, context) || this.isInvalidResourceLocation(link, link.getTarget().eContainer(), context))) {
            this.locations.put(link, link.getTarget().eContainer());
            return link.getTarget().eContainer();
        }
        CatalogElement element = ReplicableElementHandlerHelper.getInstance(context).getInitialTarget(context);
        for (CatalogElementLink linkA : ReplicableElementHandlerHelper.getInstance(context).getAllElementsLinks(element)) {
            if (linkA.getOrigin() == null || linkA.getOrigin().getTarget() == null || link.getTarget() == null || !linkA.getOrigin().getTarget().equals(link.getTarget().eContainer())) continue;
            this.locations.put(link, (EObject)linkA);
            return linkA;
        }
        this.locations.put(link, null);
        return null;
    }

    protected boolean isValidContainement(EObject targetContainer, EObject target) {
        return true;
    }

    protected boolean isInitialSelectionValidContainer(EObject selection, CatalogElementLink link, IContext context) {
        String value;
        return !context.exists((Object)"COMMAND__CURRENT_VALUE") || !"COMMAND__UPDATE_DEFINITION_REPLICA_FROM_REPLICA".equals(value = (String)context.get((Object)"COMMAND__CURRENT_VALUE")) || !link.getSource().equals(ReplicableElementHandlerHelper.getInstance(context).getTarget(context));
    }

    protected Collection<EObject> getRelatedElements(EObject element) {
        return Collections.singleton(element);
    }

    @Override
    public EObject getDefaultLocation(CatalogElementLink link, CatalogElementLink oppositeLink, IContext context) {
        if (link == null || link.getTarget() == null) {
            return null;
        }
        if (this.defaultLocations.containsKey(link)) {
            return this.defaultLocations.get(link);
        }
        IRuleAttachment arule = this.getRule(link.getTarget(), context);
        Iterator<EObject> elementsContainers = this.retrieveDefaultContainers(link, oppositeLink, context);
        while (elementsContainers.hasNext()) {
            EStructuralFeature sourceFeature;
            EObject targetContainer = elementsContainers.next();
            if (this.isInvalidResourceLocation(link, targetContainer, context) || !this.isValidContainement(targetContainer, link.getTarget())) continue;
            EStructuralFeature targetFeature = sourceFeature = link.getTarget().eContainingFeature();
            if (arule != null && ((targetFeature = this.getFeature(arule, link.getTarget(), link.getTarget(), targetContainer, context)) == null || targetFeature == sourceFeature) && link.getOrigin() != null && link.getOrigin().getTarget() != null) {
                targetFeature = this.getFeature(arule, link.getOrigin().getTarget(), link.getTarget(), targetContainer, context);
            }
            if (targetFeature == null || !AttachmentHelper.getInstance((IContext)context).isApplicable(targetContainer.eClass(), targetFeature)) continue;
            this.defaultLocations.put(link, targetContainer);
            return targetContainer;
        }
        EObject defaultContainer = this.retrieveDefaultContainerFromRule(arule, link, oppositeLink, context);
        this.defaultLocations.put(link, defaultContainer);
        return defaultContainer;
    }

    private EObject retrieveDefaultContainerFromRule(IRuleAttachment arule, CatalogElementLink link, CatalogElementLink oppositeLink, IContext context) {
        block4: {
            EObject result;
            block5: {
                block6: {
                    boolean isLinkFromSource = ReplicableElementHandlerHelper.getInstance(context).isFromSource(context, link);
                    if (arule == null) break block4;
                    LocationTraceabilityHandler.update(isLinkFromSource, context);
                    result = arule.retrieveDefaultContainer(oppositeLink.getTarget(), link.getTarget(), context);
                    if (result == null) break block5;
                    if (this.isValidContainement(result, link.getTarget())) break block6;
                    return null;
                }
                if (!this.isInvalidResourceLocation(link, result, context)) break block5;
                return null;
            }
            try {
                return result;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public EStructuralFeature getFeature(EObject source, EObject target, EObject currentLocation, IContext context) {
        if (source == null) {
            return null;
        }
        IRuleAttachment arule = this.getRule(source, context);
        return this.getFeature(arule, source, target, currentLocation, context);
    }

    protected EStructuralFeature getFeature(IRuleAttachment rule, EObject source, EObject target, EObject currentLocation, IContext context) {
        EStructuralFeature targetFeature;
        if (source == null) {
            return null;
        }
        if (rule != null && (targetFeature = rule.retrieveTargetContainementFeature(source, target, currentLocation, context)) != null && AttachmentHelper.getInstance((IContext)context).isApplicable(currentLocation.eClass(), targetFeature)) {
            return targetFeature;
        }
        return source.eContainingFeature();
    }

    protected Iterator<EObject> retrieveDefaultContainers(CatalogElementLink link, CatalogElementLink oppositeLink, IContext context) {
        LinkedHashSet elementsContainers = new LinkedHashSet();
        this.retrieveDefaultContainersForComposite(link, elementsContainers, context);
        String parentLocator = this.getParentLocator(context);
        if (parentLocator == null || "defaultLocator".equals(parentLocator) || "manualLocator".equals(parentLocator)) {
            this.retrieveDefaultContainersFromSelection(link, oppositeLink, elementsContainers, context);
            this.retrieveDefaultContainersFromSiblingLinks(link, elementsContainers, false, context);
        } else if ("packageLocator".equals(parentLocator)) {
            String command = (String)context.get((Object)"COMMAND__CURRENT_VALUE");
            if ("COMMAND__CREATE_A_REPLICA_FROM_REPLICABLE".equals(command)) {
                this.retrieveDefaultSpecificPackageContainer(link, oppositeLink, elementsContainers, context);
                this.retrieveDefaultContainersFromSelection(link, oppositeLink, elementsContainers, context);
                this.retrieveDefaultContainersFromSiblingLinks(link, elementsContainers, true, context);
            }
            if ("COMMAND__UPDATE_A_REPLICA_FROM_REPLICABLE".equals(command)) {
                this.retrieveDefaultContainersFromSiblingLinks(link, elementsContainers, true, context);
                this.retrieveDefaultSpecificPackageContainer(link, oppositeLink, elementsContainers, context);
                this.retrieveDefaultContainersFromSelection(link, oppositeLink, elementsContainers, context);
            }
        }
        this.retrieveDefaultContainersFromLocationSourceProperty(oppositeLink, elementsContainers, context);
        return this.retrieveDefaultContainersIterator(elementsContainers);
    }

    private Iterator<EObject> retrieveDefaultContainersIterator(Collection<?> containersAndSuppliers) {
        final Iterator<?> nested = containersAndSuppliers.iterator();
        Iterator<EObject> result = new Iterator<EObject>(){

            @Override
            public boolean hasNext() {
                return nested.hasNext();
            }

            @Override
            public EObject next() {
                Object next = nested.next();
                if (next instanceof EObject) {
                    return (EObject)next;
                }
                if (next instanceof Supplier) {
                    return (EObject)((Supplier)next).get();
                }
                return null;
            }

            @Override
            public void remove() {
                nested.remove();
            }
        };
        return result;
    }

    private void retrieveDefaultSpecificPackageContainer(CatalogElementLink link, CatalogElementLink oppositeLink, Collection<? super Supplier<EObject>> elementsContainers, IContext context) {
        Supplier<EObject> pkgSupplier = this.getSpecificPackage(link, oppositeLink, context);
        if (pkgSupplier != null) {
            elementsContainers.add(pkgSupplier);
        }
    }

    private String getParentLocator(IContext context) {
        String result = null;
        String scope = (String)context.get((Object)"_OS");
        IPropertyContext propertyContext = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, scope);
        IProperty parentLocatorProperty = propertyContext.getProperties().getProperty("parentLocatorOption");
        if (parentLocatorProperty != null) {
            result = (String)propertyContext.getCurrentValue(parentLocatorProperty);
        }
        return result;
    }

    protected Supplier<EObject> getSpecificPackage(CatalogElementLink link, CatalogElementLink oppositeLink, IContext context) {
        return null;
    }

    private void retrieveDefaultContainersFromLocationSourceProperty(CatalogElementLink link, Collection<? super EObject> elementsContainers, IContext context) {
        String scope = (String)context.get((Object)"_OS");
        IPropertyContext propertyContext = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, scope);
        if (link.getTarget() instanceof CatalogElement) {
            Object value;
            IProperty property;
            CatalogElement targetElement;
            Object value2;
            IProperty property2;
            CatalogElement sourceElement = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
            if (sourceElement != null && sourceElement.equals(link.getSource()) && (property2 = propertyContext.getProperties().getProperty("locationSource")) != null && (value2 = propertyContext.getCurrentValue(property2)) instanceof EObject) {
                elementsContainers.add((EObject)((EObject)propertyContext.getCurrentValue(property2)));
            }
            if ((targetElement = ReplicableElementHandlerHelper.getInstance(context).getTarget(context)) != null && targetElement.equals(link.getSource()) && (property = propertyContext.getProperties().getProperty("locationTarget")) != null && (value = propertyContext.getCurrentValue(property)) instanceof EObject) {
                elementsContainers.add((EObject)((EObject)propertyContext.getCurrentValue(property)));
            }
        }
    }

    private void retrieveDefaultContainersFromSiblingLinks(CatalogElementLink link, Collection<? super EObject> elementsContainers, boolean preferSameType, IContext context) {
        CatalogElement element = ReplicableElementHandlerHelper.getInstance(context).getInitialTarget(context);
        Collection<CatalogElementLink> links = ReplicableElementHandlerHelper.getInstance(context).getElementsLinks(element);
        ArrayList<EObject> siblings = new ArrayList<EObject>();
        for (CatalogElementLink linkA : links) {
            if (linkA == null || linkA.getOrigin() == null || linkA.getOrigin().getTarget() == null || linkA.getOrigin().getTarget().eContainer() == null || link == null || link.getOrigin() == null || link.getOrigin().getTarget() == null || linkA.equals(link) || !linkA.getOrigin().getTarget().eContainer().equals(link.getOrigin().getTarget().eContainer())) continue;
            siblings.add(linkA.getTarget());
        }
        if (preferSameType) {
            Iterator it = siblings.iterator();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (link == null || next.eClass() != link.getTarget().eClass()) continue;
                it.remove();
                elementsContainers.add((EObject)next.eContainer());
            }
        }
        for (EObject e : siblings) {
            elementsContainers.add((EObject)e.eContainer());
        }
    }

    private void retrieveDefaultContainersFromSelection(CatalogElementLink link, CatalogElementLink oppositeLink, Collection<? super EObject> elementsContainers, IContext context) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (selection != null) {
            for (EObject selectedItem : selection) {
                for (EObject item : this.getRelatedElements(selectedItem)) {
                    if (this.isInvalidResourceLocation(link, item, context)) continue;
                    if (item instanceof CatalogElement) {
                        if ("COMMAND__UPDATE_DEFINITION_REPLICA_FROM_REPLICA".equals(context.get((Object)"COMMAND__CURRENT_VALUE"))) {
                            elementsContainers.add((EObject)oppositeLink.getTarget().eContainer());
                            continue;
                        }
                        elementsContainers.add((EObject)link.getOrigin().getTarget().eContainer());
                        continue;
                    }
                    if (!this.isInitialSelectionValidContainer(item, link, context)) continue;
                    elementsContainers.add((EObject)item);
                }
            }
        }
    }

    private void retrieveDefaultContainersForComposite(CatalogElementLink link, Collection<? super EObject> elementsContainers, IContext context) {
        CatalogElement element = ReplicableElementHandlerHelper.getInstance(context).getInitialTarget(context);
        CatalogElement recUsingSource = null;
        CatalogElement recUsingTarget = null;
        block0: for (CatalogElement referencingElement : ReplicableElementHandlerHelper.getInstance(context).getLinkingReplicableElements(context, Collections.singletonList(link.getSource()))) {
            for (CatalogElement referencingElement2 : ReplicableElementHandlerHelper.getInstance(context).getLinkingReplicableElements(context, Collections.singletonList(element.getOrigin()))) {
                if (!referencingElement.getOrigin().equals(referencingElement2)) continue;
                recUsingSource = referencingElement2;
                recUsingTarget = referencingElement;
                continue block0;
            }
        }
        if (recUsingSource != null && recUsingTarget != null) {
            for (CatalogElementLink sLink : ReplicableElementHandlerHelper.getInstance(context).getElementsLinks(recUsingSource)) {
                if (link.getTarget() == null || link.getTarget().eContainer() == null || !link.getTarget().eContainer().equals(sLink.getTarget())) continue;
                for (CatalogElementLink tLink : recUsingTarget.getOwnedLinks()) {
                    if (tLink == null || tLink.getOrigin() == null || !tLink.getOrigin().equals(sLink)) continue;
                    elementsContainers.add((EObject)tLink.getTarget());
                }
            }
        }
    }

    public IRuleAttachment getRule(EObject target, IContext context) {
        IRuleAttachment arule = null;
        IRulesHandler ruleHandler = (IRulesHandler)context.get((Object)"_R_H");
        try {
            IRule rule;
            MappingPossibility mapping;
            if (ruleHandler != null && (mapping = ruleHandler.getApplicablePossibility((Object)target)) != null && (rule = ruleHandler.getApplicablePossibility((Object)target).getCompleteRule()) instanceof IRuleAttachment) {
                arule = (IRuleAttachment)rule;
            }
        }
        catch (MappingPossibilityResolutionException mappingPossibilityResolutionException) {
            // empty catch block
        }
        return arule;
    }

    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context) {
        this.cleanLocations(context);
        return Status.OK_STATUS;
    }
}

