/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.commandline;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.commandline.core.AbstractCommandLine;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.validation.commandline.CapellaValidateComlineAction;
import org.polarsys.capella.core.validation.commandline.Messages;
import org.polarsys.capella.core.validation.commandline.ValidationArgumentHelper;

public class ValidationCommandLine
extends AbstractCommandLine {
    static final String CONSTRAINT_DISABLED_PREFIX = "org.eclipse.emf.validation//con.disabled/";

    public ValidationCommandLine() {
        argHelper = new ValidationArgumentHelper();
    }

    public void printHelp() {
        System.out.println("Capella Validation Command Line Exporter");
        super.printHelp();
    }

    public boolean execute(IApplicationContext context) throws CommandLineException {
        boolean status;
        ValidationCommandLine.startFakeWorkbench();
        String fileURI = String.valueOf(Messages.resource_prefix) + argHelper.getFilePath();
        URI uri = URI.createURI((String)fileURI);
        String outputFolder = argHelper.getOutputFolder();
        try {
            status = this.execute(uri, outputFolder);
        }
        catch (FileNotFoundException exception) {
            this.logError(exception.getMessage());
            throw new CommandLineException(exception.getMessage());
        }
        catch (CoreException exception) {
            this.logError(exception.getMessage());
            throw new CommandLineException(exception.getMessage());
        }
        if (status) {
            this.logInfo("validation report generated to:  " + argHelper.getOutputFolder());
        }
        return false;
    }

    private boolean execute(URI uri, String outputFolder) throws FileNotFoundException, CoreException, CommandLineException {
        String validationContext;
        CapellaValidateComlineAction capellaValidateCLineAction = new CapellaValidateComlineAction();
        Project semanticRootElement = this.loadSemanticRootElement(uri);
        if (semanticRootElement == null) {
            throw new CommandLineException("No semantic model found!");
        }
        Resource semanticRootResource = semanticRootElement.eResource();
        capellaValidateCLineAction.setResource(semanticRootResource);
        String validationRuleSetFile = ((ValidationArgumentHelper)argHelper).getValidationRuleSet();
        if (!this.isEmtyOrNull(validationRuleSetFile)) {
            List<String> ruleSet = ValidationCommandLine.readRules(validationRuleSetFile);
            ValidationCommandLine.ensureEMFValidationActivation();
            for (String ruleId : ruleSet) {
                EMFModelValidationPreferences.setConstraintDisabled((String)ruleId, (boolean)true);
            }
        }
        if (!this.isEmtyOrNull(validationContext = ((ValidationArgumentHelper)argHelper).getValidationContext())) {
            List<String> objectToValidateUris = this.toListOfURIString(validationContext);
            List<EObject> loadedEObjs = this.loadEObjects(semanticRootElement, objectToValidateUris);
            capellaValidateCLineAction.setSelectedObjects(loadedEObjs);
        } else {
            capellaValidateCLineAction.setSelectedObjects((List<EObject>)semanticRootResource.getContents());
        }
        capellaValidateCLineAction.run();
        this.storeResultsToFile(outputFolder);
        return true;
    }

    public static void ensureEMFValidationActivation() {
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }

    private static List<String> readRules(String ruleSetFile) throws FileNotFoundException, CoreException {
        ArrayList<String> results = new ArrayList<String>();
        Path path = new Path(ruleSetFile);
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path.toFile()));
        IExportedPreferences exportedPrefs = Platform.getPreferencesService().readPreferences((InputStream)input);
        Preferences instanceNode = exportedPrefs.node("/instance");
        try {
            Preferences validationNode = instanceNode.node("org.eclipse.emf.validation");
            String[] stringArray = validationNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                boolean isDisabled = validationNode.getBoolean(s, false);
                if (isDisabled) {
                    String[] split = s.split("/");
                    results.add(split[1]);
                }
                ++n2;
            }
        }
        catch (BackingStoreException exception1) {
            String loggerMessage = "ValidationCommandLine.readRules(..) _ ";
            logger.warn((Object)loggerMessage, (Throwable)exception1);
        }
        return results;
    }

    private List<EObject> loadEObjects(Project project, List<String> uris) throws CoreException {
        ArrayList<EObject> results = new ArrayList<EObject>();
        for (String uriFragment : uris) {
            String idSegment = this.getIdSegment(uriFragment);
            ModelElement element = CapellaQueries.getInstance().getGetElementsQueries().getElementById(project, idSegment);
            results.add((EObject)element);
        }
        return results;
    }

    private String getIdSegment(String uriFragment) {
        URI uri = URI.createURI((String)uriFragment);
        return uri.fragment();
    }

    private List<String> toListOfURIString(String validationContext) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = validationContext.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s.trim());
            ++n2;
        }
        return list;
    }

    private Project loadSemanticRootElement(URI uri) {
        SessionManager sessionManager = SessionManager.INSTANCE;
        Session session = sessionManager.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
        return SessionHelper.getCapellaProject((Session)session);
    }

    private void storeResultsToFile(String outputFolder) {
        Collection markers = LightMarkerRegistry.getInstance().getMarkers();
        try {
            Collection<IMarker> validationMarkers = this.filterValidationMarkers(markers);
            String result = null;
            result = this.toHTML(validationMarkers);
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(outputFolder));
            if (!folder.exists()) {
                folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            String fileName = Messages.resultsFileName;
            IFile file = folder.getFile((IPath)new Path(fileName));
            ByteArrayInputStream outputContent = new ByteArrayInputStream(result.getBytes());
            if (file.exists()) {
                file.setContents((InputStream)outputContent, true, false, null);
            } else {
                file.create((InputStream)outputContent, false, null);
            }
        }
        catch (CoreException exception) {
            String loggerMessage = "ValidationComandlineApp.storeResultsToFile(..) _ ";
            logger.error((Object)new EmbeddedMessage(loggerMessage, "Model Validation"));
        }
    }

    private Collection<IMarker> filterValidationMarkers(Collection<IMarker> markers) throws CoreException {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        for (IMarker iMarker : markers) {
            if (!"org.polarsys.capella.core.validation.markers".equals(iMarker.getType())) continue;
            result.add(iMarker);
        }
        return result;
    }

    public static void startFakeWorkbench() {
        if (PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public boolean openWindows() {
                return false;
            }

            public String getInitialWindowPerspectiveId() {
                return null;
            }
        });
    }

    private String toHTML(Collection<IMarker> markers) throws CoreException {
        StringBuilder res = new StringBuilder();
        res.append("<html> \n");
        res.append("<head> \n");
        res.append("<title>Problems saved on " + new Date() + "</title> \n");
        res.append("<head> \n");
        res.append("<body> \n");
        res.append("<table border=\"1\"> \n");
        res.append("<tr> <th> Message</th>\n ");
        res.append("<th> Level</th> \n");
        res.append("<th> Rule id</th> \n");
        res.append("<th> Origin</th> \n");
        res.append("<th> Resource</th> \n");
        res.append("<th> Time</th> </tr> \n");
        DateFormat format = DateFormat.getTimeInstance();
        for (IMarker iMarker : markers) {
            res.append("<tr>");
            res.append("<td>");
            res.append(iMarker.getAttribute("message"));
            res.append("</td>");
            res.append("<td>");
            res.append(this.getSeverityLabel((Integer)iMarker.getAttribute("severity")));
            res.append("</td>");
            res.append("<td>");
            String ruleId = MarkerViewHelper.getRuleID((IMarker)iMarker, (boolean)false);
            if (ruleId == null) {
                ruleId = MarkerViewHelper.getSource((IMarker)iMarker);
            }
            res.append(ruleId);
            res.append("</td>");
            res.append("<td>");
            res.append(this.getCategory(iMarker));
            res.append("</td>");
            res.append("<td>");
            res.append(iMarker.getAttribute("org.eclipse.ui.views.markers.path"));
            res.append("</td>");
            res.append("<td>");
            res.append(format.format(new Date(iMarker.getCreationTime())));
            res.append("</td>");
            res.append("</tr>");
        }
        return res.toString();
    }

    private String getSeverityLabel(Integer severity) {
        switch (severity) {
            case 2: {
                return "Error";
            }
            case 1: {
                return "Warning";
            }
            case 0: {
                return "Info";
            }
        }
        return "";
    }

    private String getCategory(IMarker iMarker) throws CoreException {
        Set cats;
        String result = "";
        Diagnostic diagnostic = (Diagnostic)iMarker.getAdapter(Diagnostic.class);
        if (diagnostic instanceof ConstraintStatusDiagnostic && !(cats = ((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus().getConstraint().getDescriptor().getCategories()).isEmpty()) {
            result = ((Category)cats.iterator().next()).getQualifiedName();
        }
        return result;
    }
}

