/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.SeverityLevel;

public class MarkerViewFilter
extends ViewerFilter {
    public static final String DEBUG_COMMAND = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.severityfilter.debug";
    public static final String INFO_COMMAND = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.severityfilter.info";
    public static final String WARNING_COMMAND = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.severityfilter.warning";
    public static final String ERROR_COMMAND = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.severityfilter.error";
    public static final String FATAL_COMMAND = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.severityfilter.fatal";
    public static final String SELECTIONFILTER_COMMAND = "org.polarsys.capella.common.tools.report.appenders.reportlogview.logview.selectionfilter";
    private Map<String, SeverityLevel> severityLevelMap = new HashMap<String, SeverityLevel>();
    private SelectionFilter selectionFilter;
    private Object selectedElement;
    private IProject project;
    private Set<SeverityLevel> activeLevels;
    private Viewer viewer;

    public MarkerViewFilter(Viewer viewer) {
        this.viewer = viewer;
        this.hookSeverityFilter();
        this.hookSelectionFilter();
    }

    private void hookSelectionFilter() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command c = service.getCommand(SELECTIONFILTER_COMMAND);
        State s = c.getState("org.eclipse.ui.commands.radioState");
        this.selectionFilter = SelectionFilter.valueOf(s.getValue().toString());
        s.addListener(new IStateListener(){

            public void handleStateChange(State state, Object oldValue) {
                SelectionFilter filter = SelectionFilter.valueOf(state.getValue().toString());
                if (filter != MarkerViewFilter.this.selectionFilter) {
                    MarkerViewFilter.this.selectionFilter = filter;
                    MarkerViewFilter.this.updateViewer(state, this, MarkerViewFilter.this.viewer);
                }
            }
        });
    }

    private void hookSeverityFilter() {
        this.severityLevelMap.put(DEBUG_COMMAND, SeverityLevel.DEBUG);
        this.severityLevelMap.put(INFO_COMMAND, SeverityLevel.INFO);
        this.severityLevelMap.put(WARNING_COMMAND, SeverityLevel.WARNING);
        this.severityLevelMap.put(ERROR_COMMAND, SeverityLevel.ERROR);
        this.severityLevelMap.put(FATAL_COMMAND, SeverityLevel.FATAL);
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.activeLevels = EnumSet.noneOf(SeverityLevel.class);
        for (final String commandId : this.severityLevelMap.keySet()) {
            Command command = service.getCommand(commandId);
            State state = command.getState("org.eclipse.ui.commands.toggleState");
            if (((Boolean)state.getValue()).booleanValue()) {
                this.activeLevels.add(this.severityLevelMap.get(commandId));
            }
            state.addListener(new IStateListener(){

                public void handleStateChange(State state, Object oldValue) {
                    SeverityLevel level = (SeverityLevel)((Object)MarkerViewFilter.this.severityLevelMap.get(commandId));
                    if (((Boolean)state.getValue()).booleanValue()) {
                        if (MarkerViewFilter.this.activeLevels.add(level)) {
                            MarkerViewFilter.this.updateViewer(state, this, MarkerViewFilter.this.viewer);
                        }
                    } else if (MarkerViewFilter.this.activeLevels.remove((Object)level)) {
                        MarkerViewFilter.this.updateViewer(state, this, MarkerViewFilter.this.viewer);
                    }
                }
            });
        }
    }

    private void updateViewer(State state, IStateListener listener, Viewer viewer) {
        if (!viewer.getControl().isDisposed()) {
            viewer.refresh();
        } else {
            state.removeListener(listener);
        }
    }

    void setSelectionFilter(SelectionFilter filter) {
        if (filter != this.selectionFilter) {
            this.selectionFilter = filter;
            this.viewer.refresh();
        }
    }

    void setSelection(ISelection selection) {
        boolean refreshViewer = false;
        Object first = null;
        if (selection instanceof IStructuredSelection) {
            first = ((IStructuredSelection)selection).getFirstElement();
        }
        if (first != this.selectedElement) {
            IProject newProject;
            if (this.selectionFilter == SelectionFilter.SELECTION) {
                refreshViewer = true;
            }
            if ((newProject = this.getProject(selection)) != this.project) {
                this.project = newProject;
                if (this.selectionFilter == SelectionFilter.PROJECT) {
                    refreshViewer = true;
                }
            }
            this.selectedElement = first;
        }
        if (refreshViewer) {
            this.viewer.refresh();
        }
    }

    protected IProject getProject(ISelection selection) {
        IProject result = null;
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            result = this.getProject(first);
        }
        return result;
    }

    protected IProject getProject(Object selection) {
        IProject result = null;
        if (selection instanceof IResource) {
            result = ((IResource)selection).getProject();
        } else if (selection instanceof EObject) {
            URI uri;
            Resource resource = ((EObject)selection).eResource();
            if (resource != null && (uri = resource.getURI()) != null && uri.isPlatformResource()) {
                String platformResourceString = uri.toPlatformString(true);
                result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString)).getProject();
            }
        } else if (selection instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class);
            if (resource == null) {
                Platform.getAdapterManager().getAdapter(selection, IResource.class);
            }
            if (resource != null) {
                result = resource.getProject();
            }
        }
        return result;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = true;
        if (element instanceof IMarker) {
            SeverityLevel level = SeverityLevel.getLevel((IMarker)element);
            if (level != null) {
                result = this.activeLevels.contains((Object)level);
            }
            switch (this.selectionFilter) {
                case ALL: {
                    break;
                }
                case PROJECT: {
                    result &= this.select((IResource)this.project, viewer, parentElement, (IMarker)element);
                    break;
                }
                case SELECTION: {
                    result &= this.select(this.selectedElement, viewer, parentElement, (IMarker)element);
                }
            }
        } else {
            TreeViewer client = (TreeViewer)viewer;
            ITreeContentProvider provider = (ITreeContentProvider)client.getContentProvider();
            Object[] children = provider.getChildren(element);
            result = false;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (this.select(viewer, element, o)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    protected boolean select(Object selection, Viewer viewer, Object parent, IMarker marker) {
        EObject firstAffected;
        List<EObject> affected;
        boolean result = false;
        if (selection instanceof IResource) {
            result = this.select((IResource)selection, viewer, parent, marker);
        } else if (selection instanceof EObject && (affected = MarkerViewHelper.getModelElementsFromMarker(marker)).size() > 0 && EcoreUtil.isAncestor((EObject)((EObject)selection), (EObject)(firstAffected = affected.get(0)))) {
            result = true;
        }
        return result;
    }

    private boolean select(IResource resource, Viewer viewer, Object parent, IMarker marker) {
        boolean result = false;
        if (resource == null) {
            return result;
        }
        IResource markerResource = marker.getResource();
        if (markerResource != null) {
            MarkerResourceVisitor vis = new MarkerResourceVisitor(markerResource);
            try {
                resource.accept((IResourceVisitor)vis);
            }
            catch (CoreException e) {
                MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getLocalizedMessage(), (Throwable)e));
            }
            result = vis.getResult();
        }
        return result;
    }

    private class MarkerResourceVisitor
    implements IResourceVisitor {
        public IResource target;
        private boolean found = false;

        public MarkerResourceVisitor(IResource target) {
            this.target = target;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource == this.target) {
                this.found = true;
                return false;
            }
            return true;
        }

        public boolean getResult() {
            return this.found;
        }
    }

    public static enum SelectionFilter {
        PROJECT,
        SELECTION,
        ALL;

    }
}

