/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IMarkerSource;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IMarkerSourceListener;

class ResourceMarkers
implements IResourceChangeListener,
IMarkerSource {
    IResource res;
    final List<IMarkerSourceListener> listeners = new ArrayList<IMarkerSourceListener>();
    private final String[] markerTypes;
    final IResource resource;

    public ResourceMarkers(IResource resource, String[] markerTypes) {
        this.resource = resource;
        this.markerTypes = markerTypes;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        Collection<IMarkerDelta> deltas = this.retainMarkerDeltas(event);
        if (deltas.size() != 0) {
            block4: for (IMarkerDelta markerDelta : deltas) {
                IMarker marker = markerDelta.getMarker();
                switch (markerDelta.getKind()) {
                    case 1: {
                        for (IMarkerSourceListener l : this.listeners) {
                            l.markerAdded(marker);
                        }
                        continue block4;
                    }
                    case 2: {
                        for (IMarkerSourceListener l : this.listeners) {
                            l.markerDeleted(marker);
                        }
                        continue block4;
                    }
                }
            }
        }
    }

    protected Collection<IMarkerDelta> retainMarkerDeltas(IResourceChangeEvent event) {
        ArrayList<IMarkerDelta> deltas = new ArrayList<IMarkerDelta>(0);
        String[] stringArray = this.markerTypes;
        int n = this.markerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.retainMarkerDeltasFor(type, event, deltas);
            ++n2;
        }
        return deltas;
    }

    protected void retainMarkerDeltasFor(String markerType, IResourceChangeEvent event, Collection<IMarkerDelta> resultingCollection) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(markerType, false);
        if (markerDeltas == null) {
            return;
        }
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
            resultingCollection.add(markerDelta);
            ++n2;
        }
    }

    @Override
    public Collection<IMarker> getMarkers() {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        String[] stringArray = this.markerTypes;
        int n = this.markerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            try {
                IMarker[] iMarkerArray = this.resource.findMarkers(t, false, 2);
                int n3 = iMarkerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker m = iMarkerArray[n4];
                    result.add(m);
                    ++n4;
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return result;
    }

    @Override
    public void addListener(IMarkerSourceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IMarkerSourceListener listener) {
        this.listeners.remove(listener);
    }
}

