/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.polarsys.capella.core.commands.preferences.properties.PreferencesHandler;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;
import org.polarsys.capella.core.commands.preferences.service.PreferencesItemsRegistry;

public class ConfigurabilityPreferences {
    private static final IEclipsePreferences defaultScopPref = DefaultScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");
    private static final IEclipsePreferences instanceScopPrefs = InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");

    private ConfigurabilityPreferences() {
    }

    public static void save() {
        try {
            InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences").flush();
            instanceScopPrefs.flush();
        }
        catch (BackingStoreException exception) {
            exception.printStackTrace();
        }
        PreferencesHandler.initializePreferenceCommands();
    }

    public static boolean isInstanceScopePreferenceItemEnabled(String id) {
        return instanceScopPrefs.getBoolean(id, ConfigurabilityPreferences.isItemDisabledByDefault(id));
    }

    public static boolean isItemDisabledByDefault(String id) {
        return defaultScopPref.getBoolean(id, true);
    }

    public static void setItemEnabled(String id, boolean disabled) {
        IItemDescriptor constraint = PreferencesItemsRegistry.getInstance().getDescriptor(id);
        instanceScopPrefs.put(id, Boolean.valueOf(disabled).toString());
        System.setProperty(id, Boolean.valueOf(disabled).toString());
        if (constraint != null) {
            constraint.setEnabled(!disabled);
        } else {
            defaultScopPref.put(id, Boolean.valueOf(disabled).toString());
        }
    }

    public static void setItemDisabledDefault(String id, boolean disabled) {
        defaultScopPref.put(id, Boolean.valueOf(disabled).toString());
    }

    public static void setInstanceScopePreferenceItem(String id, boolean disabled) {
        instanceScopPrefs.put(id, Boolean.valueOf(disabled).toString());
    }
}

