/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.actions.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.TransferTreeListDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.Messages;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.providers.CapellaTransfertViewerLabelProvider;

public class SelectElementsFromTransferWizard
extends AbstractExternalJavaAction {
    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EObject context = (EObject)parameters.get("context");
        List scope = (List)parameters.get("scope");
        List initialSelection = (List)parameters.get("initialSelection");
        String wizardMessage = (String)parameters.get("wizardMessage");
        String resultVariable = (String)parameters.get("resultVariable");
        if (wizardMessage == null) {
            wizardMessage = "";
        }
        if (scope == null) {
            scope = Collections.emptyList();
        }
        if (initialSelection == null) {
            initialSelection = Collections.emptyList();
        }
        boolean expandLeftViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandLeftViewerContent();
        boolean expandRightViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandRightViewerContent();
        int leftViewerExpandLevel = expandLeftViewer ? -1 : 0;
        int rightViewerExpandLevel = expandRightViewer ? -1 : 0;
        TransferTreeListDialog dialog = !scope.isEmpty() && scope.iterator().next() instanceof InstanceRole ? new TransferTreeListDialog(this.getShell(), Messages.SelectElementFromListWizard_Title, wizardMessage, (DataLabelProvider)new IRDataLabelProvider(TransactionHelper.getEditingDomain(scope)), (DataLabelProvider)new IRDataLabelProvider(TransactionHelper.getEditingDomain(scope)), leftViewerExpandLevel, rightViewerExpandLevel) : new TransferTreeListDialog(this.getShell(), Messages.SelectElementFromListWizard_Title, wizardMessage, this.getCustoLabelProvider(), this.getCustoLabelProvider(), leftViewerExpandLevel, rightViewerExpandLevel);
        ArrayList<EObject> availableElements = new ArrayList<EObject>(scope);
        availableElements.removeAll(initialSelection);
        ArrayList<EObject> initialTransferDialogSelection = new ArrayList<EObject>(initialSelection);
        this.handleTransferDialogInputs(initialTransferDialogSelection, dialog, availableElements, this.handleContext(context));
        String result = dialog.open() == 0 ? Arrays.asList(dialog.getResult()) : "WIZARD_CANCELED";
        InterpreterUtil.getInterpreter((EObject)context).setVariable(resultVariable, (Object)result);
    }

    protected Object handleContext(Object context) {
        return null;
    }

    protected void handleTransferDialogInputs(List<EObject> initialSelection, TransferTreeListDialog dialog, List<EObject> availableElements, Object context) {
        dialog.setLeftInput(availableElements, context);
        dialog.setRightInput(initialSelection, context);
    }

    public DataLabelProvider getCustoLabelProvider() {
        return new CapellaTransfertViewerLabelProvider();
    }

    class IRDataLabelProvider
    extends DataLabelProvider {
        public IRDataLabelProvider(TransactionalEditingDomain editingDomain) {
            super(editingDomain, CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
        }

        public String getText(Object object) {
            AbstractType t;
            InstanceRole ir;
            AbstractInstance i;
            if (object instanceof InstanceRole && (i = (ir = (InstanceRole)object).getRepresentedInstance()) != null && (t = i.getAbstractType()) != null) {
                return String.valueOf(i.getName()) + " : " + t.getName();
            }
            return super.getText(object);
        }
    }
}

