/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.delete;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.delete.IDeleteHook;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.preferences.IDeletePreferences;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class CapellaDeleteActionHook
implements IDeleteHook {
    private static Collection<EObject> _selection;

    public static Collection<EObject> getSelection() {
        return _selection;
    }

    protected static void setSelection(Collection<EObject> semanticElements_p) {
        _selection = semanticElements_p;
    }

    public static void removeSelection() {
        CapellaDeleteActionHook.setSelection(null);
    }

    public IStatus beforeDeleteCommandExecution(Collection<DSemanticDecorator> selections_p, Map<String, Object> parameters_p) {
        boolean deletionConfirmed;
        if (selections_p == null || selections_p.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        HashSet<EObject> semanticElements = new HashSet<EObject>(selections_p.size());
        for (DSemanticDecorator semanticDecorator : selections_p) {
            EObject target = semanticDecorator.getTarget();
            if (target == null) continue;
            semanticElements.add(target);
        }
        CapellaDeleteActionHook.setSelection(semanticElements);
        boolean bl = deletionConfirmed = !IDeletePreferences.INSTANCE.isConfirmationRequired() || CapellaDeleteCommand.confirmDeletion((ExecutionManager)TransactionHelper.getExecutionManager(semanticElements), CapellaDeleteActionHook.getSelection());
        if (!deletionConfirmed) {
            CapellaDeleteActionHook.removeSelection();
        }
        return deletionConfirmed ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }
}

