/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideABComponent
extends AbstractShowHide {
    public static final String SOURCE_PARTS = "sourceParts";
    public static final String TARGET_PARTS = "targetParts";
    boolean containsDeployment = true;

    public ShowHideABComponent(DDiagramContents content_p) {
        super(content_p);
        DiagramElementMapping mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingABDeployedElement(this.getContent().getDDiagram()));
        this.containsDeployment = mapping != null && this.getContent().getDiagramElements(mapping).iterator().hasNext();
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        EObject targetContainer;
        Entity entity;
        Collection parts;
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        AbstractCollection result = new ArrayList<Object>();
        if (lastContext.getValue() instanceof Entity && (parts = ComponentExt.getRepresentingParts((Component)(entity = (Entity)lastContext.getValue()))).size() > 0 && (targetContainer = EcoreUtil2.getFirstContainer((EObject)((EObject)parts.iterator().next()), (EClass)CsPackage.Literals.COMPONENT)) instanceof Entity) {
            result.add(targetContainer);
            result.remove(BlockArchitectureExt.getFirstComponent((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)semantic_p)));
        }
        if (lastContext.getValue() instanceof Part) {
            Part part = (Part)lastContext.getValue();
            HashSet result3 = new HashSet();
            if (this.containsDeployment) {
                result3.addAll(PartExt.getDeployingElements((Part)part));
            }
            HashSet result2 = new HashSet();
            EObject targetContainer2 = EcoreUtil2.getFirstContainer((EObject)part, (EClass)CsPackage.Literals.COMPONENT);
            if (targetContainer2 instanceof Component) {
                result2.addAll(ComponentExt.getRepresentingParts((Component)((Component)targetContainer2)));
            }
            result2.removeAll((Collection<?>)BlockArchitectureExt.getFirstComponent((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)semantic_p)).getRepresentingPartitions());
            result.addAll(result2);
            result.addAll(result3);
            if (lastContext.getAncestor() != null) {
                HashSet<EObject> resul3 = new HashSet<EObject>();
                for (EObject eObject : result) {
                    if (!this.getContent().containsView(eObject)) continue;
                    resul3.add(eObject);
                }
                result = resul3;
            }
        }
        value.putAll("container", result);
        return value;
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        if (originCouple_p.getValue() instanceof Part || originCouple_p.getValue() instanceof Entity) {
            DiagramElementMapping mapping;
            if (originCouple_p.getAncestor() != null) {
                for (AbstractShowHide.ContextItemView view : originCouple_p.getAncestor().getElement().getViews()) {
                    if (view.getViews().get("views").size() <= 0) continue;
                    return false;
                }
            }
            if ((mapping = this.getMapping(originCouple_p.getValue(), context_p, relatedViews_p)) == null) {
                return false;
            }
            for (AbstractShowHide.ContextItemView view : originCouple_p.getViews()) {
                Iterator iterator = view.getViews().get("views").iterator();
                while (iterator.hasNext()) {
                    DSemanticDecorator dView = (DSemanticDecorator)iterator.next();
                    if (!(dView instanceof DDiagramElement) || mapping.equals(((DDiagramElement)dView).getDiagramElementMapping())) continue;
                    return false;
                }
            }
            if (originCouple_p.getAncestor() != null) {
                for (AbstractShowHide.ContextItemView view : originCouple_p.getViews()) {
                    if (view.getViews().get("initial").size() <= 0) continue;
                    return false;
                }
            }
        }
        return super.mustShow(originCouple_p, context_p, relatedViews_p);
    }

    @Override
    protected boolean bypassRelatedElements(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        if (originCouple_p.getAncestor() != null && (originCouple_p.getValue() instanceof Part && originCouple_p.getAncestor().getElement().getValue() instanceof Part ? !PartExt.getDeployingElements((Part)((Part)originCouple_p.getAncestor().getElement().getValue())).contains(originCouple_p.getValue()) : originCouple_p.getValue() instanceof Entity && originCouple_p.getAncestor().getElement().getValue() instanceof Entity)) {
            return true;
        }
        return super.bypassRelatedElements(originCouple_p, context_p);
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        if (semantic_p instanceof Entity) {
            mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingABComponent(semantic_p, this.getContent().getDDiagram()));
        } else if (semantic_p instanceof Part) {
            Object targetViews;
            Part part = (Part)semantic_p;
            if (this.containsDeployment && PartExt.getDeployingElements((Part)part).size() > 0 && (targetViews = relatedViews_p.get("container")).size() != 0 && PartExt.getDeployingElements((Part)((Part)semantic_p)).contains(((DSemanticDecorator)targetViews.iterator().next()).getTarget())) {
                return this.getContent().getMapping(MappingConstantsHelper.getMappingABDeployedElement(this.getContent().getDDiagram()));
            }
            mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingABComponent(semantic_p, this.getContent().getDDiagram()));
        }
        return mapping;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        if (semantic_p instanceof Part || semantic_p instanceof Entity) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        return semantic instanceof Part || semantic instanceof Entity;
    }
}

