/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponentExchange;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideABPhysicalLink
extends ShowHideABComponentExchange {
    public ShowHideABPhysicalLink(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof PhysicalLink) {
            PhysicalLink exchange = (PhysicalLink)lastContext.getValue();
            Port source = PhysicalLinkExt.getSourcePort((PhysicalLink)exchange);
            Port target = PhysicalLinkExt.getTargetPort((PhysicalLink)exchange);
            if (source == null) {
                source = PhysicalLinkExt.getSourcePart((PhysicalLink)exchange);
            }
            if (target == null) {
                target = PhysicalLinkExt.getTargetPart((PhysicalLink)exchange);
            }
            value.put("source", (EObject)source);
            value.put("target", (EObject)target);
        } else if (lastContext.getValue() instanceof PhysicalPort) {
            PhysicalPort port = (PhysicalPort)lastContext.getValue();
            value.putAll("container", ComponentExt.getRepresentingParts((Component)PortExt.getRelatedComponent((PhysicalPort)port)));
        }
        return value;
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof PhysicalPort) {
            mapping = FaServices.getFaServices().getMappingABPhysicalPort((Port)((PhysicalPort)lastContext.getValue()), this.getContent().getDDiagram());
        } else if (lastContext.getValue() instanceof PhysicalLink) {
            mapping = FaServices.getFaServices().getMappingABPhysicalLink(this.getContent().getDDiagram());
        }
        return mapping;
    }

    @Override
    protected boolean mustShow(DSemanticDecorator source_p, DSemanticDecorator target_p, EObject exchange_p, EdgeMapping edgeMapping_p) {
        if (exchange_p instanceof PhysicalLink) {
            return CsServices.getService().isValidPhysicalLinkEdge((PhysicalLink)exchange_p, source_p, target_p);
        }
        return super.mustShow(source_p, target_p, exchange_p, edgeMapping_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        if (semantic instanceof PhysicalPort) {
            return true;
        }
        if (semantic instanceof PhysicalLink) {
            return true;
        }
        return super.mustHide(originCouple_p, context_p);
    }
}

