/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABRole;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideFunction
extends ShowHideABRole {
    public ShowHideFunction(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        if (lastContext.getValue() instanceof AbstractFunction) {
            AbstractFunction function = (AbstractFunction)lastContext.getValue();
            if (DiagramHelper.getService().isArchitectureBlank((DRepresentation)this.getContent().getDDiagram())) {
                HashSet<Object> result = new HashSet<Object>();
                for (Object block : AbstractFunctionExt.getAllocationBlocks((Object)lastContext.getValue())) {
                    if (block instanceof Entity) {
                        result.add((Component)block);
                        continue;
                    }
                    if (block instanceof Role) {
                        result.add((Role)block);
                        continue;
                    }
                    if (block instanceof Component) {
                        result.addAll(ComponentExt.getRepresentingParts((Component)((Component)block)));
                        continue;
                    }
                    if (!(block instanceof Component)) continue;
                    result.addAll(ComponentExt.getRepresentingParts((Component)((Component)block)));
                }
                value.putAll("container", result);
            } else {
                DragAndDropTarget node = this.getContent().getBestContainer((EObject)function);
                if (node instanceof DSemanticDecorator && !(node instanceof DDiagram)) {
                    value.put("container", ((DSemanticDecorator)node).getTarget());
                }
            }
        }
        return value;
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        if (originCouple_p.getValue() instanceof AbstractFunction && originCouple_p.getAncestor() != null) {
            for (AbstractShowHide.ContextItemView view : originCouple_p.getAncestor().getElement().getViews()) {
                if (view.getViews().get("views").size() <= 0) continue;
                return false;
            }
        }
        return super.mustShow(originCouple_p, context_p, relatedViews_p);
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        if (semantic_p instanceof AbstractFunction) {
            String mappingName = MappingConstantsHelper.getMappingFunction(this.getContent().getDDiagram());
            mapping = this.getContent().getMapping(mappingName);
        }
        return mapping;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        if (!DiagramHelper.getService().isArchitectureBlank((DRepresentation)this.getContent().getDDiagram()) && semantic_p instanceof AbstractFunction) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustShow(DSemanticDecorator containerView_p, EObject semantic_p, AbstractNodeMapping mapping_p) {
        if (DiagramHelper.getService().isArchitectureBlank((DRepresentation)this.getContent().getDDiagram()) && containerView_p instanceof DDiagram && semantic_p instanceof AbstractFunction) {
            return false;
        }
        return super.mustShow(containerView_p, semantic_p, mapping_p);
    }

    @Override
    protected boolean mustHide(DDiagramElement view_p, AbstractShowHide.DiagramContext context_p) {
        if (view_p.getTarget() instanceof OperationalActivity) {
            return true;
        }
        return super.mustHide(view_p, context_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        if ("container".equals(originCouple_p.getKey())) {
            return false;
        }
        return semantic instanceof AbstractFunction;
    }
}

