/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.IBServices;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideIDRelationships
extends AbstractShowHide {
    public static final String INITIAL_SOURCE_VIEW = "sourceComponent";
    public static final String PROVIDED_INTERFACE = "provided";
    public static final String REQUIRED_INTERFACE = "required";

    public ShowHideIDRelationships(DDiagramContents content) {
        super(content);
    }

    @Override
    protected DiagramElementMapping getMapping(EObject semantic, AbstractShowHide.DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        if (semantic instanceof CommunicationLink) {
            return IBServices.getService().getMappingIDCommunicationLink(semantic, this.getContent().getDDiagram());
        }
        if (semantic instanceof Generalization) {
            return IBServices.getService().getMappingIDGeneralization(semantic, this.getContent().getDDiagram());
        }
        if (semantic instanceof ExchangeItem) {
            return IBServices.getService().getMappingIDExchangeItem(semantic, this.getContent().getDDiagram());
        }
        if (semantic instanceof Interface) {
            return IBServices.getService().getMappingIDInterface(semantic, this.getContent().getDDiagram());
        }
        if (semantic instanceof Component) {
            return IBServices.getService().getMappingIDComponent(semantic, this.getContent().getDDiagram());
        }
        if (semantic instanceof InterfaceUse) {
            return IBServices.getService().getMappingIDInterfaceUse(semantic, this.getContent().getDDiagram());
        }
        if (semantic instanceof InterfaceImplementation) {
            return IBServices.getService().getMappingIDInterfaceImplementation(semantic, this.getContent().getDDiagram());
        }
        if (semantic instanceof ComponentPort) {
            if (relatedViews.containsKey("source") && relatedViews.containsKey("target") && context.getLastVariable(PROVIDED_INTERFACE) != null) {
                return IBServices.getService().getMappingIDInterfaceProvide(semantic, this.getContent().getDDiagram());
            }
            if (relatedViews.containsKey("source") && relatedViews.containsKey("target") && context.getLastVariable(REQUIRED_INTERFACE) != null) {
                return IBServices.getService().getMappingIDInterfaceRequire(semantic, this.getContent().getDDiagram());
            }
            return IBServices.getService().getMappingIDComponentPort(semantic, this.getContent().getDDiagram());
        }
        return super.getMapping(semantic, context, relatedViews);
    }

    @Override
    protected HashMapSet<String, EObject> getRelatedObjects(EObject semantic, AbstractShowHide.DiagramContext context) {
        HashMapSet<String, EObject> result = new HashMapSet<String, EObject>();
        if (semantic instanceof CommunicationLink) {
            result.put("source", ((DSemanticDecorator)context.getLastVariable(INITIAL_SOURCE_VIEW).getValue()).getTarget());
            result.put("target", (EObject)((CommunicationLink)semantic).getExchangeItem());
        }
        if (semantic instanceof Generalization) {
            result.put("source", (EObject)((Generalization)semantic).getSub());
            result.put("target", (EObject)((Generalization)semantic).getSuper());
        }
        if (semantic instanceof InterfaceUse) {
            result.put("source", ((DSemanticDecorator)context.getLastVariable(INITIAL_SOURCE_VIEW).getValue()).getTarget());
            result.put("target", (EObject)((InterfaceUse)semantic).getUsedInterface());
        }
        if (semantic instanceof InterfaceImplementation) {
            result.put("source", ((DSemanticDecorator)context.getLastVariable(INITIAL_SOURCE_VIEW).getValue()).getTarget());
            result.put("target", (EObject)((InterfaceImplementation)semantic).getImplementedInterface());
        }
        if (semantic instanceof ComponentPort) {
            if (context.getLast("source") == null && context.getLast("target") == null && context.getLastVariable(PROVIDED_INTERFACE) != null) {
                result.put("source", ((DSemanticDecorator)context.getLastVariable(INITIAL_SOURCE_VIEW).getValue()).getTarget());
                result.put("target", (EObject)((Interface)context.getLastVariable(PROVIDED_INTERFACE).getValue()));
            } else if (context.getLast("source") == null && context.getLast("target") == null && context.getLastVariable(REQUIRED_INTERFACE) != null) {
                result.put("source", ((DSemanticDecorator)context.getLastVariable(INITIAL_SOURCE_VIEW).getValue()).getTarget());
                result.put("target", (EObject)((Interface)context.getLastVariable(REQUIRED_INTERFACE).getValue()));
            } else {
                result.put("container", ((ComponentPort)semantic).eContainer());
            }
        }
        return result;
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple, AbstractShowHide.DiagramContext context) {
        if (originCouple.getValue() instanceof CommunicationLink) {
            return true;
        }
        if (originCouple.getValue() instanceof Generalization) {
            return true;
        }
        if (originCouple.getValue() instanceof Component) {
            return false;
        }
        if (originCouple.getValue() instanceof Interface) {
            return false;
        }
        if (originCouple.getValue() instanceof ExchangeItem) {
            return false;
        }
        if (originCouple.getValue() instanceof ComponentPort) {
            return originCouple.getKey().equals("root");
        }
        return super.mustHide(originCouple, context);
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic, AbstractShowHide.DiagramContext context, Collection<DSemanticDecorator> targetViews) {
        if (semantic instanceof ExchangeItem || semantic instanceof Interface || semantic instanceof Component) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic, context, targetViews);
    }
}

