/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.compare;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.sirius.SiriusMatchPolicy;
import org.eclipse.emf.diffmerge.structures.common.comparable.ComparableTreeMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.libraries.LibrariesPackage;
import org.polarsys.capella.common.libraries.LibraryReference;
import org.polarsys.capella.core.compare.Messages;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.KeyValue;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.capellamodeller.Library;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datavalue.BinaryExpression;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.datavalue.ValuePart;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityInclude;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.kitalpha.ad.metadata.metadata.ViewpointReference;

public class CapellaMatchPolicy
extends SiriusMatchPolicy {
    public static final ConfigurableMatchPolicy.FineGrainedMatchCriterion CRITERION_INTRINSIC_ID_SID = new ConfigurableMatchPolicy.FineGrainedMatchCriterion(ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID, Messages.CapellaMatchPolicy_Criterion_SIDs, Messages.CapellaMatchPolicy_Criterion_SIDs_Tooltip);
    public static final ConfigurableMatchPolicy.FineGrainedMatchCriterion CRITERION_SEMANTICS_TECHNICALELEMENTS = new ConfigurableMatchPolicy.FineGrainedMatchCriterion(ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS, Messages.CapellaMatchPolicy_Criterion_Technical, Messages.CapellaMatchPolicy_Criterion_Technical_Tooltip);
    public static final ConfigurableMatchPolicy.FineGrainedMatchCriterion CRITERION_SEMANTICS_P2L = new ConfigurableMatchPolicy.FineGrainedMatchCriterion(ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS, Messages.CapellaMatchPolicy_Criterion_P2L, Messages.CapellaMatchPolicy_Criterion_P2L_Tooltip);
    public static final ConfigurableMatchPolicy.FineGrainedMatchCriterion CRITERION_QNAMES_EXCHANGES = new ConfigurableMatchPolicy.FineGrainedMatchCriterion(ConfigurableMatchPolicy.MatchCriterionKind.NAME, Messages.CapellaMatchPolicy_Criterion_ExchangeEnds, Messages.CapellaMatchPolicy_Criterion_ExchangeEnds_Tooltip);
    protected static final String CAPELLA_PROJECT_APPROACH = "projectApproach";
    protected static final Collection<String> CAPELLA_PROGRESS_STATUS_LITERALS = Arrays.asList("DRAFT", "TO_BE_REVIEWED", "TO_BE_DISCUSSED", "REWORK_NECESSARY", "UNDER_REWORK", "REVIEWED_OK");
    protected static final Collection<String> CAPELLA_PREDEFINED_TYPE_NAMES = Arrays.asList(NamingConstants.PredefinedTypesCmd_boolean_name, NamingConstants.PredefinedTypesCmd_byte_name, NamingConstants.PredefinedTypesCmd_char_name, NamingConstants.PredefinedTypesCmd_double_name, NamingConstants.PredefinedTypesCmd_float_name, NamingConstants.PredefinedTypesCmd_hexadecimal_name, NamingConstants.PredefinedTypesCmd_integer_name, NamingConstants.PredefinedTypesCmd_long_name, NamingConstants.PredefinedTypesCmd_longLong_name, NamingConstants.PredefinedTypesCmd_short_name, NamingConstants.PredefinedTypesCmd_string_name, NamingConstants.PredefinedTypesCmd_unsignedInteger_name, NamingConstants.PredefinedTypesCmd_unsignedLong_name, NamingConstants.PredefinedTypesCmd_unsignedLongLong_name, NamingConstants.PredefinedTypesCmd_unsignedShort_name);
    protected static final Collection<String> CAPELLA_PREDEFINED_BOOLEAN_LITERALS = Arrays.asList(NamingConstants.PredefinedTypesCmd_trueValue_name, NamingConstants.PredefinedTypesCmd_falseValue_name);
    protected static final String SEMANTIC_ID_END1_PROPERTY = "~END1";
    protected static final String SEMANTIC_ID_END2_PROPERTY = "~END2";
    private static Collection<EReference> DISCRIMINATING_CONTAINMENTS = null;
    private static Collection<EClass> UNIQUELY_OCCURRING_TYPES = null;
    private static Collection<EClass> UNSIGNIFICANT_NAMEDELEMENT_SUBTYPES = null;

    public CapellaMatchPolicy() {
    }

    public CapellaMatchPolicy(CapellaMatchPolicy policy_p) {
        this();
        this.update((IConfigurablePolicy)policy_p);
    }

    public CapellaMatchPolicy clone() throws CloneNotSupportedException {
        return new CapellaMatchPolicy(this);
    }

    public List<ConfigurableMatchPolicy.FineGrainedMatchCriterion> getAvailableFineGrainedCriteria() {
        List result = super.getAvailableFineGrainedCriteria();
        result.add(CRITERION_QNAMES_EXCHANGES);
        int pos = result.indexOf(CRITERION_SEMANTICS_DEFAULTCONTENTS);
        result.add(pos + 1, CRITERION_SEMANTICS_P2L);
        result.add(pos + 2, CRITERION_SEMANTICS_TECHNICALELEMENTS);
        result.add(CRITERION_INTRINSIC_ID_SID);
        return result;
    }

    protected String getCapellaDefaultContentRootSemanticID(EObject element_p, IModelScope scope_p) {
        String result = null;
        EObject root = EcoreUtil.getRootContainer((EObject)element_p);
        if (root != null && root != element_p) {
            result = this.getStructureBasedRootQualifier(root, scope_p);
        }
        return result;
    }

    protected String getCapellaDefaultContentSemanticID(EObject element_p, IModelScope scope_p) {
        String result = null;
        String rootPrefix = this.getCapellaDefaultContentRootSemanticID(element_p, scope_p);
        if (rootPrefix != null) {
            EClass type = element_p.eClass();
            if (this.getUniquelyOccurringTypes().contains(type)) {
                result = String.valueOf(rootPrefix) + this.getQualificationSeparatorDefault() + type.getName();
            } else if (this.isUniqueModelingArchitectureChild(element_p, scope_p) || this.isSystemComponentAllocation(element_p, scope_p) || this.isRootFunctionRealization(element_p, scope_p) || this.isSystemStateMachine(element_p, scope_p) || this.isSystemStateMachineMainRegion(element_p, scope_p)) {
                result = this.getContainerRelativeID(element_p, scope_p, type.getName(), null);
            } else if (this.isPredefinedTypePackage(element_p, scope_p) || this.isPredefinedType(element_p, scope_p) || this.isPredefinedBooleanLiteral(element_p, scope_p) || this.isProgressStatusLiteral(element_p, scope_p)) {
                result = this.getContainerRelativeID(element_p, scope_p, ((AbstractNamedElement)element_p).getName(), null);
            } else if (this.isSystemComponentPart(element_p, scope_p)) {
                result = this.getContainerRelativeID(element_p, scope_p, "SystemPart", null);
            } else if (this.isRootFunction(element_p, scope_p)) {
                result = this.getContainerRelativeID(element_p, scope_p, "Root" + type.getName(), null);
            } else if (this.isPredefinedTypeProperty(element_p, scope_p)) {
                result = this.getContainerRelativeID(element_p, scope_p, this.getContainment(element_p, scope_p).getName(), null);
            } else if (this.isProjectApproach(element_p, scope_p)) {
                result = String.valueOf(rootPrefix) + this.getQualificationSeparatorSemantics() + ((KeyValue)element_p).getKey();
            } else if (this.isProgressStatus(element_p, scope_p)) {
                result = String.valueOf(rootPrefix) + this.getQualificationSeparatorSemantics() + "ProgressStatus";
            }
        }
        return result;
    }

    protected Collection<EReference> getDiscriminatingContainments() {
        if (DISCRIMINATING_CONTAINMENTS == null) {
            DISCRIMINATING_CONTAINMENTS = Arrays.asList(CtxPackage.eINSTANCE.getSystemAnalysis_OwnedOperationalAnalysisRealizations(), LaPackage.eINSTANCE.getLogicalArchitecture_OwnedSystemAnalysisRealizations(), PaPackage.eINSTANCE.getPhysicalArchitecture_OwnedLogicalArchitectureRealizations(), EpbsPackage.eINSTANCE.getEPBSArchitecture_OwnedPhysicalArchitectureRealizations());
        }
        return DISCRIMINATING_CONTAINMENTS;
    }

    protected String getFreelyNamedElementUniqueName(AbstractNamedElement element_p, IModelScope scope_p) {
        String result = null;
        if (this.useFineGrainedCriterion(CRITERION_QNAMES_EXCHANGES)) {
            if (element_p instanceof FunctionalExchange) {
                FunctionalExchange casted = (FunctionalExchange)element_p;
                result = this.getTwoEndedElementUniqueName((AbstractNamedElement)casted, (EObject)casted.getSourceFunctionOutputPort(), (EObject)casted.getTargetFunctionInputPort(), scope_p);
            } else if (element_p instanceof ComponentExchange) {
                ComponentExchange casted = (ComponentExchange)element_p;
                result = this.getTwoEndedElementUniqueName((AbstractNamedElement)casted, (EObject)casted.getSourcePort(), (EObject)casted.getTargetPort(), scope_p);
            } else if (element_p instanceof PhysicalLink) {
                PhysicalLink casted = (PhysicalLink)element_p;
                result = this.getTwoEndedElementUniqueName((AbstractNamedElement)casted, (EObject)casted.getSourcePhysicalPort(), (EObject)casted.getTargetPhysicalPort(), scope_p);
            }
        }
        if (result == null) {
            result = element_p.getName();
        }
        return result;
    }

    protected String getIntrinsicID(EObject element_p) {
        String result = null;
        if (element_p instanceof ModelElement && this.useFineGrainedCriterion(CRITERION_INTRINSIC_ID_SID)) {
            result = ((ModelElement)element_p).getSid();
        }
        if (result == null) {
            result = super.getIntrinsicID(element_p);
        }
        return result;
    }

    protected String getName(EObject element_p, IModelScope scope_p) {
        String result = null;
        if (element_p instanceof AbstractNamedElement && !this.isInstanceOf(element_p, this.getUnsignificantNamedElementSubtypes())) {
            AbstractNamedElement namedElement = (AbstractNamedElement)element_p;
            String rawName = namedElement.getName();
            UniqueNameRequirementKind req = this.getNamingRequirement(namedElement);
            if (req == UniqueNameRequirementKind.IN_CONTAINER) {
                result = rawName;
            } else if (req == UniqueNameRequirementKind.IN_CONTAINMENT) {
                EReference containment = this.getContainment(element_p, scope_p);
                if (containment != null) {
                    result = String.valueOf(containment.getName()) + this.getQualificationSeparatorDefault() + rawName;
                }
            } else {
                result = this.getFreelyNamedElementUniqueName(namedElement, scope_p);
            }
        }
        if (result == null) {
            result = super.getName(element_p, scope_p);
        }
        return result;
    }

    protected UniqueNameRequirementKind getNamingRequirement(AbstractNamedElement element_p) {
        UniqueNameRequirementKind result = element_p instanceof FunctionalExchange || element_p instanceof ComponentExchange || element_p instanceof PhysicalLink || this.isTechnical((EObject)element_p) ? UniqueNameRequirementKind.NONE : (element_p instanceof Part ? UniqueNameRequirementKind.IN_CONTAINMENT : UniqueNameRequirementKind.IN_CONTAINER);
        return result;
    }

    protected String getTwoEndedElementSemanticID(EObject element_p, EObject end1_p, EObject end2_p, IModelScope scope_p) {
        String id2;
        String id1;
        String result = null;
        if (end1_p != null && end2_p != null && (id1 = this.getMatchID(end1_p, scope_p)) != null && (id2 = this.getMatchID(end2_p, scope_p)) != null) {
            String typeID = element_p.eClass().getName();
            ComparableTreeMap map = new ComparableTreeMap();
            map.put("SEMANTIC_TYPE", typeID);
            map.put(SEMANTIC_ID_END1_PROPERTY, id1);
            map.put(SEMANTIC_ID_END2_PROPERTY, id2);
            result = map.toString();
        }
        return result;
    }

    protected String getTwoEndedElementUniqueName(AbstractNamedElement element_p, EObject end1_p, EObject end2_p, IModelScope scope_p) {
        String qname2;
        String qname1;
        String result = null;
        if (end1_p != null && end2_p != null && (qname1 = this.getMatchID(end1_p, scope_p)) != null && (qname2 = this.getMatchID(end2_p, scope_p)) != null) {
            StringBuilder builder = new StringBuilder();
            String mainName = element_p.getName();
            builder.append(mainName);
            builder.append(" (");
            builder.append(qname1);
            builder.append("->");
            builder.append(qname2);
            builder.append(')');
            result = builder.toString();
        }
        return result;
    }

    protected String getSemanticID(EObject element_p, IModelScope scope_p) {
        String result = null;
        if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_P2L) && this.isMainCapellaRoot(element_p, scope_p)) {
            result = String.valueOf(this.getQualificationSeparatorSemantics()) + "Capella";
        } else if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_TECHNICALELEMENTS) && this.isTechnical(element_p)) {
            result = this.getTechnicalElementSemanticID(element_p, scope_p);
        } else if (element_p instanceof ViewpointReference) {
            result = this.getViewpointReferenceSemanticID((ViewpointReference)element_p, scope_p);
        } else if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_DEFAULTCONTENTS)) {
            result = this.getCapellaDefaultContentSemanticID(element_p, scope_p);
        }
        if (result == null) {
            result = super.getSemanticID(element_p, scope_p);
        }
        return result;
    }

    protected String getStructureBasedRootQualifier(EObject element_p, IModelScope scope_p) {
        String result = null;
        result = this.useFineGrainedCriterion(CRITERION_SEMANTICS_P2L) && this.isMainCapellaRoot(element_p, scope_p) ? this.getSemanticID(element_p, scope_p) : super.getStructureBasedRootQualifier(element_p, scope_p);
        if (result == null && element_p instanceof Library) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getQualificationSeparatorStructure());
            builder.append("CapellaLibrary<");
            builder.append(((Library)element_p).getId());
            builder.append('>');
            result = builder.toString();
        }
        return result;
    }

    protected String getTechnicalElementSemanticID(EObject element_p, IModelScope scope_p) {
        String result = null;
        if (element_p instanceof AbstractTrace) {
            AbstractTrace casted = (AbstractTrace)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getSourceElement(), (EObject)casted.getTargetElement(), scope_p);
        } else if (element_p instanceof AbstractCapabilityInclude) {
            AbstractCapabilityInclude casted = (AbstractCapabilityInclude)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getInclusion(), (EObject)casted.getIncluded(), scope_p);
        } else if (element_p instanceof AbstractDeploymentLink) {
            AbstractDeploymentLink casted = (AbstractDeploymentLink)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getDeployedElement(), (EObject)casted.getLocation(), scope_p);
        } else if (element_p instanceof CapabilityExploitation) {
            CapabilityExploitation casted = (CapabilityExploitation)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getCapability(), (EObject)casted.getMission(), scope_p);
        } else if (element_p instanceof CommunicationLink) {
            CommunicationLink casted = (CommunicationLink)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, casted.eContainer(), (EObject)casted.getExchangeItem(), scope_p);
        } else if (element_p instanceof ComponentExchangeEnd) {
            ComponentExchangeEnd casted = (ComponentExchangeEnd)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getPart(), (EObject)casted.getPort(), scope_p);
        } else if (element_p instanceof ExchangeItemAllocation) {
            ExchangeItemAllocation casted = (ExchangeItemAllocation)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getAllocatingInterface(), (EObject)casted.getAllocatedItem(), scope_p);
        } else if (element_p instanceof Generalization) {
            Generalization casted = (Generalization)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getSub(), (EObject)casted.getSuper(), scope_p);
        } else if (element_p instanceof InterfaceImplementation) {
            InterfaceImplementation casted = (InterfaceImplementation)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getInterfaceImplementor(), (EObject)casted.getImplementedInterface(), scope_p);
        } else if (element_p instanceof InterfaceUse) {
            InterfaceUse casted = (InterfaceUse)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getInterfaceUser(), (EObject)casted.getUsedInterface(), scope_p);
        } else if (element_p instanceof Involvement && !(element_p instanceof FunctionalChainInvolvement)) {
            Involvement casted = (Involvement)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getInvolver(), (EObject)casted.getInvolved(), scope_p);
        } else if (element_p instanceof ValuePart) {
            Property property = ((ValuePart)element_p).getReferencedProperty();
            if (property != null) {
                result = this.getContainerRelativeID(element_p, scope_p, property.getName(), null);
            }
        } else if (element_p instanceof KeyValue) {
            result = this.getContainerRelativeID(element_p, scope_p, String.valueOf(((KeyValue)element_p).getKey()) + '|' + ((KeyValue)element_p).getValue(), null);
        } else if (element_p instanceof PhysicalLinkEnd) {
            PhysicalLinkEnd casted = (PhysicalLinkEnd)element_p;
            result = this.getTwoEndedElementSemanticID((EObject)casted, (EObject)casted.getPart(), (EObject)casted.getPort(), scope_p);
        } else if (element_p instanceof LibraryReference) {
            result = this.getContainerRelativeID(element_p, scope_p, ((LibraryReference)element_p).getLibrary().getId(), null);
        }
        return result;
    }

    protected Collection<EClass> getUniquelyOccurringTypes() {
        if (UNIQUELY_OCCURRING_TYPES == null) {
            UNIQUELY_OCCURRING_TYPES = Arrays.asList(CapellamodellerPackage.eINSTANCE.getProject(), CapellamodellerPackage.eINSTANCE.getSystemEngineering(), OaPackage.eINSTANCE.getOperationalAnalysis(), CtxPackage.eINSTANCE.getSystemAnalysis(), LaPackage.eINSTANCE.getLogicalArchitecture(), PaPackage.eINSTANCE.getPhysicalArchitecture(), EpbsPackage.eINSTANCE.getEPBSArchitecture(), OaPackage.eINSTANCE.getOperationalContext(), CtxPackage.eINSTANCE.getSystemContext(), LaPackage.eINSTANCE.getLogicalContext(), PaPackage.eINSTANCE.getPhysicalContext(), EpbsPackage.eINSTANCE.getEPBSContext(), LibrariesPackage.eINSTANCE.getModelInformation());
        }
        return UNIQUELY_OCCURRING_TYPES;
    }

    protected Collection<EClass> getUnsignificantNamedElementSubtypes() {
        if (UNSIGNIFICANT_NAMEDELEMENT_SUBTYPES == null) {
            UNSIGNIFICANT_NAMEDELEMENT_SUBTYPES = Arrays.asList(InteractionPackage.eINSTANCE.getCombinedFragment(), InteractionPackage.eINSTANCE.getEvent(), InteractionPackage.eINSTANCE.getExecution(), InteractionPackage.eINSTANCE.getInteractionFragment(), InteractionPackage.eINSTANCE.getInteractionUse(), InteractionPackage.eINSTANCE.getSequenceMessage(), InteractionPackage.eINSTANCE.getStateFragment());
        }
        return UNSIGNIFICANT_NAMEDELEMENT_SUBTYPES;
    }

    protected String getViewpointReferenceSemanticID(ViewpointReference element_p, IModelScope scope_p) {
        String result = null;
        String vpId = element_p.getVpId();
        if (vpId != null) {
            result = this.getContainerRelativeID((EObject)element_p, scope_p, vpId, null);
        }
        return result;
    }

    public Collection<ConfigurableMatchPolicy.MatchCriterionKind> getVisibleCriteria() {
        return Arrays.asList(ConfigurableMatchPolicy.MatchCriterionKind.values());
    }

    protected boolean isDiscriminatingContainment(EObject element_p, EReference containment_p) {
        return super.isDiscriminatingContainment(element_p, containment_p) || this.getDiscriminatingContainments().contains(containment_p);
    }

    protected boolean isMainCapellaRoot(EObject element_p, IModelScope scope_p) {
        boolean result = false;
        if ((element_p instanceof Project || element_p instanceof Library) && (result = this.isUniqueSiblingOfItsType(element_p, scope_p)) && element_p instanceof Library) {
            for (EObject root : scope_p.getContents()) {
                if (!(root instanceof Project) || root instanceof Library) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected boolean isPredefinedBooleanLiteral(EObject element_p, IModelScope scope_p) {
        EObject container;
        boolean result = false;
        if (element_p instanceof LiteralBooleanValue && (container = this.getContainer(element_p, scope_p)) instanceof BooleanType && this.isPredefinedType(container, scope_p)) {
            result = CAPELLA_PREDEFINED_BOOLEAN_LITERALS.contains(((LiteralBooleanValue)element_p).getName());
        }
        return result;
    }

    protected boolean isPredefinedType(EObject element_p, IModelScope scope_p) {
        EObject container;
        boolean result = false;
        if (element_p instanceof DataType && this.isPredefinedTypePackage(container = this.getContainer(element_p, scope_p), scope_p)) {
            result = CAPELLA_PREDEFINED_TYPE_NAMES.contains(((DataType)element_p).getName());
        }
        return result;
    }

    protected boolean isPredefinedTypePackage(EObject element_p, IModelScope scope_p) {
        EObject superContainer;
        EObject container;
        boolean result = false;
        if (element_p instanceof DataPkg && (container = this.getContainer(element_p, scope_p)) instanceof DataPkg && (superContainer = this.getContainer(container, scope_p)) instanceof SystemAnalysis) {
            result = NamingConstants.PredefinedTypesCmd_predefinedDataTypePkg_name.equals(((DataPkg)element_p).getName());
        }
        return result;
    }

    protected boolean isPredefinedTypeProperty(EObject element_p, IModelScope scope_p) {
        boolean result = false;
        if (element_p instanceof NumericValue) {
            EObject container = this.getContainer(element_p, scope_p);
            if (this.isPredefinedType(container, scope_p)) {
                result = this.isInDiscriminatingContainment(element_p, scope_p);
            } else if (container instanceof BinaryExpression && this.isInDiscriminatingContainment(container, scope_p)) {
                EObject typeCandidate = this.getContainer(container, scope_p);
                if (typeCandidate instanceof BinaryExpression && this.isInDiscriminatingContainment(typeCandidate, scope_p)) {
                    typeCandidate = this.getContainer(typeCandidate, scope_p);
                }
                result = this.isPredefinedType(typeCandidate, scope_p);
            }
        }
        return result;
    }

    protected boolean isProgressStatus(EObject element_p, IModelScope scope_p) {
        return element_p instanceof EnumerationPropertyType && this.getContainer(element_p, scope_p) instanceof Project && "ProgressStatus".equals(((EnumerationPropertyType)element_p).getName());
    }

    protected boolean isProgressStatusLiteral(EObject element_p, IModelScope scope_p) {
        return element_p instanceof EnumerationPropertyLiteral && this.isProgressStatus(this.getContainer(element_p, scope_p), scope_p) && CAPELLA_PROGRESS_STATUS_LITERALS.contains(((EnumerationPropertyLiteral)element_p).getName());
    }

    protected boolean isProjectApproach(EObject element_p, IModelScope scope_p) {
        return element_p instanceof KeyValue && this.getContainer(element_p, scope_p) instanceof Project && CAPELLA_PROJECT_APPROACH.equals(((KeyValue)element_p).getKey());
    }

    protected boolean isRootFunction(EObject element_p, IModelScope scope_p) {
        EObject container;
        boolean result = false;
        if (element_p instanceof AbstractFunction && (container = this.getContainer(element_p, scope_p)) instanceof FunctionPkg) {
            result = this.getContainer(container, scope_p) instanceof ModellingArchitecture && this.isUniqueSiblingOfItsType(element_p, scope_p);
        }
        return result;
    }

    protected boolean isRootFunctionRealization(EObject element_p, IModelScope scope_p) {
        boolean result = false;
        if (element_p instanceof FunctionRealization) {
            FunctionRealization realization = (FunctionRealization)element_p;
            result = this.isRootFunction((EObject)realization.getAllocatedFunction(), scope_p) && this.isRootFunction((EObject)realization.getAllocatingFunction(), scope_p);
        }
        return result;
    }

    protected boolean isSystemComponent(EObject element_p, IModelScope scope_p) {
        return element_p instanceof Component && this.getContainer(element_p, scope_p) instanceof ModellingArchitecture;
    }

    protected boolean isSystemComponentAllocation(EObject element_p, IModelScope scope_p) {
        boolean result = false;
        if (element_p instanceof ComponentAllocation) {
            ComponentAllocation allocation = (ComponentAllocation)element_p;
            result = this.isSystemComponent((EObject)allocation.getAllocatedComponent(), scope_p) && this.isSystemComponent((EObject)allocation.getAllocatingComponent(), scope_p);
        }
        return result;
    }

    protected boolean isSystemComponentPart(EObject element_p, IModelScope scope_p) {
        boolean result = false;
        if (element_p instanceof Part && this.getContainer(element_p, scope_p) instanceof ComponentContext) {
            Part part = (Part)element_p;
            result = this.isSystemComponent((EObject)part.getType(), scope_p);
        }
        return result;
    }

    protected boolean isSystemStateMachine(EObject element_p, IModelScope scope_p) {
        boolean result = false;
        if (element_p instanceof StateMachine) {
            EObject container = this.getContainer(element_p, scope_p);
            result = container instanceof System && this.isSystemComponent(container, scope_p) && this.isUniqueSiblingOfItsType(element_p, scope_p);
        }
        return result;
    }

    protected boolean isSystemStateMachineMainRegion(EObject element_p, IModelScope scope_p) {
        return element_p instanceof Region && this.isSystemStateMachine(this.getContainer(element_p, scope_p), scope_p) && this.isUniqueSiblingOfItsType(element_p, scope_p);
    }

    protected boolean isTechnical(EObject element_p) {
        return element_p instanceof AbstractTrace || element_p instanceof AbstractCapabilityInclude || element_p instanceof AbstractDeploymentLink || element_p instanceof CapabilityExploitation || element_p instanceof CommunicationLink || element_p instanceof ComponentExchangeEnd || element_p instanceof ExchangeItemAllocation || element_p instanceof Generalization || element_p instanceof InterfaceImplementation || element_p instanceof InterfaceUse || element_p instanceof Involvement && !(element_p instanceof FunctionalChainInvolvement) || element_p instanceof ValuePart || element_p instanceof KeyValue || element_p instanceof LibraryReference || element_p instanceof PhysicalLinkEnd;
    }

    protected boolean isUniqueModelingArchitectureChild(EObject element_p, IModelScope scope_p) {
        return this.getContainer(element_p, scope_p) instanceof ModellingArchitecture && this.isInDiscriminatingContainment(element_p, scope_p);
    }

    protected static enum UniqueNameRequirementKind {
        NONE,
        IN_CONTAINER,
        IN_CONTAINMENT;

    }
}

