/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.commands;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.refinement.commands.Messages;
import org.polarsys.capella.core.refinement.subscenario.SubScenarioUtils;

public class AddExistingSubScenarioCommand
extends AbstractReadWriteCommand {
    private ModelElement modelElement = null;
    private IProgressMonitor progressMonitor = null;

    public AddExistingSubScenarioCommand(ModelElement modelElement, IProgressMonitor progressMonitor) {
        this.modelElement = modelElement;
        this.progressMonitor = progressMonitor;
    }

    public void run() {
        LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
        try {
            if (this.modelElement != null) {
                Display display;
                if (ScenarioExt.isMultiInstanceRole((Scenario)((Scenario)this.modelElement)) && (display = PlatformUI.getWorkbench().getDisplay()) != null) {
                    if (!MessageDialog.openConfirm((Shell)display.getActiveShell(), (String)Messages.MultiInstanceRoleExtension_title, (String)Messages.MultiInstanceRoleExtension_message)) {
                        return;
                    }
                    Logger logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
                    logger.warn((Object)(String.valueOf(Messages.MultiInstanceRoleExtension_logmsg_confirm) + EObjectLabelProviderHelper.getText((EObject)this.modelElement)));
                }
                SubScenarioUtils.addExistingSubScenario((Scenario)((Scenario)this.modelElement), (IProgressMonitor)this.progressMonitor);
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
    }

    public String getName() {
        return "Add existing sub Scenario";
    }
}

